/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;

public final class PlatformUtils {
    private PlatformUtils() {
    }

    public static Set<Platform> determineNativePlatforms(Chunk chunk) {
        if (chunk instanceof MCRegionChunk) {
            return Collections.singleton(DefaultPlugin.JAVA_MCREGION);
        }
        if (chunk instanceof MC12AnvilChunk) {
            return Collections.singleton(DefaultPlugin.JAVA_ANVIL);
        }
        if (chunk instanceof MC115AnvilChunk) {
            if (((MC115AnvilChunk)chunk).getInputDataVersion() > 2586) {
                return Collections.singleton(DefaultPlugin.JAVA_ANVIL_1_17);
            }
            return ImmutableSet.of((Object)DefaultPlugin.JAVA_ANVIL_1_15, (Object)DefaultPlugin.JAVA_ANVIL_1_17);
        }
        if (chunk instanceof MC118AnvilChunk) {
            if (((MC118AnvilChunk)chunk).getInputDataVersion() > 2975) {
                return Collections.singleton(DefaultPlugin.JAVA_ANVIL_1_19);
            }
            return Collections.singleton(DefaultPlugin.JAVA_ANVIL_1_18);
        }
        return null;
    }
}

