/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.pepsoft.worldpainter.exporting.BlockBasedExportSettings;

public class JavaExportSettings
extends BlockBasedExportSettings {
    final FloatMode waterMode;
    final FloatMode lavaMode;
    final FloatMode sandMode;
    final FloatMode gravelMode;
    final FloatMode cementMode;
    final boolean flowWater;
    final boolean flowLava;
    boolean calculateSkyLight;
    boolean calculateBlockLight;
    boolean calculateLeafDistance;
    final boolean removeFloatingLeaves;
    final boolean makeAllLeavesPersistent;
    int version = 1;
    final boolean leavePlants;
    private static final int CURRENT_VERSION = 1;
    private static final long serialVersionUID = 1L;

    public JavaExportSettings() {
        this.waterMode = FloatMode.DROP;
        this.lavaMode = FloatMode.DROP;
        this.sandMode = FloatMode.LEAVE_FLOATING;
        this.gravelMode = FloatMode.LEAVE_FLOATING;
        this.cementMode = FloatMode.LEAVE_FLOATING;
        this.flowWater = true;
        this.flowLava = true;
        this.calculateSkyLight = true;
        this.calculateBlockLight = true;
        this.calculateLeafDistance = true;
        this.removeFloatingLeaves = false;
        this.makeAllLeavesPersistent = false;
        this.leavePlants = false;
    }

    public JavaExportSettings(FloatMode waterMode, FloatMode lavaMode, FloatMode sandMode, FloatMode gravelMode, FloatMode cementNode, boolean flowWater, boolean flowLava, boolean calculateSkyLight, boolean calculateBlockLight, boolean calculateLeafDistance, boolean removeFloatingLeaves, boolean makeAllLeavesPersistent, boolean removePlants) {
        if (waterMode == null || lavaMode == null || sandMode == null || gravelMode == null || cementNode == null) {
            throw new NullPointerException();
        }
        if (removeFloatingLeaves && !calculateLeafDistance) {
            throw new IllegalArgumentException("removeFloatingLeaves requires calculateLeafDistance");
        }
        this.waterMode = waterMode;
        this.lavaMode = lavaMode;
        this.sandMode = sandMode;
        this.gravelMode = gravelMode;
        this.cementMode = cementNode;
        this.flowWater = flowWater;
        this.flowLava = flowLava;
        this.calculateSkyLight = calculateSkyLight;
        this.calculateBlockLight = calculateBlockLight;
        this.calculateLeafDistance = calculateLeafDistance;
        this.removeFloatingLeaves = removeFloatingLeaves;
        this.makeAllLeavesPersistent = makeAllLeavesPersistent;
        this.leavePlants = !removePlants;
    }

    public FloatMode getWaterMode() {
        return this.waterMode;
    }

    public FloatMode getLavaMode() {
        return this.lavaMode;
    }

    public FloatMode getSandMode() {
        return this.sandMode;
    }

    public FloatMode getGravelMode() {
        return this.gravelMode;
    }

    public FloatMode getCementMode() {
        return this.cementMode;
    }

    public boolean isFlowWater() {
        return this.flowWater;
    }

    public boolean isFlowLava() {
        return this.flowLava;
    }

    @Override
    public boolean isCalculateSkyLight() {
        return this.calculateSkyLight;
    }

    @Override
    public boolean isCalculateBlockLight() {
        return this.calculateBlockLight;
    }

    @Override
    public boolean isCalculateLeafDistance() {
        return this.calculateLeafDistance;
    }

    @Override
    public boolean isRemoveFloatingLeaves() {
        return this.removeFloatingLeaves;
    }

    public boolean isMakeAllLeavesPersistent() {
        return this.makeAllLeavesPersistent;
    }

    public JavaExportSettings withMakeAllLeavesPersistent(boolean makeAllLeavesPersistent) {
        return new JavaExportSettings(this.waterMode, this.lavaMode, this.sandMode, this.gravelMode, this.cementMode, this.flowWater, this.flowLava, this.calculateSkyLight, this.calculateBlockLight, this.calculateLeafDistance, this.removeFloatingLeaves, makeAllLeavesPersistent, !this.leavePlants);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaExportSettings that = (JavaExportSettings)o;
        return this.flowWater == that.flowWater && this.flowLava == that.flowLava && this.calculateSkyLight == that.calculateSkyLight && this.calculateBlockLight == that.calculateBlockLight && this.calculateLeafDistance == that.calculateLeafDistance && this.waterMode == that.waterMode && this.lavaMode == that.lavaMode && this.sandMode == that.sandMode && this.gravelMode == that.gravelMode && this.cementMode == that.cementMode && this.removeFloatingLeaves == that.removeFloatingLeaves && this.makeAllLeavesPersistent == that.makeAllLeavesPersistent && this.leavePlants == that.leavePlants;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.waterMode, this.lavaMode, this.sandMode, this.gravelMode, this.cementMode, this.flowWater, this.flowLava, this.calculateSkyLight, this.calculateBlockLight, this.calculateLeafDistance, this.removeFloatingLeaves, this.makeAllLeavesPersistent, this.leavePlants});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.version < 1) {
            this.calculateSkyLight = true;
            this.calculateBlockLight = true;
            this.calculateLeafDistance = true;
        }
        this.version = 1;
    }

    public boolean isRemovePlants() {
        return !this.leavePlants;
    }

    public static enum FloatMode {
        DROP,
        SUPPORT,
        LEAVE_FLOATING;

    }
}

