/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import org.pepsoft.minecraft.Material;
import org.pepsoft.util.Box;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.PostProcessor;
import org.pepsoft.worldpainter.objects.MinecraftWorldObject;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;

public class Java1_15PostProcessor
extends PostProcessor {
    @Override
    public void postProcess(MinecraftWorld minecraftWorld, Box volume, ExportSettings exportSettings, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Material material;
        int z;
        int columnMaxZ;
        Material materialAbove;
        Material materialBelow;
        int y;
        int x;
        int maxZ;
        int minZ;
        int y2;
        int y1;
        int x2;
        int x1;
        if (!enabled) {
            return;
        }
        if (progressReceiver != null) {
            progressReceiver.setMessage("Post processing exported blocks (first pass)");
        }
        int worldMinZ = minecraftWorld.getMinHeight();
        int worldMaxZ = minecraftWorld.getMaxHeight() - 1;
        JavaExportSettings settings = exportSettings instanceof JavaExportSettings ? (JavaExportSettings)exportSettings : new JavaExportSettings();
        JavaExportSettings.FloatMode sandMode = "false".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.supportSand")) ? JavaExportSettings.FloatMode.LEAVE_FLOATING : settings.sandMode;
        JavaExportSettings.FloatMode gravelMode = settings.gravelMode;
        JavaExportSettings.FloatMode cementMode = settings.cementMode;
        JavaExportSettings.FloatMode waterMode = settings.waterMode;
        JavaExportSettings.FloatMode lavaMode = settings.lavaMode;
        boolean flowLava = settings.flowLava;
        boolean flowWater = settings.flowWater;
        boolean makeAllLeavesPersistent = settings.makeAllLeavesPersistent;
        boolean leavePlants = settings.leavePlants;
        if (minecraftWorld instanceof MinecraftWorldObject) {
            Box objectVolume = ((MinecraftWorldObject)minecraftWorld).getVolume();
            objectVolume.intersect(volume);
            if (objectVolume.isEmpty()) {
                return;
            }
            x1 = objectVolume.getX1();
            x2 = objectVolume.getX2() - 1;
            y1 = objectVolume.getY1();
            y2 = objectVolume.getY2() - 1;
            minZ = objectVolume.getZ1();
            maxZ = objectVolume.getZ2() - 1;
        } else {
            x1 = volume.getX1();
            y1 = volume.getY1();
            x2 = volume.getX2() - 1;
            y2 = volume.getY2() - 1;
            minZ = volume.getZ1();
            maxZ = volume.getZ2() - 1;
        }
        for (x = x1; x <= x2; ++x) {
            for (y = y1; y <= y2; ++y) {
                materialBelow = minZ <= worldMinZ ? Material.AIR : minecraftWorld.getMaterialAt(x, y, minZ - 1);
                materialAbove = minZ < worldMinZ ? Material.AIR : minecraftWorld.getMaterialAt(x, y, minZ);
                columnMaxZ = Math.min(minecraftWorld.getHighestNonAirBlock(x, y), maxZ);
                for (z = minZ; z <= columnMaxZ; ++z) {
                    material = materialAbove;
                    Material material2 = materialAbove = z < worldMaxZ ? minecraftWorld.getMaterialAt(x, y, z + 1) : Material.AIR;
                    if (materialBelow.isNamedOneOf("minecraft:grass_block", "minecraft:mycelium", "minecraft:farmland", "minecraft:dirt_path", "minecraft:grass_path") && (material.containsWater() || material == Material.ICE || material.opaque)) {
                        minecraftWorld.setMaterialAt(x, y, z - 1, Material.DIRT);
                        materialBelow = Material.DIRT;
                    } else if (materialBelow.isNamedOneOf("minecraft:warped_nylium", "minecraft:crimson_nylium") && material.opaque) {
                        minecraftWorld.setMaterialAt(x, y, z - 1, Material.NETHERRACK);
                        materialBelow = Material.NETHERRACK;
                    } else if (makeAllLeavesPersistent && material.leafBlock && !material.is(Material.PERSISTENT)) {
                        material = material.withProperty(Material.PERSISTENT, true);
                        minecraftWorld.setMaterialAt(x, y, z, material);
                    }
                    if (materialBelow.hasPropertySnowy) {
                        if (material.isNamed("minecraft:snow") || material.isNamed("minecraft:snow_block") || material.isNamedOneOf("minecraft:powder_snow")) {
                            if (!materialBelow.is(Material.SNOWY)) {
                                materialBelow = materialBelow.withProperty(Material.SNOWY, true);
                                minecraftWorld.setMaterialAt(x, y, z - 1, materialBelow);
                            }
                        } else if (materialBelow.is(Material.SNOWY)) {
                            materialBelow = materialBelow.withProperty(Material.SNOWY, false);
                            minecraftWorld.setMaterialAt(x, y, z - 1, materialBelow);
                        }
                    }
                    if (material.blockType == 175 && (material.data & 8) == 8 && materialBelow.blockType == 175) {
                        material = materialBelow.withProperty(Material.HALF, "upper");
                        minecraftWorld.setMaterialAt(x, y, z, material);
                    }
                    block24 : switch (material.name) {
                        case "minecraft:sand": 
                        case "minecraft:red_sand": {
                            if (!materialBelow.veryInsubstantial) break;
                            switch (sandMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    material = Material.AIR;
                                    break block24;
                                }
                                case SUPPORT: {
                                    minecraftWorld.setMaterialAt(x, y, z, material == Material.RED_SAND ? Material.RED_SANDSTONE : Material.SANDSTONE);
                                    material = minecraftWorld.getMaterialAt(x, y, z);
                                    break block24;
                                }
                            }
                            break;
                        }
                        case "minecraft:gravel": {
                            if (!materialBelow.veryInsubstantial) break;
                            switch (gravelMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    material = Material.AIR;
                                    break block24;
                                }
                                case SUPPORT: {
                                    minecraftWorld.setMaterialAt(x, y, z, Material.STONE);
                                    material = Material.STONE;
                                    break block24;
                                }
                            }
                            break;
                        }
                        case "minecraft:white_concrete_powder": 
                        case "minecraft:orange_concrete_powder": 
                        case "minecraft:magenta_concrete_powder": 
                        case "minecraft:light_blue_concrete_powder": 
                        case "minecraft:yellow_concrete_powder": 
                        case "minecraft:lime_concrete_powder": 
                        case "minecraft:pink_concrete_powder": 
                        case "minecraft:gray_concrete_powder": 
                        case "minecraft:light_gray_concrete_powder": 
                        case "minecraft:cyan_concrete_powder": 
                        case "minecraft:purple_concrete_powder": 
                        case "minecraft:blue_concrete_powder": 
                        case "minecraft:brown_concrete_powder": 
                        case "minecraft:green_concrete_powder": 
                        case "minecraft:red_concrete_powder": 
                        case "minecraft:black_concrete_powder": {
                            if (!materialBelow.veryInsubstantial) break;
                            switch (cementMode) {
                                case DROP: {
                                    this.dropBlock(minecraftWorld, x, y, z);
                                    material = Material.AIR;
                                    break block24;
                                }
                                case SUPPORT: {
                                    minecraftWorld.setMaterialAt(x, y, z, Material.STONE);
                                    material = Material.STONE;
                                    break block24;
                                }
                            }
                            break;
                        }
                        case "minecraft:lava": {
                            if (!materialBelow.veryInsubstantial || !materialBelow.isNotNamed("minecraft:lava")) break;
                            switch (lavaMode) {
                                case DROP: {
                                    this.dropFluid(minecraftWorld, x, y, z);
                                    break block24;
                                }
                                case SUPPORT: {
                                    throw new UnsupportedOperationException("Don't know how to support lava yet");
                                }
                            }
                            break;
                        }
                        case "minecraft:snow": {
                            if (materialBelow != Material.ICE && !materialBelow.isNamed("minecraft:snow") && materialBelow != Material.AIR && materialBelow != Material.PACKED_ICE) break;
                            material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                            break;
                        }
                        case "minecraft:fire": {
                            if (materialBelow != Material.AIR || materialAbove != Material.AIR || minecraftWorld.getMaterialAt(x - 1, y, z) != Material.AIR || minecraftWorld.getMaterialAt(x + 1, y, z) != Material.AIR || minecraftWorld.getMaterialAt(x, y - 1, z) != Material.AIR || minecraftWorld.getMaterialAt(x, y + 1, z) != Material.AIR) break;
                            material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                        }
                    }
                    if (!leavePlants) {
                        if (!materialBelow.modded) {
                            switch (material.name) {
                                case "minecraft:dead_bush": {
                                    if (!materialBelow.isNotNamedOneOf("minecraft:grass_block", "minecraft:sand", "minecraft:red_sand", "minecraft:dirt", "minecraft:terracotta", "minecraft:podzol", "minecraft:coarse_dirt", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud") || materialBelow.name.endsWith("_terracotta")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:grass": 
                                case "minecraft:fern": 
                                case "minecraft:dandelion": 
                                case "minecraft:poppy": 
                                case "minecraft:blue_orchid": 
                                case "minecraft:allium": 
                                case "minecraft:azure_bluet": 
                                case "minecraft:red_tulip": 
                                case "minecraft:orange_tulip": 
                                case "minecraft:white_tulip": 
                                case "minecraft:pink_tulip": 
                                case "minecraft:oxeye_daisy": 
                                case "minecraft:cornflower": 
                                case "minecraft:lily_of_the_valley": 
                                case "minecraft:wither_rose": 
                                case "minecraft:sweet_berry_bush": {
                                    if (!materialBelow.isNotNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:farmland", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:red_mushroom": 
                                case "minecraft:brown_mushroom": {
                                    if (!materialBelow.isNotNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:podzol", "minecraft:coarse_dirt", "minecraft:mycelium", "minecraft:stone", "minecraft:granite", "minecraft:diorite", "minecraft:andesite")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:wheat": {
                                    if (!materialBelow.isNotNamed("minecraft:farmland")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:sunflower": 
                                case "minecraft:lilac": 
                                case "minecraft:tall_grass": 
                                case "minecraft:large_fern": 
                                case "minecraft:rose_bush": 
                                case "minecraft:peony": {
                                    if (!"lower".equals(material.getProperty(Material.HALF)) || !materialBelow.isNotNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:farmland", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:cactus": {
                                    if (materialBelow == Material.SAND || materialBelow == Material.RED_SAND || !materialBelow.isNotNamed("minecraft:cactus")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:sugar_cane": {
                                    if (!materialBelow.isNotNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:podzol", "minecraft:coarse_dirt", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud", "minecraft:sand", "minecraft:red_sand", "minecraft:sugar_cane")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:nether_wart": {
                                    if (materialBelow == Material.SOUL_SAND) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:chorus_flower": 
                                case "minecraft:chorus_plant": {
                                    if (materialBelow == Material.END_STONE || !materialBelow.isNotNamed("minecraft:chorus_plant")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:kelp": 
                                case "minecraft:kelp_plant": 
                                case "minecraft:tall_seagrass": {
                                    if (materialBelow.solid && materialBelow.opaque && materialBelow.natural || materialBelow.isNamedOneOf("minecraft:kelp", "minecraft:kelp_plant", "minecraft:tall_seagrass")) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:seagrass": 
                                case "minecraft:sea_pickle": 
                                case "minecraft:tube_coral": 
                                case "minecraft:brain_coral": 
                                case "minecraft:bubble_coral": 
                                case "minecraft:fire_coral": 
                                case "minecraft:horn_coral": 
                                case "minecraft:dead_tube_coral": 
                                case "minecraft:dead_brain_coral": 
                                case "minecraft:dead_bubble_coral": 
                                case "minecraft:dead_fire_coral": 
                                case "minecraft:dead_horn_coral": 
                                case "minecraft:tube_coral_fan": 
                                case "minecraft:brain_coral_fan": 
                                case "minecraft:bubble_coral_fan": 
                                case "minecraft:fire_coral_fan": 
                                case "minecraft:horn_coral_fan": 
                                case "minecraft:dead_tube_coral_fan": 
                                case "minecraft:dead_brain_coral_fan": 
                                case "minecraft:dead_bubble_coral_fan": 
                                case "minecraft:dead_fire_coral_fan": 
                                case "minecraft:dead_horn_coral_fan": {
                                    if (materialBelow.solid && materialBelow.opaque && materialBelow.natural) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                    break;
                                }
                                case "minecraft:lily_pad": {
                                    if (materialBelow.containsWater()) break;
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                }
                            }
                        }
                        if (material.vegetation && material.isPropertySet("half")) {
                            if ("upper".equals(material.getProperty(Material.HALF))) {
                                if (materialBelow.isNotNamedSameAs(material) || !materialBelow.isPropertySet("half") || !"lower".equals(materialBelow.getProperty(Material.HALF))) {
                                    material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                                }
                            } else if (materialAbove.isNotNamedSameAs(material) || !materialAbove.isPropertySet("half") || !"upper".equals(materialAbove.getProperty(Material.HALF))) {
                                material = Java1_15PostProcessor.clearBlock(minecraftWorld, x, y, z);
                            }
                        }
                    }
                    if (material.containsWater() && materialBelow.veryInsubstantial && !materialBelow.containsWater()) {
                        switch (waterMode) {
                            case DROP: {
                                this.dropFluid(minecraftWorld, x, y, z);
                                break;
                            }
                            case SUPPORT: {
                                throw new UnsupportedOperationException("Don't know how to support water yet");
                            }
                        }
                    }
                    materialBelow = material;
                }
            }
            if (progressReceiver == null) continue;
            progressReceiver.setProgress((float)(x - x1 + 1) / (float)(x2 - x1 + 1) * 0.75f);
        }
        if (flowWater || flowLava) {
            if (progressReceiver != null) {
                progressReceiver.setMessage("Post processing exported blocks (fluids pass)");
            }
            for (x = x1; x <= x2; ++x) {
                for (y = y1; y <= y2; ++y) {
                    materialBelow = minZ + 1 <= worldMinZ ? Material.AIR : minecraftWorld.getMaterialAt(x, y, minZ);
                    materialAbove = minecraftWorld.getMaterialAt(x, y, minZ + 1);
                    columnMaxZ = Math.min(minecraftWorld.getHighestNonAirBlock(x, y), maxZ);
                    for (z = minZ + 1; z <= columnMaxZ; ++z) {
                        material = materialAbove;
                        Material material3 = materialAbove = z < worldMaxZ ? minecraftWorld.getMaterialAt(x, y, z + 1) : Material.AIR;
                        if (flowWater && this.containsAnyWater(material) && !this.isWaterContained(minecraftWorld, x, y, z, materialBelow)) {
                            minecraftWorld.markForUpdateWorld(x, y, z);
                        } else if (flowLava && material.isNamed("minecraft:lava") && !this.isLavaContained(minecraftWorld, x, y, z, materialBelow)) {
                            minecraftWorld.markForUpdateWorld(x, y, z);
                        }
                        materialBelow = material;
                    }
                }
                if (progressReceiver == null) continue;
                progressReceiver.setProgress(0.75f + (float)(x - x1 + 1) / (float)(x2 - x1 + 1) * 0.25f);
            }
        } else if (progressReceiver != null) {
            progressReceiver.setProgress(1.0f);
        }
    }

    private static Material clearBlock(MinecraftWorld minecraftWorld, int x, int y, int z) {
        if (minecraftWorld.getMaterialAt(x, y, z).containsWater()) {
            minecraftWorld.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
            return Material.STATIONARY_WATER;
        }
        minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
        return Material.AIR;
    }
}

