/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.pockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.pockets.UndergroundPocketsLayerExporter;

public class UndergroundPocketsLayer
extends CustomLayer {
    @Deprecated
    private Material material;
    private int scale;
    private int frequency;
    private int maxLevel;
    private int minLevel;
    private MixedMaterial mixedMaterial;
    private Terrain terrain;
    private static final long serialVersionUID = 1L;

    public UndergroundPocketsLayer(String name, MixedMaterial material, Terrain terrain, int frequency, int minLevel, int maxLevel, int scale, int colour) {
        super(name, "underground pockets of " + name, Layer.DataSize.NIBBLE, 15, colour);
        if (frequency < 1 || frequency > 1000) {
            throw new IllegalArgumentException("frequency < 1 or > 1000");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0");
        }
        if (maxLevel < minLevel) {
            throw new IllegalArgumentException("maxLevel < " + minLevel);
        }
        this.mixedMaterial = material;
        this.terrain = terrain;
        this.frequency = frequency;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.scale = scale;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setDescription("underground pockets of " + name);
    }

    @Override
    public String getType() {
        return "Underground Pockets";
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public MixedMaterial getMaterial() {
        return this.mixedMaterial;
    }

    public void setMaterial(MixedMaterial material) {
        this.mixedMaterial = material;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public void setMinLevel(int minLevel) {
        this.minLevel = minLevel;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return UndergroundPocketsLayerExporter.class;
    }

    @Override
    public UndergroundPocketsLayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new UndergroundPocketsLayerExporter(dimension, platform, this);
    }

    @Override
    public UndergroundPocketsLayer clone() {
        UndergroundPocketsLayer clone = (UndergroundPocketsLayer)super.clone();
        if (this.mixedMaterial != null) {
            clone.mixedMaterial = this.mixedMaterial.clone();
            MixedMaterialManager.getInstance().register(clone.mixedMaterial);
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.material != null) {
            this.mixedMaterial = MixedMaterial.create(DefaultPlugin.JAVA_ANVIL, this.material);
            this.material = null;
        }
    }
}

