/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.exporters.WPObjectExporter;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;

public class PlantLayerExporter
extends WPObjectExporter<PlantLayer>
implements SecondPassLayerExporter,
IncidentalLayerExporter {
    private final ThreadLocal<Random> incidentalRandomRef = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private final boolean empty;
    private static final Material TILLED_DIRT = Material.FARMLAND.withProperty(Material.MOISTURE, 4);

    public PlantLayerExporter(Dimension dimension, Platform platform, PlantLayer layer) {
        super(dimension, platform, null, layer);
        long total = layer.getConfiguredPlants().values().stream().mapToLong(setting -> setting.occurrence).sum();
        if (total <= 0L) {
            this.empty = true;
        } else {
            if (total > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Total occurrence of plants configured on PlantLayer \"" + layer + "\" higher than " + Integer.MAX_VALUE);
            }
            this.empty = false;
        }
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        if (this.empty) {
            return null;
        }
        long seed = this.dimension.getSeed();
        int tileX1 = exportedArea.x >> 7;
        int tileX2 = exportedArea.x + exportedArea.width - 1 >> 7;
        int tileY1 = exportedArea.y >> 7;
        int tileY2 = exportedArea.y + exportedArea.height - 1 >> 7;
        int minHeight = minecraftWorld.getMinHeight();
        int maxY = minecraftWorld.getMaxHeight() - 1;
        boolean generateTilledDirt = ((PlantLayer)this.layer).isGenerateFarmland();
        boolean blockRulesEnforced = !"false".equalsIgnoreCase(System.getProperty("org.pepsoft.worldpainter.enforceBlockRules"));
        boolean onlyOnValidBlocks = ((PlantLayer)this.layer).isOnlyOnValidBlocks();
        Bo2ObjectProvider objectProvider = ((PlantLayer)this.layer).getObjectProvider(this.platform);
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = this.dimension.getTile(tileX, tileY);
                if (tile == null || !tile.hasLayer(this.layer)) continue;
                long tileSeed = (long)tileX << 32 ^ (long)tileY ^ seed;
                objectProvider.setSeed(tileSeed);
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        int height;
                        if (!tile.getBitLayerValue(this.layer, x, y) || (height = tile.getIntHeight(x, y)) < minHeight || height >= maxY) continue;
                        int worldX = tileX << 7 | x;
                        int worldY = tileY << 7 | y;
                        Plant plant = (Plant)objectProvider.getObject();
                        Category category = plant.isValidFoundation(minecraftWorld, worldX, worldY, height, onlyOnValidBlocks);
                        if (category == null) {
                            if (blockRulesEnforced) continue;
                            PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                            continue;
                        }
                        if (category != Category.FLOATING_PLANTS) {
                            for (int dz = height + 1; dz <= minecraftWorld.getHighestNonAirBlock(worldX, worldY) && minecraftWorld.getMaterialAt((int)worldX, (int)worldY, (int)dz).vegetation; ++dz) {
                                PlantLayerExporter.clearBlock(minecraftWorld, worldX, worldY, dz);
                            }
                        }
                        if (category == Category.FLOATING_PLANTS) {
                            this.possiblyRenderFloatingPlant(minecraftWorld, this.dimension, plant, worldX, worldY, height + 1);
                            continue;
                        }
                        if (category == Category.WATER_PLANTS || category == Category.HANGING_WATER_PLANTS || category == Category.DRIPLEAF) {
                            if (plant.getMaterial(0, 0, 0).hasProperty(Material.WATERLOGGED)) {
                                PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                                continue;
                            }
                            int waterLevel = tile.getWaterLevel(x, y);
                            if (waterLevel <= height) continue;
                            if (height + plant.getDimensions().z > waterLevel) {
                                int newHeight = waterLevel - height;
                                if (newHeight < 1) continue;
                                plant = plant.realise(newHeight, this.platform);
                                if (plant.getDimensions().z > newHeight) continue;
                            }
                            PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                            continue;
                        }
                        if (category == Category.CROPS) {
                            if (minecraftWorld.getMaterialAt(worldX, worldY, height).isNamed("minecraft:farmland")) {
                                PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                                continue;
                            }
                            if (!generateTilledDirt) continue;
                            minecraftWorld.setMaterialAt(worldX, worldY, height, TILLED_DIRT);
                            PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                            continue;
                        }
                        PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, worldX, worldY, height + 1, false);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Fixup apply(Point3i location, int intensity, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        if (this.empty) {
            return null;
        }
        Random random = this.incidentalRandomRef.get();
        long seed = this.dimension.getSeed() + (long)location.x + (long)location.y * 4099L + (long)location.z * 65537L + (long)((PlantLayer)this.layer).hashCode();
        random.setSeed(seed);
        if (intensity >= 100 || intensity > 0 && random.nextInt(100) < intensity) {
            Bo2ObjectProvider objectProvider = ((PlantLayer)this.layer).getObjectProvider(this.platform);
            objectProvider.setSeed(seed + 1L);
            Plant plant = (Plant)objectProvider.getObject();
            Category category = plant.isValidFoundation(minecraftWorld, location.x, location.y, location.z - 1, ((PlantLayer)this.layer).isOnlyOnValidBlocks());
            if (category != null && location.z < minecraftWorld.getMaxHeight() - 1) {
                if (category == Category.FLOATING_PLANTS) {
                    this.possiblyRenderFloatingPlant(minecraftWorld, this.dimension, plant, location.x, location.y, location.z + 1);
                } else if (category == Category.CROPS) {
                    if (minecraftWorld.getMaterialAt(location.x, location.y, location.z - 1).isNamed("minecraft:farmland")) {
                        PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, location.x, location.y, location.z, false);
                    } else if (((PlantLayer)this.layer).isGenerateFarmland()) {
                        minecraftWorld.setMaterialAt(location.x, location.y, location.z - 1, TILLED_DIRT);
                        PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, location.x, location.y, location.z, false);
                    }
                } else {
                    PlantLayerExporter.renderObject(minecraftWorld, this.dimension, this.platform, plant, location.x, location.y, location.z, false);
                }
            }
        }
        return null;
    }

    private void possiblyRenderFloatingPlant(MinecraftWorld world, Dimension dimension, Plant plant, int x, int y, int z) {
        Material existingMaterial;
        int maxHeight = world.getMaxHeight();
        do {
            existingMaterial = world.getMaterialAt(x, y, ++z);
        } while (z < maxHeight && existingMaterial.containsWater());
        if (z < maxHeight && existingMaterial.veryInsubstantial && !existingMaterial.isNamed("minecraft:lava")) {
            PlantLayerExporter.renderObject(world, dimension, this.platform, plant, x, y, z, false);
        }
    }

    private static void clearBlock(MinecraftWorld minecraftWorld, int x, int y, int z) {
        if (minecraftWorld.getMaterialAt(x, y, z).containsWater()) {
            minecraftWorld.setMaterialAt(x, y, z, Material.STATIONARY_WATER);
        } else {
            minecraftWorld.setMaterialAt(x, y, z, Material.AIR);
        }
    }
}

