/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantLayerExporter;
import org.pepsoft.worldpainter.layers.plants.Plants;
import org.pepsoft.worldpainter.objects.WPObject;

public class PlantLayer
extends CustomLayer {
    private PlantSettings[] settings = new PlantSettings[Plants.ALL_PLANTS.length];
    private boolean generateTilledDirt = true;
    private int version = 2;
    private boolean onlyOnValidBlocks = true;
    private static final long serialVersionUID = -2758775044863488107L;

    public PlantLayer(String name, String description, int colour) {
        super(name, description, Layer.DataSize.BIT, 35, colour);
    }

    public PlantSettings getSettings(int plantIndex) {
        return this.settings[plantIndex];
    }

    public void setSettings(int plantIndex, PlantSettings settings) {
        this.settings[plantIndex] = settings;
    }

    public boolean isGenerateFarmland() {
        return this.generateTilledDirt;
    }

    public void setGenerateFarmland(boolean generateFarmland) {
        this.generateTilledDirt = generateFarmland;
    }

    public boolean isOnlyOnValidBlocks() {
        return this.onlyOnValidBlocks;
    }

    public void setOnlyOnValidBlocks(boolean onlyOnValidBlocks) {
        this.onlyOnValidBlocks = onlyOnValidBlocks;
    }

    public Map<Plant, PlantSettings> getConfiguredPlants() {
        return IntStream.range(0, this.settings.length).filter(i -> this.settings[i] != null && this.settings[i].occurrence > 0).collect(HashMap::new, (map, i) -> map.put(Plants.ALL_PLANTS[i], this.settings[i]), HashMap::putAll);
    }

    public Bo2ObjectProvider getObjectProvider(final Platform platform) {
        int total = 0;
        for (PlantSettings setting : this.settings) {
            if (setting == null) continue;
            total += setting.occurrence;
        }
        final int[] pool = new int[total];
        final int[] growthOffset = new int[total];
        final int[] growthRange = new int[total];
        int index = 0;
        for (int i = 0; i < this.settings.length; ++i) {
            if (this.settings[i] == null) continue;
            for (int j = 0; j < this.settings[i].occurrence; ++j) {
                growthOffset[index] = this.settings[i].growthFrom;
                growthRange[index] = (byte)(this.settings[i].growthTo - this.settings[i].growthFrom);
                pool[index++] = i;
            }
        }
        return new Bo2ObjectProvider(){
            private final Random random = new Random();

            @Override
            public String getName() {
                return PlantLayer.this.getName();
            }

            @Override
            public WPObject getObject() {
                int index = this.random.nextInt(pool.length);
                Plant plant = Plants.ALL_PLANTS[pool[index]];
                if (growthRange[index] == 0) {
                    return plant.realise(growthOffset[index], platform);
                }
                return plant.realise(growthOffset[index] + this.random.nextInt(growthRange[index] + 1), platform);
            }

            @Override
            public List<WPObject> getAllObjects() {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public void setSeed(long seed) {
                this.random.setSeed(seed);
            }

            @Override
            public Bo2ObjectProvider clone() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return PlantLayerExporter.class;
    }

    @Override
    public PlantLayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new PlantLayerExporter(dimension, platform, this);
    }

    @Override
    public String getType() {
        return "Plants";
    }

    @Override
    public PlantLayer clone() {
        PlantLayer clone = (PlantLayer)super.clone();
        clone.settings = new PlantSettings[this.settings.length];
        for (int i = 0; i < this.settings.length; ++i) {
            clone.settings[i] = this.settings[i] != null ? this.settings[i].clone() : null;
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.settings.length < Plants.ALL_PLANTS.length) {
            PlantSettings[] newSettings = new PlantSettings[Plants.ALL_PLANTS.length];
            System.arraycopy(this.settings, 0, newSettings, 0, this.settings.length);
            this.settings = newSettings;
        }
        if (this.version < 1) {
            for (int i = 0; i < this.settings.length; ++i) {
                if (this.settings[i] == null) continue;
                if (Plants.ALL_PLANTS[i].material.isNamedOneOf("minecraft:carrots", "minecraft:potatoes")) {
                    this.settings[i].growthFrom = this.settings[i].dataValueFrom == 3 ? 8 : this.settings[i].dataValueFrom * 2 + 1;
                    this.settings[i].growthTo = this.settings[i].dataValueTo == 3 ? 8 : this.settings[i].dataValueTo * 2 + 1;
                } else if (Plants.ALL_PLANTS[i].material.isNamed("minecraft:nether_wart")) {
                    this.settings[i].growthFrom = this.settings[i].dataValueFrom > 0 ? this.settings[i].dataValueFrom + 2 : 1;
                    this.settings[i].growthTo = this.settings[i].dataValueTo > 0 ? this.settings[i].dataValueTo + 2 : 1;
                } else {
                    this.settings[i].growthFrom = this.settings[i].dataValueFrom + 1;
                    this.settings[i].growthTo = this.settings[i].dataValueTo + 1;
                }
                this.settings[i].dataValueFrom = (byte)-1;
                this.settings[i].dataValueTo = (byte)-1;
            }
        }
        if (this.version < 2) {
            this.onlyOnValidBlocks = true;
        }
        this.version = 2;
    }

    public static class PlantSettings
    implements Serializable,
    Cloneable {
        short occurrence;
        @Deprecated
        byte dataValueFrom = (byte)-1;
        @Deprecated
        byte dataValueTo = (byte)-1;
        int growthFrom;
        int growthTo;
        private static final long serialVersionUID = 1L;

        public PlantSettings clone() {
            try {
                return (PlantSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

