/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.objects.WPObject;

public abstract class Plant
implements WPObject {
    protected final String name;
    protected final String iconName;
    protected final Material material;
    protected final Category[] categories;

    protected Plant(String name, Material material, String iconName, Category ... categories) {
        this.name = name;
        this.material = material;
        this.categories = categories;
        this.iconName = iconName;
    }

    public final Category[] getCategories() {
        return this.categories;
    }

    public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
        for (Category category : this.categories) {
            if (!category.isValidFoundation(world, x, y, height, checkBlockBelow)) continue;
            return category;
        }
        return null;
    }

    public int getMaxGrowth() {
        return 1;
    }

    public int getDefaultGrowth() {
        return this.getMaxGrowth();
    }

    public Plant realise(int growth, Platform platform) {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Plant is unmodifiable");
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.material;
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return true;
    }

    @Override
    public List<Entity> getEntities() {
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return null;
    }

    @Override
    public void prepareForExport(Dimension dimension) {
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return null;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        throw new UnsupportedOperationException("Plant is unmodifiable");
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        throw new UnsupportedOperationException("Plant is unmodifiable");
    }

    @Override
    public Point3i getOffset() {
        return new Point3i(0, 0, 0);
    }

    @Override
    public WPObject clone() {
        return this;
    }

    public String toString() {
        return this.name;
    }

    String getIconName() {
        return this.iconName;
    }
}

