/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.layers.plants.Plant;

class DoubleHighPlant
extends Plant {
    private final Platform platform;
    private static final Material UPPER_DOUBLE_HIGH_PLANT = Material.get(175, 8);
    private static final Point3i DIMENSIONS = new Point3i(1, 1, 2);

    DoubleHighPlant(String name, Material lowerMaterial, Category category) {
        super(name, lowerMaterial, "block/" + lowerMaterial.simpleName + "_top.png", category);
        this.platform = null;
    }

    DoubleHighPlant(String name, Material lowerMaterial, String iconName, Category category) {
        super(name, lowerMaterial, iconName, category);
        this.platform = null;
    }

    protected DoubleHighPlant(String name, Material lowerMaterial, Category category, Platform platform) {
        super(name, lowerMaterial, "block/" + lowerMaterial.simpleName + "_top.png", category);
        this.platform = platform;
    }

    private DoubleHighPlant(String name, Material lowerMaterial, Category[] categories, String iconName, Platform platform) {
        super(name, lowerMaterial, iconName, categories);
        this.platform = platform;
    }

    @Override
    public Point3i getDimensions() {
        return DIMENSIONS;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        if (z > 0) {
            if (this.platform != null && this.platform.capabilities.contains((Object)Platform.Capability.NAME_BASED)) {
                return this.material.withProperty("half", "upper");
            }
            return UPPER_DOUBLE_HIGH_PLANT;
        }
        return this.material;
    }

    @Override
    public DoubleHighPlant realise(int growth, Platform platform) {
        return new DoubleHighPlant(this.name, this.material, this.categories, this.iconName, platform);
    }
}

