/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.util.List;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class VoidExporter
extends AbstractLayerExporter<Void>
implements SecondPassLayerExporter {
    private final PerlinNoise noise = new PerlinNoise(0L);
    private static final long SEED_OFFSET = 142644289L;

    public VoidExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings, Void.INSTANCE);
    }

    @Override
    public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        if (this.noise.getSeed() != this.dimension.getSeed() + 142644289L) {
            this.noise.setSeed(this.dimension.getSeed() + 142644289L);
        }
        for (int x = area.x; x < area.x + area.width; ++x) {
            for (int y = area.y; y < area.y + area.height; ++y) {
                if (!this.dimension.getBitLayerValueAt(Void.INSTANCE, x, y) || !(this.dimension.getDistanceToEdge(Void.INSTANCE, x, y, 2.0f) < 2.0f)) continue;
                this.processEdgeColumn(this.dimension, x, y, minecraftWorld);
            }
        }
        return null;
    }

    private void processEdgeColumn(Dimension dimension, int x, int y, MinecraftWorld minecraftWorld) {
        int minHeight = minecraftWorld.getMinHeight();
        int r = 3;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                int y2;
                int x2;
                if (dx == 0 && dy == 0 || dimension.getBitLayerValueAt(Void.INSTANCE, x2 = x + dx, y2 = y + dy)) continue;
                float distance = MathUtils.getDistance((int)dx, (int)dy);
                float height = dimension.getHeightAt(x2, y2) - (float)minHeight;
                int depth = (int)Math.round((double)height / Math.pow(2.0, distance + this.noise.getPerlinNoise((double)((float)x2 / 16.411f), (double)((float)y2 / 16.411f))));
                for (int z = 0; z < depth; ++z) {
                    minecraftWorld.setMaterialAt(x2, y2, z + minHeight, Material.AIR);
                }
            }
        }
        if (!dimension.getAnchor().invert) {
            int highestNonAirBlock = Integer.MIN_VALUE;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    int highestNonAirBlockForColumn = minecraftWorld.getHighestNonAirBlock(x + dx, y + dy);
                    if (highestNonAirBlockForColumn <= highestNonAirBlock) continue;
                    highestNonAirBlock = highestNonAirBlockForColumn;
                }
            }
            for (int z = highestNonAirBlock; z >= minHeight && !minecraftWorld.getMaterialAt(x, y, z).isNamed("minecraft:water") && !minecraftWorld.getMaterialAt(x, y, z).isNamed("minecraft:lava"); --z) {
                if (this.isWaterAndNotVoid(dimension, minecraftWorld, x - 1, y, z) || this.isWaterAndNotVoid(dimension, minecraftWorld, x, y - 1, z) || this.isWaterAndNotVoid(dimension, minecraftWorld, x + 1, y, z) || this.isWaterAndNotVoid(dimension, minecraftWorld, x, y + 1, z)) {
                    minecraftWorld.setMaterialAt(x, y, z, Material.FLOWING_WATER);
                    --z;
                    while (z >= minHeight) {
                        minecraftWorld.setMaterialAt(x, y, z, Material.FALLING_WATER);
                        --z;
                    }
                } else {
                    if (!this.isLavaAndNotVoid(dimension, minecraftWorld, x - 1, y, z) && !this.isLavaAndNotVoid(dimension, minecraftWorld, x, y - 1, z) && !this.isLavaAndNotVoid(dimension, minecraftWorld, x + 1, y, z) && !this.isLavaAndNotVoid(dimension, minecraftWorld, x, y + 1, z)) continue;
                    minecraftWorld.setMaterialAt(x, y, z, Material.FLOWING_LAVA);
                    --z;
                    while (z >= minHeight) {
                        minecraftWorld.setMaterialAt(x, y, z, Material.FALLING_LAVA);
                        --z;
                    }
                }
                break;
            }
        }
    }

    private boolean isWaterAndNotVoid(Dimension dimension, MinecraftWorld minecraftWorld, int x, int y, int z) {
        return !dimension.getBitLayerValueAt(Void.INSTANCE, x, y) && minecraftWorld.getMaterialAt(x, y, z).isNamed("minecraft:water");
    }

    private boolean isLavaAndNotVoid(Dimension dimension, MinecraftWorld minecraftWorld, int x, int y, int z) {
        return !dimension.getBitLayerValueAt(Void.INSTANCE, x, y) && minecraftWorld.getMaterialAt(x, y, z).isNamed("minecraft:lava");
    }
}

