/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.DeciduousForest;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.PineForest;
import org.pepsoft.worldpainter.layers.TreeLayer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.trees.TreeType;

public class TreesExporter<T extends TreeLayer>
extends AbstractLayerExporter<T>
implements SecondPassLayerExporter,
IncidentalLayerExporter {
    private final ThreadLocal<PerlinNoise> perlinNoiseRef = new ThreadLocal();
    private static final long SEED_OFFSET = 61380672L;

    public TreesExporter(Dimension dimension, Platform platform, ExporterSettings settings, T layer) {
        super(dimension, platform, settings != null ? settings : new TreeLayerSettings<T>(layer), layer);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        TreeLayerSettings settings = (TreeLayerSettings)this.settings;
        int minimumLevel = settings.getMinimumLevel();
        int treeChance = settings.getTreeChance();
        int maxWaterDepth = settings.getMaxWaterDepth();
        int layerStrengthCap = settings.getLayerStrengthCap();
        for (int chunkX = area.x; chunkX < area.x + area.width; chunkX += 16) {
            for (int chunkY = area.y; chunkY < area.y + area.height; chunkY += 16) {
                long seed = this.dimension.getSeed() + (long)(chunkX >> 4) * 65537L + (long)(chunkY >> 4) * 4099L + (long)((TreeLayer)this.layer).hashCode();
                Random random = new Random(seed);
                for (int x = chunkX; x < chunkX + 16; ++x) {
                    for (int y = chunkY; y < chunkY + 16; ++y) {
                        int waterDepth;
                        int height = this.dimension.getIntHeightAt(x, y);
                        if (height == Integer.MIN_VALUE || height >= this.maxZ) continue;
                        int strength = Math.max(minimumLevel, this.dimension.getLayerValueAt(this.layer, x, y));
                        int cappedStrength = Math.min(strength, layerStrengthCap);
                        if (strength <= 0 || random.nextInt(treeChance) > cappedStrength * cappedStrength || (waterDepth = this.dimension.getWaterLevelAt(x, y) - height) > maxWaterDepth) continue;
                        Material blockTypeUnderTree = minecraftWorld.getMaterialAt(x, y, height);
                        Material blockTypeAtTree = minecraftWorld.getMaterialAt(x, y, height + 1);
                        if (blockTypeUnderTree == Material.AIR || blockTypeUnderTree.isNamed("minecraft:water") || blockTypeAtTree.isNamed("minecraft:lava") || !blockTypeAtTree.veryInsubstantial || !this.room(this.dimension, x, y, minecraftWorld)) continue;
                        this.renderTree((TreeLayer)this.layer, x, y, height, strength, minecraftWorld, this.dimension, new Random(seed + (long)x * 65537L + (long)y), seed);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Fixup apply(Point3i location, int intensity, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        TreeLayerSettings settings = (TreeLayerSettings)this.settings;
        int treeChance = settings.getTreeChance();
        int maxWaterDepth = settings.getMaxWaterDepth();
        int layerStrengthCap = settings.getLayerStrengthCap();
        long seed = this.dimension.getSeed() + (long)location.x * 65537L + (long)location.y * 4099L + (long)location.z + (long)((TreeLayer)this.layer).hashCode();
        Random random = new Random(seed);
        int strength = intensity * 15 / 100;
        int cappedStrength = Math.min(strength, layerStrengthCap);
        if (strength > 0 && random.nextInt(treeChance) <= cappedStrength * cappedStrength) {
            int waterDepth = this.dimension.getWaterLevelAt(location.x, location.y) - (location.z - 1);
            if (waterDepth > maxWaterDepth) {
                return null;
            }
            Material blockTypeUnderTree = minecraftWorld.getMaterialAt(location.x, location.y, location.z - 1);
            Material blockTypeAtTree = minecraftWorld.getMaterialAt(location.x, location.y, location.z);
            if (blockTypeUnderTree == Material.AIR || blockTypeUnderTree.isNamed("minecraft:water") || blockTypeAtTree.isNamed("minecraft:lava") || !blockTypeAtTree.veryInsubstantial) {
                return null;
            }
            if (this.room(this.dimension, location.x, location.y, minecraftWorld)) {
                this.renderTree((TreeLayer)this.layer, location.x, location.y, location.z - 1, strength, minecraftWorld, this.dimension, random, seed);
            }
        }
        return null;
    }

    private boolean room(Dimension dimension, int x, int y, MinecraftWorld minecraftWorld) {
        return this.room(dimension, x, y, -1, -1, minecraftWorld) && this.room(dimension, x, y, -1, 0, minecraftWorld) && this.room(dimension, x, y, -1, 1, minecraftWorld) && this.room(dimension, x, y, 0, -1, minecraftWorld) && this.room(dimension, x, y, 0, 0, minecraftWorld) && this.room(dimension, x, y, 0, 1, minecraftWorld) && this.room(dimension, x, y, 1, -1, minecraftWorld) && this.room(dimension, x, y, 1, 0, minecraftWorld) && this.room(dimension, x, y, 1, 1, minecraftWorld);
    }

    private boolean room(Dimension dimension, int x, int y, int dx, int dy, MinecraftWorld minecraftWorld) {
        int height = dimension.getIntHeightAt(x + dx, y + dy);
        return height >= this.minHeight && height < this.maxZ && !minecraftWorld.getMaterialAt((int)(x + dx), (int)(y + dy), (int)(height + 1)).sustainsLeaves && dimension.getLayerValueAt(GardenCategory.INSTANCE, x + dx, y + dy) == 0;
    }

    private void renderTree(TreeLayer layer, int x, int y, int height, int strength, MinecraftWorld minecraftWorld, Dimension dimension, Random random, long seed) {
        TreeType treeRenderer = layer.pickTree(random);
        treeRenderer.renderTree(x, y, height, strength, minecraftWorld, dimension, random);
        this.renderMushrooms(x, y, height, strength, minecraftWorld, random, seed);
    }

    private void renderMushrooms(int blockInWorldX, int blockInWorldY, int height, int strength, MinecraftWorld minecraftWorld, Random random, long seed) {
        int size;
        int r;
        if (height > minecraftWorld.getMaxHeight() - 2) {
            return;
        }
        TreeLayerSettings settings = (TreeLayerSettings)this.settings;
        int mushroomIncidence = settings.getMushroomIncidence();
        float mushroomChance = settings.getMushroomChance();
        PerlinNoise perlinNoise = this.perlinNoiseRef.get();
        if (perlinNoise == null) {
            perlinNoise = new PerlinNoise(seed);
            this.perlinNoiseRef.set(perlinNoise);
        }
        if (perlinNoise.getSeed() != seed + 61380672L) {
            perlinNoise.setSeed(seed + 61380672L);
        }
        if ((r = Math.min((size = Math.min(2 + strength / 3, 5) + random.nextInt(3)) / 2, 3)) > 0) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    if (dx == 0 && dy == 0) continue;
                    int rnd = random.nextInt(mushroomIncidence);
                    int x = blockInWorldX + dx;
                    int y = blockInWorldY + dy;
                    if (rnd != 0 || minecraftWorld.getMaterialAt(x, y, height) == Material.AIR || minecraftWorld.getMaterialAt(x, y, height + 1) != Material.AIR) continue;
                    float chance = perlinNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)height / 16.411f));
                    if (chance > mushroomChance) {
                        minecraftWorld.setMaterialAt(x, y, height + 1, Material.BROWN_MUSHROOM);
                        continue;
                    }
                    if (!(chance < -mushroomChance)) continue;
                    minecraftWorld.setMaterialAt(x, y, height + 1, Material.RED_MUSHROOM);
                }
            }
        }
    }

    @Deprecated
    public static class PineSettings
    implements ExporterSettings {
        private int minimumLevel;
        private static final long serialVersionUID = 2011071601L;

        @Override
        public boolean isApplyEverywhere() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public PineForest getLayer() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public PineSettings clone() {
            throw new UnsupportedOperationException("Not supported");
        }

        private Object readResolve() throws ObjectStreamException {
            TreeLayerSettings<PineForest> settings = new TreeLayerSettings<PineForest>(PineForest.INSTANCE);
            settings.setMinimumLevel(this.minimumLevel);
            return settings;
        }
    }

    @Deprecated
    public static class DeciduousSettings
    implements ExporterSettings {
        private int minimumLevel;
        private static final long serialVersionUID = 2011060801L;

        @Override
        public boolean isApplyEverywhere() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public DeciduousForest getLayer() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public ExporterSettings clone() {
            throw new UnsupportedOperationException("Not supported");
        }

        private Object readResolve() throws ObjectStreamException {
            TreeLayerSettings<DeciduousForest> settings = new TreeLayerSettings<DeciduousForest>(DeciduousForest.INSTANCE);
            settings.setMinimumLevel(this.minimumLevel);
            return settings;
        }
    }

    public static class TreeLayerSettings<T extends TreeLayer>
    implements ExporterSettings {
        private final T layer;
        private int minimumLevel;
        private int maxWaterDepth;
        private int treeChance;
        private int mushroomIncidence;
        private int layerStrengthCap;
        private float mushroomChance;
        private static final long serialVersionUID = 1L;

        public TreeLayerSettings(T layer) {
            this.layer = layer;
            this.treeChance = ((TreeLayer)layer).getDefaultTreeChance();
            this.maxWaterDepth = ((TreeLayer)layer).getDefaultMaxWaterDepth();
            this.mushroomChance = ((TreeLayer)layer).getDefaultMushroomChance();
            this.mushroomIncidence = ((TreeLayer)layer).getDefaultMushroomIncidence();
            this.layerStrengthCap = ((TreeLayer)layer).getDefaultLayerStrengthCap();
        }

        @Override
        public boolean isApplyEverywhere() {
            return this.minimumLevel > 0;
        }

        public int getMinimumLevel() {
            return this.minimumLevel;
        }

        public void setMinimumLevel(int minimumLevel) {
            this.minimumLevel = minimumLevel;
        }

        public int getMaxWaterDepth() {
            return this.maxWaterDepth;
        }

        public void setMaxWaterDepth(int maxWaterDepth) {
            this.maxWaterDepth = maxWaterDepth;
        }

        public int getTreeChance() {
            return this.treeChance;
        }

        public void setTreeChance(int treeChance) {
            this.treeChance = treeChance;
        }

        public int getMushroomIncidence() {
            return this.mushroomIncidence;
        }

        public void setMushroomIncidence(int mushroomIncidence) {
            this.mushroomIncidence = mushroomIncidence;
        }

        public float getMushroomChance() {
            return this.mushroomChance;
        }

        public void setMushroomChance(float mushroomChance) {
            this.mushroomChance = mushroomChance;
        }

        public int getLayerStrengthCap() {
            return this.layerStrengthCap;
        }

        public void setLayerStrengthCap(int layerStrengthCap) {
            this.layerStrengthCap = layerStrengthCap;
        }

        public T getLayer() {
            return this.layer;
        }

        @Override
        public ExporterSettings clone() {
            TreeLayerSettings<T> clone = new TreeLayerSettings<T>(this.layer);
            clone.minimumLevel = this.minimumLevel;
            return clone;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.treeChance == 0) {
                this.treeChance = ((TreeLayer)this.layer).getDefaultTreeChance();
                this.maxWaterDepth = ((TreeLayer)this.layer).getDefaultMaxWaterDepth();
                this.mushroomChance = ((TreeLayer)this.layer).getDefaultMushroomChance();
                this.mushroomIncidence = ((TreeLayer)this.layer).getDefaultMushroomIncidence();
                this.layerStrengthCap = ((TreeLayer)this.layer).getDefaultLayerStrengthCap();
            }
        }
    }
}

