/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class FrostExporter
extends AbstractLayerExporter<Frost>
implements SecondPassLayerExporter {
    public FrostExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings != null ? settings : new FrostSettings(), Frost.INSTANCE);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return Collections.singleton(SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        settings = (FrostSettings)this.settings;
        frostEverywhere = settings.isFrostEverywhere();
        mode = settings.getMode();
        snowUnderTrees = settings.isSnowUnderTrees();
        random = new Random();
        customNoSnowOnIds = System.getProperty("org.pepsoft.worldpainter.noSnowOn");
        if (customNoSnowOnIds != null && !customNoSnowOnIds.trim().isEmpty()) {
            throw new IllegalArgumentException("The org.pepsoft.worldpainter.noSnowOn property is no longer supported; please let the author know if you need it");
        }
        for (x = area.x; x < area.x + area.width; ++x) {
            block6: for (y = area.y; y < area.y + area.height; ++y) {
                if (!frostEverywhere && !this.dimension.getBitLayerValueAt(Frost.INSTANCE, x, y)) continue;
                highestNonAirBlock = minecraftWorld.getHighestNonAirBlock(x, y);
                previousMaterial = highestNonAirBlock == this.maxZ ? minecraftWorld.getMaterialAt(x, y, this.maxZ) : Material.AIR;
                leafBlocksEncountered = 0;
                for (height = Math.min(highestNonAirBlock, this.maxZ - 1); height >= this.minHeight; --height) {
                    material = minecraftWorld.getMaterialAt(x, y, height);
                    if (material.isNamed("minecraft:water") && material.getProperty(Material.LAYERS, 0) == 0 || material.containsWater() && material.insubstantial) {
                        minecraftWorld.setMaterialAt(x, y, height, Material.ICE);
                        for (dz = height + 1; dz <= highestNonAirBlock && minecraftWorld.getMaterialAt((int)x, (int)y, (int)dz).insubstantial; ++dz) {
                            minecraftWorld.setMaterialAt(x, y, dz, Material.AIR);
                        }
                        continue block6;
                    }
                    if (!material.canSupportSnow) ** GOTO lbl47
                    if (material.leafBlock || material.sustainsLeaves) {
                        if (previousMaterial == Material.AIR) {
                            minecraftWorld.setMaterialAt(x, y, height + 1, Material.SNOW);
                        }
                        if (!snowUnderTrees && ++leafBlocksEncountered > 1) {
                            continue block6;
                        }
                    } else {
                        if (previousMaterial != Material.AIR && previousMaterial != Material.GRASS && previousMaterial != Material.FERN && previousMaterial != Material.SNOW) continue block6;
                        if (mode == 3 || height == this.dimension.getIntHeightAt(x, y)) {
                            switch (mode) {
                                case 0: {
                                    this.placeSnow(minecraftWorld, x, y, height, 1);
                                    break;
                                }
                                case 1: {
                                    this.placeSnow(minecraftWorld, x, y, height, random.nextInt(3) + 1);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    layers = (int)Math.floor((this.dimension.getHeightAt(x, y) + 0.5f - (float)this.dimension.getIntHeightAt(x, y)) / 0.125f) + 1;
                                    if (layers > 1 && !frostEverywhere) {
                                        layers = Math.max(Math.min(layers, this.dimension.getBitLayerCount(Frost.INSTANCE, x, y, 1) - 1), 1);
                                    }
                                    this.placeSnow(minecraftWorld, x, y, height, layers);
                                }
                            }
                            continue block6;
                        }
                        this.placeSnow(minecraftWorld, x, y, height, 1);
                        continue block6;
lbl47:
                        // 1 sources

                        previousMaterial = material;
                        continue;
                    }
                    previousMaterial = material;
                }
            }
        }
        return null;
    }

    private void placeSnow(MinecraftWorld minecraftWorld, int x, int y, int height, int layers) {
        if (layers < 1 || layers > 8) {
            throw new IllegalArgumentException("layers " + layers);
        }
        Material existingMaterial = minecraftWorld.getMaterialAt(x, y, height + 1);
        if (existingMaterial.isNamed("minecraft:snow")) {
            layers = Math.max(layers, existingMaterial.getProperty(Material.LAYERS));
        }
        minecraftWorld.setMaterialAt(x, y, height + 1, Material.SNOW.withProperty(Material.LAYERS, layers));
    }

    public static class FrostSettings
    implements ExporterSettings {
        private boolean frostEverywhere;
        private int mode = 2;
        private boolean snowUnderTrees = true;
        public static final int MODE_FLAT = 0;
        public static final int MODE_RANDOM = 1;
        public static final int MODE_SMOOTH = 2;
        public static final int MODE_SMOOTH_AT_ALL_ELEVATIONS = 3;
        private static final long serialVersionUID = 2011060801L;

        @Override
        public boolean isApplyEverywhere() {
            return this.frostEverywhere;
        }

        @Override
        public Frost getLayer() {
            return Frost.INSTANCE;
        }

        public boolean isFrostEverywhere() {
            return this.frostEverywhere;
        }

        public void setFrostEverywhere(boolean frostEverywhere) {
            this.frostEverywhere = frostEverywhere;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public boolean isSnowUnderTrees() {
            return this.snowUnderTrees;
        }

        public void setSnowUnderTrees(boolean snowUnderTrees) {
            this.snowUnderTrees = snowUnderTrees;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FrostSettings other = (FrostSettings)obj;
            if (this.frostEverywhere != other.frostEverywhere) {
                return false;
            }
            if (this.mode != other.mode) {
                return false;
            }
            return this.snowUnderTrees == other.snowUnderTrees;
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + (this.frostEverywhere ? 1 : 0);
            hash = 23 * hash + this.mode;
            hash = 23 * hash + (this.snowUnderTrees ? 1 : 0);
            return hash;
        }

        @Override
        public FrostSettings clone() {
            try {
                return (FrostSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

