/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.AbstractCavesExporter;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.util.GeometryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CavesExporter
extends AbstractCavesExporter<Caves>
implements SecondPassLayerExporter {
    private final BitSet excavatedBlocks = new BitSet();
    private static final int MAX_CAVE_LENGTH = 128;
    private static final int CAVE_CHANCE = 131072;
    private static final Logger logger = LoggerFactory.getLogger(CavesExporter.class);

    public CavesExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings instanceof CavesSettings ? (CavesSettings)settings : new CavesSettings(), Caves.INSTANCE);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return this.decorationEnabled ? ImmutableSet.of((Object)((Object)SecondPassLayerExporter.Stage.CARVE), (Object)((Object)SecondPassLayerExporter.Stage.ADD_FEATURES)) : Collections.singleton(SecondPassLayerExporter.Stage.CARVE);
    }

    @Override
    public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        CavesSettings settings = (CavesSettings)this.settings;
        int minZ = Math.max(settings.getMinimumLevel(), this.dimension.getMinHeight() + (this.dimension.isBottomless() ? 0 : 1));
        int maxZForWorld = Math.min(settings.getMaximumLevel(), minecraftWorld.getMaxHeight() - 1);
        int minimumLevel = settings.getCavesEverywhereLevel();
        boolean surfaceBreaking = settings.isSurfaceBreaking();
        Random random = new Random();
        CaveSettings caveSettings = new CaveSettings();
        caveSettings.minZ = minZ;
        caveSettings.waterLevel = settings.waterLevel;
        caveSettings.floodWithLava = settings.floodWithLava;
        Rectangle spawnArea = (Rectangle)exportedArea.clone();
        spawnArea.grow((int)Math.ceil(128.0f + caveSettings.maxRadius), (int)Math.ceil(128.0f + caveSettings.maxRadius));
        int tileX1 = spawnArea.x >> 7;
        int tileX2 = spawnArea.x + spawnArea.width - 1 >> 7;
        int tileY1 = spawnArea.y >> 7;
        int tileY2 = spawnArea.y + spawnArea.height - 1 >> 7;
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = this.dimension.getTile(tileX, tileY);
                if (tile == null || minimumLevel == 0 && !tile.hasLayer(Caves.INSTANCE)) continue;
                for (int xInTile = 0; xInTile < 128; ++xInTile) {
                    for (int yInTile = 0; yInTile < 128; ++yInTile) {
                        int x = tileX << 7 | xInTile;
                        int y = tileY << 7 | yInTile;
                        int cavesValue = Math.max(minimumLevel, tile.getLayerValue(Caves.INSTANCE, xInTile, yInTile));
                        if (cavesValue <= 0) continue;
                        int height = tile.getIntHeight(xInTile, yInTile);
                        int maxZ = Math.min(maxZForWorld, height - (surfaceBreaking ? 0 : this.dimension.getTopLayerDepth(x, y, height)));
                        random.setSeed(this.dimension.getSeed() + (long)x * 65537L + (long)y);
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (cavesValue <= random.nextInt(131072)) continue;
                            caveSettings.start = new Point3i(x, y, z);
                            caveSettings.length = MathUtils.clamp((int)0, (int)((int)Math.round((random.nextGaussian() + 2.0) * 42.666666666666664)), (int)128);
                            this.createTunnel(minecraftWorld, area, exportedArea, this.dimension, new Random(random.nextLong()), caveSettings, surfaceBreaking, minimumLevel);
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        Random random = new Random(this.dimension.getSeed() + (long)exportedArea.x & 65537L + (long)exportedArea.y);
        this.excavatedBlocks.stream().forEach(blockIndex -> {
            int z = blockIndex / (area.height * area.width) + this.minHeight;
            int y = blockIndex / area.width % area.height + area.y;
            int x = blockIndex % area.width + area.x;
            this.decorateBlock(minecraftWorld, random, x, y, z);
        });
        return null;
    }

    private void createTunnel(MinecraftWorld world, Rectangle area, Rectangle exportedArea, Dimension dimension, Random random, CaveSettings tunnelSettings, boolean surfaceBreaking, int minimumLevel) {
        Point3d location = new Point3d((double)tunnelSettings.start.x + random.nextDouble() - 0.5, (double)tunnelSettings.start.y + random.nextDouble() - 0.5, (double)tunnelSettings.start.z + random.nextDouble() - 0.5);
        Vector3d direction = this.getRandomDirection(random);
        float minRadius = tunnelSettings.minRadius;
        float maxRadius = tunnelSettings.maxRadius;
        float radiusChangeSpeed = tunnelSettings.radiusChangeSpeed;
        float twistiness = tunnelSettings.twistiness;
        float length = 0.0f;
        float radius = (maxRadius + minRadius) / 2.0f;
        float radiusDelta = 0.0f;
        int maxLength = tunnelSettings.length;
        if (logger.isTraceEnabled()) {
            logger.trace("Creating tunnel @ {},{},{} of length {}; radius: {} - {} (variability: {}); twistiness: {}", new Object[]{tunnelSettings.start.x, tunnelSettings.start.y, tunnelSettings.start.z, maxLength, Float.valueOf(tunnelSettings.minRadius), Float.valueOf(tunnelSettings.maxRadius), Float.valueOf(radiusChangeSpeed), Float.valueOf(twistiness)});
        }
        long segmentSeed = random.nextLong();
        while (length < (float)maxLength) {
            if (minimumLevel == 0 && dimension.getLayerValueAt(Caves.INSTANCE, (int)location.x, (int)location.y) < 1) {
                return;
            }
            if (location.x + (double)radius >= (double)exportedArea.x && location.x - (double)radius <= (double)(exportedArea.x + exportedArea.width) && location.y + (double)radius >= (double)exportedArea.y && location.y - (double)radius <= (double)(exportedArea.y + exportedArea.height)) {
                this.excavate(world, area, dimension, new Random((long)((float)segmentSeed + length)), tunnelSettings, location, radius, surfaceBreaking);
            }
            length = (float)((double)length + direction.length());
            location.add((Tuple3d)direction);
            Vector3d dirChange = this.getRandomDirection(random);
            dirChange.scale(random.nextDouble() / (double)(5.0f - twistiness));
            direction.add((Tuple3d)dirChange);
            direction.normalize();
            if (!((double)radiusChangeSpeed > 0.0)) continue;
            radius = MathUtils.clamp((float)minRadius, (float)(radius + radiusDelta), (float)maxRadius);
            radiusDelta = (float)((double)radiusDelta + (random.nextDouble() * 2.0 * (double)radiusChangeSpeed - (double)radiusChangeSpeed));
        }
    }

    private void excavate(MinecraftWorld world, Rectangle area, Dimension dimension, Random random, CaveSettings settings, Point3d location, double radius, boolean surfaceBreaking) {
        boolean intrudingStone = settings.intrudingStone;
        boolean roughWalls = settings.roughWalls;
        boolean removeFloatingBlocks = settings.removeFloatingBlocks;
        int minZ = settings.minZ;
        GeometryUtil.visitFilledAbsoluteSphere(location.x, location.y, location.z, (float)radius, (x, y, z, d) -> {
            if (!world.isChunkPresent(x >> 4, y >> 4)) {
                return true;
            }
            if (z >= minZ) {
                boolean blockExcavated;
                int terrainHeight = dimension.getIntHeightAt(x, y);
                int maxZ = terrainHeight - (surfaceBreaking ? 0 : dimension.getTopLayerDepth(x, y, terrainHeight));
                if (z > maxZ || x < area.x || x >= area.x + area.width || y < area.y || y >= area.y + area.height) {
                    return true;
                }
                int blockIndex = x - area.x + (y - area.y) * area.width + (z - this.minHeight) * area.width * area.height;
                if (this.excavatedBlocks.get(blockIndex)) {
                    return true;
                }
                if ((roughWalls || intrudingStone) && radius - (double)d <= 1.0) {
                    if (intrudingStone) {
                        if (world.getMaterialAt(x, y, z).isNotNamedOneOf("minecraft:granite", "minecraft:diorite", "minecraft:andesite") && (!roughWalls || random.nextBoolean())) {
                            CavesExporter.excavateBlock(world, x, y, z, settings);
                            blockExcavated = true;
                        } else {
                            blockExcavated = false;
                        }
                    } else if (random.nextBoolean()) {
                        CavesExporter.excavateBlock(world, x, y, z, settings);
                        blockExcavated = true;
                    } else {
                        blockExcavated = false;
                    }
                } else {
                    CavesExporter.excavateBlock(world, x, y, z, settings);
                    blockExcavated = true;
                }
                if (blockExcavated) {
                    if (this.decorationEnabled) {
                        this.excavatedBlocks.set(blockIndex);
                    }
                    if (removeFloatingBlocks && radius - (double)d <= 2.0) {
                        this.checkForFloatingBlock(world, area, x - 1, y, z, minZ, maxZ, settings);
                        this.checkForFloatingBlock(world, area, x, y - 1, z, minZ, maxZ, settings);
                        this.checkForFloatingBlock(world, area, x + 1, y, z, minZ, maxZ, settings);
                        this.checkForFloatingBlock(world, area, x, y + 1, z, minZ, maxZ, settings);
                        if (z > 1) {
                            this.checkForFloatingBlock(world, area, x, y, z - 1, minZ, maxZ, settings);
                        }
                        if (z < maxZ) {
                            this.checkForFloatingBlock(world, area, x, y, z + 1, minZ, maxZ, settings);
                        }
                    }
                }
            }
            return true;
        });
    }

    static void excavateBlock(MinecraftWorld world, int x, int y, int z, CaveSettings settings) {
        world.setMaterialAt(x, y, z, z <= settings.waterLevel ? (settings.floodWithLava ? Material.STATIONARY_LAVA : Material.STATIONARY_WATER) : Material.AIR);
    }

    private void checkForFloatingBlock(MinecraftWorld world, Rectangle area, int x, int y, int z, int minZ, int maxZ, CaveSettings settings) {
        if (!world.isChunkPresent(x >> 4, y >> 4)) {
            return;
        }
        Material material = world.getMaterialAt(x, y, z);
        if (material.isNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:podzol", "minecraft:farmland", "minecraft:grass_path", "minecraft:dirt_path", "minecraft:sand", "minecraft:red_sand", "minecraft:gravel")) {
            if (z > minZ && !world.getMaterialAt((int)x, (int)y, (int)(z - 1)).solid && z <= maxZ && !world.getMaterialAt((int)x, (int)y, (int)(z + 1)).solid) {
                CavesExporter.excavateBlock(world, x, y, z, settings);
                if (this.decorationEnabled) {
                    this.excavatedBlocks.set(x - area.x + (y - area.y) * area.width + (z - this.minHeight) * area.width * area.height);
                }
            }
        } else if (!(!material.isNotNamedOneOf("minecraft:air", "minecraft:water", "minecraft:lava") || material.leafBlock || world.getMaterialAt((int)(x - 1), (int)y, (int)z).solid || world.getMaterialAt((int)x, (int)(y - 1), (int)z).solid || world.getMaterialAt((int)(x + 1), (int)y, (int)z).solid || world.getMaterialAt((int)x, (int)(y + 1), (int)z).solid || z <= minZ || world.getMaterialAt((int)x, (int)y, (int)(z - 1)).solid || z > maxZ || world.getMaterialAt((int)x, (int)y, (int)(z + 1)).solid)) {
            CavesExporter.excavateBlock(world, x, y, z, settings);
            if (this.decorationEnabled) {
                this.excavatedBlocks.set(x - area.x + (y - area.y) * area.width + (z - this.minHeight) * area.width * area.height);
            }
        }
    }

    private Vector3d getRandomDirection(Random random) {
        double x1 = random.nextDouble() * 2.0 - 1.0;
        double x2 = random.nextDouble() * 2.0 - 1.0;
        while (x1 * x1 + x2 * x2 >= 1.0) {
            x1 = random.nextDouble() * 2.0 - 1.0;
            x2 = random.nextDouble() * 2.0 - 1.0;
        }
        double a = Math.sqrt(1.0 - x1 * x1 - x2 * x2);
        return new Vector3d(2.0 * x1 * a, 2.0 * x2 * a, 1.0 - 2.0 * (x1 * x1 + x2 * x2));
    }

    public static class CavesSettings
    implements org.pepsoft.worldpainter.layers.exporters.CaveSettings {
        private int waterLevel = Integer.MIN_VALUE;
        private int cavesEverywhereLevel;
        private boolean floodWithLava;
        private boolean surfaceBreaking = true;
        private boolean leaveWater = true;
        private int minimumLevel = Integer.MIN_VALUE;
        private int maximumLevel = Integer.MAX_VALUE;
        private AbstractCavesExporter.CaveDecorationSettings decorationSettings = new AbstractCavesExporter.CaveDecorationSettings();
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isApplyEverywhere() {
            return this.cavesEverywhereLevel > 0;
        }

        @Override
        public Layer getLayer() {
            return Caves.INSTANCE;
        }

        @Override
        public CavesSettings clone() {
            try {
                CavesSettings clone = (CavesSettings)super.clone();
                if (this.decorationSettings != null) {
                    clone.decorationSettings = this.decorationSettings.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public int getWaterLevel() {
            return this.waterLevel;
        }

        public void setWaterLevel(int waterLevel) {
            this.waterLevel = waterLevel;
        }

        public int getCavesEverywhereLevel() {
            return this.cavesEverywhereLevel;
        }

        public void setCavesEverywhereLevel(int cavesEverywhereLevel) {
            this.cavesEverywhereLevel = cavesEverywhereLevel;
        }

        public boolean isFloodWithLava() {
            return this.floodWithLava;
        }

        public void setFloodWithLava(boolean floodWithLava) {
            this.floodWithLava = floodWithLava;
        }

        public boolean isSurfaceBreaking() {
            return this.surfaceBreaking;
        }

        public void setSurfaceBreaking(boolean surfaceBreaking) {
            this.surfaceBreaking = surfaceBreaking;
        }

        public boolean isLeaveWater() {
            return this.leaveWater;
        }

        public void setLeaveWater(boolean leaveWater) {
            this.leaveWater = leaveWater;
        }

        public int getMinimumLevel() {
            return this.minimumLevel;
        }

        public void setMinimumLevel(int minimumLevel) {
            this.minimumLevel = minimumLevel;
        }

        public int getMaximumLevel() {
            return this.maximumLevel;
        }

        public void setMaximumLevel(int maximumLevel) {
            this.maximumLevel = maximumLevel;
        }

        @Override
        public AbstractCavesExporter.CaveDecorationSettings getCaveDecorationSettings() {
            return this.decorationSettings;
        }

        public void setCaveDecorationSettings(AbstractCavesExporter.CaveDecorationSettings decorationSettings) {
            this.decorationSettings = decorationSettings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CavesSettings that = (CavesSettings)o;
            if (this.waterLevel != that.waterLevel) {
                return false;
            }
            if (this.cavesEverywhereLevel != that.cavesEverywhereLevel) {
                return false;
            }
            if (this.floodWithLava != that.floodWithLava) {
                return false;
            }
            if (this.surfaceBreaking != that.surfaceBreaking) {
                return false;
            }
            if (this.leaveWater != that.leaveWater) {
                return false;
            }
            if (this.minimumLevel != that.minimumLevel) {
                return false;
            }
            if (!Objects.equals(this.decorationSettings, that.decorationSettings)) {
                return false;
            }
            return this.maximumLevel == that.maximumLevel;
        }

        public int hashCode() {
            int result = this.waterLevel;
            result = 31 * result + this.cavesEverywhereLevel;
            result = 31 * result + (this.floodWithLava ? 1 : 0);
            result = 31 * result + (this.surfaceBreaking ? 1 : 0);
            result = 31 * result + (this.leaveWater ? 1 : 0);
            result = 31 * result + this.minimumLevel;
            result = 31 * result + this.maximumLevel;
            result = 31 * result + (this.decorationSettings != null ? this.decorationSettings.hashCode() : 0);
            return result;
        }
    }

    static class CaveSettings {
        Point3i start;
        int length;
        int minZ;
        int waterLevel;
        float minRadius = 1.5f;
        float maxRadius = 3.25f;
        float twistiness = 3.0f;
        float radiusChangeSpeed = 0.2f;
        boolean intrudingStone = true;
        boolean roughWalls;
        boolean removeFloatingBlocks = true;
        boolean floodWithLava;

        CaveSettings() {
        }
    }
}

