/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;
import org.pepsoft.worldpainter.layers.renderers.LayerRenderer;

public abstract class Layer
implements Serializable,
Comparable<Layer> {
    private String name;
    private String description;
    public final DataSize dataSize;
    public final int priority;
    protected String id;
    public boolean discrete;
    private final transient char mnemonic;
    private transient LayerRenderer renderer;
    private transient Class<? extends LayerExporter> exporterType;
    private transient BufferedImage icon;
    private static final long serialVersionUID = 2011032901L;

    @Deprecated
    protected Layer(String name, String description, DataSize dataSize, boolean discrete, int priority) {
        this(name, name, description, dataSize, discrete, priority, '\u0000');
    }

    @Deprecated
    protected Layer(String name, String description, DataSize dataSize, boolean discrete, int priority, char mnemonic) {
        this(name, name, description, dataSize, discrete, priority, mnemonic);
    }

    protected Layer(String id, String name, String description, DataSize dataSize, boolean discrete, int priority) {
        this(id, name, description, dataSize, discrete, priority, '\u0000');
    }

    protected Layer(String id, String name, String description, DataSize dataSize, boolean discrete, int priority, char mnemonic) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.dataSize = dataSize;
        this.discrete = discrete;
        this.priority = priority;
        this.mnemonic = mnemonic;
        this.init();
    }

    public final DataSize getDataSize() {
        return this.dataSize;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public Class<? extends LayerExporter> getExporterType() {
        return this.exporterType;
    }

    public LayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        if (this.exporterType == null) {
            return null;
        }
        try {
            Constructor<? extends LayerExporter> exporterConstructor = this.exporterType.getConstructor(Dimension.class, Platform.class, ExporterSettings.class);
            return exporterConstructor.newInstance(dimension, platform, settings);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Instantiation exception while instantiating exporter for layer " + this.name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access denied while instantiating exporter for layer " + this.name, e);
        }
        catch (NoSuchMethodException e) {
            throw new MDCCapturingRuntimeException("Exporter class for layer " + this.name + " is missing a (Dimension, Platform) constructor", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException("Constructor for exporter for layer " + this.name + " threw " + e.getTargetException().getClass().getSimpleName() + " (message: " + e.getTargetException().getMessage() + ")", e);
        }
    }

    public LayerRenderer getRenderer() {
        return this.renderer;
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getId() {
        return this.id;
    }

    public int getDefaultValue() {
        return 0;
    }

    public boolean isExportable() {
        return true;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Layer && this.id.equals(((Layer)obj).id);
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final int compareTo(Layer layer) {
        String palette2;
        if (this instanceof CustomLayer && ((CustomLayer)this).getIndex() != null) {
            if (layer instanceof CustomLayer && ((CustomLayer)layer).getIndex() != null) {
                return Integer.compare(((CustomLayer)this).getIndex(), ((CustomLayer)layer).getIndex());
            }
            return -1;
        }
        if (layer instanceof CustomLayer && ((CustomLayer)layer).getIndex() != null) {
            return 1;
        }
        if (this.priority != layer.priority) {
            return Integer.compare(this.priority, layer.priority);
        }
        if (this instanceof GroundCoverLayer && layer instanceof GroundCoverLayer && Math.abs(((GroundCoverLayer)layer).getThickness()) != Math.abs(((GroundCoverLayer)this).getThickness())) {
            return Math.abs(((GroundCoverLayer)layer).getThickness()) - Math.abs(((GroundCoverLayer)this).getThickness());
        }
        String palette1 = this instanceof CustomLayer ? ((CustomLayer)this).getPalette() : null;
        String string = palette2 = layer instanceof CustomLayer ? ((CustomLayer)layer).getPalette() : null;
        if (palette1 != null) {
            if (palette2 != null) {
                if (!palette1.equals(palette2)) {
                    return palette1.compareTo(palette2);
                }
                return this.name.compareTo(layer.name);
            }
            return -1;
        }
        if (palette2 != null) {
            return 1;
        }
        return this.name.compareTo(layer.name);
    }

    private void init() {
        Class<?> clazz = this.getClass();
        ClassLoader pluginClassLoader = PluginManager.getPluginClassLoader();
        try {
            try {
                this.renderer = (LayerRenderer)pluginClassLoader.loadClass(clazz.getPackage().getName() + ".renderers." + clazz.getSimpleName() + "Renderer").newInstance();
            }
            catch (ClassNotFoundException | InstantiationException e) {
                this.renderer = null;
            }
            try {
                this.exporterType = pluginClassLoader.loadClass(clazz.getPackage().getName() + ".exporters." + clazz.getSimpleName() + "Exporter");
            }
            catch (ClassNotFoundException e) {
                this.exporterType = null;
            }
        }
        catch (IllegalAccessException e) {
            throw new MDCCapturingRuntimeException("Access denied while creating renderer for layer " + this.name, (Throwable)e);
        }
        this.icon = IconUtils.loadScaledImage((ClassLoader)clazz.getClassLoader(), (String)("org/pepsoft/worldpainter/icons/" + this.getClass().getSimpleName().toLowerCase() + ".png"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.id == null) {
            this.id = this.name;
        }
        if (!this.discrete && (this instanceof Annotations || this instanceof Biome || this instanceof GardenCategory)) {
            this.discrete = true;
        }
        this.init();
    }

    public static enum DataSize {
        BIT(1){

            @Override
            public String toString(int value) {
                return value == 0 ? "off" : "on";
            }
        }
        ,
        NIBBLE(15){

            @Override
            public String toString(int value) {
                int strength;
                int n = strength = value > 0 ? (value - 1) * 100 / 14 + 1 : 0;
                if (strength == 51 || strength == 101) {
                    --strength;
                }
                return strength + "%";
            }
        }
        ,
        BYTE(255){

            @Override
            public String toString(int value) {
                return value * 100 / 255 + "%";
            }
        }
        ,
        BIT_PER_CHUNK(1){

            @Override
            public String toString(int value) {
                return value == 0 ? "off" : "on";
            }
        }
        ,
        NONE(-1){

            @Override
            public String toString(int value) {
                return "N/A";
            }
        };

        public final int maxValue;

        private DataSize(int maxValue) {
            this.maxValue = maxValue;
        }

        public abstract String toString(int var1);
    }
}

