/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerContainer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class CombinedLayer
extends CustomLayer
implements LayerContainer {
    private static final long serialVersionUID = 1L;
    private Terrain terrain;
    private List<Layer> layers = Collections.emptyList();
    private Map<Layer, Float> factors = Collections.emptyMap();
    private boolean customTerrainPresent;
    private boolean applyTerrainAndBiomeOnExport = true;
    private transient MixedMaterial customTerrainMaterial;
    private static final LayerExporter EXPORTER = new CombinedLayerExporter();

    public CombinedLayer(String name, String description, int colour) {
        super(name, description, Layer.DataSize.NIBBLE, 55, colour);
    }

    public Set<Layer> apply(Dimension dimension) {
        return this.apply(dimension, null);
    }

    public Set<Layer> apply(Dimension dimension, Set<Point> selectedTiles) {
        HashSet<Layer> addedLayers = new HashSet<Layer>();
        if (selectedTiles == null) {
            for (Tile tile : dimension.getTiles()) {
                addedLayers.addAll(this.apply(tile));
            }
        } else {
            for (Point point : selectedTiles) {
                Tile tile = dimension.getTile(point);
                if (tile == null) continue;
                addedLayers.addAll(this.apply(tile));
            }
        }
        return addedLayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Layer> apply(Tile tile) {
        boolean terrainConfigured = this.terrain != null;
        int biome = this.getBiome();
        boolean biomeConfigured = biome != -1;
        HashSet<Layer> addedLayers = new HashSet<Layer>();
        if (!tile.hasLayer(this)) {
            return Collections.emptySet();
        }
        tile.inhibitEvents();
        try {
            if (this.applyTerrainAndBiomeOnExport && (terrainConfigured || biomeConfigured)) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        float strength = (float)tile.getLayerValue(this, x, y) / 15.0f;
                        if (!(strength > 0.0f)) continue;
                        if (terrainConfigured && (strength >= 0.5f || Math.random() / 2.0 < (double)strength)) {
                            tile.setTerrain(x, y, this.terrain);
                        }
                        if (!biomeConfigured || !(strength >= 0.5f) && !(Math.random() / 2.0 < (double)strength)) continue;
                        tile.setLayerValue(Biome.INSTANCE, x, y, biome);
                    }
                }
            }
            for (Layer layer : this.layers) {
                boolean layerAdded = false;
                float factor = this.factors.get(layer).floatValue();
                Layer.DataSize dataSize = layer.getDataSize();
                if (dataSize == Layer.DataSize.BIT || dataSize == Layer.DataSize.BIT_PER_CHUNK) {
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            float strength = Math.min((float)tile.getLayerValue(this, x, y) / 15.0f * factor, 1.0f);
                            if (!(strength > 0.95f) && !(Math.random() < (double)strength)) continue;
                            tile.setBitLayerValue(layer, x, y, true);
                            layerAdded = true;
                        }
                    }
                } else {
                    int maxValue = dataSize == Layer.DataSize.NIBBLE ? 15 : 255;
                    for (int x = 0; x < 128; ++x) {
                        for (int y = 0; y < 128; ++y) {
                            int value = Math.min(Math.round((float)tile.getLayerValue(this, x, y) * factor), maxValue);
                            if (value <= 0) continue;
                            tile.setLayerValue(layer, x, y, value);
                            layerAdded = true;
                        }
                    }
                }
                if (!layerAdded) continue;
                addedLayers.add(layer);
            }
            tile.clearLayerData(this);
        }
        finally {
            tile.releaseEvents();
        }
        return addedLayers;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public String getType() {
        return "Combined Layer";
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    @Override
    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        if (layers == null) {
            throw new NullPointerException("layers");
        }
        for (int i = 0; i < layers.size(); ++i) {
            if (layers.get(i) != null) continue;
            throw new IllegalArgumentException("layers[" + i + "] == null");
        }
        this.layers = layers;
    }

    public Map<Layer, Float> getFactors() {
        return this.factors;
    }

    public void setFactors(Map<Layer, Float> factors) {
        if (factors == null) {
            throw new NullPointerException();
        }
        this.factors = factors;
    }

    public boolean isApplyTerrainAndBiomeOnExport() {
        return this.applyTerrainAndBiomeOnExport;
    }

    public void setApplyTerrainAndBiomeOnExport(boolean applyTerrainAndBiomeOnExport) {
        this.applyTerrainAndBiomeOnExport = applyTerrainAndBiomeOnExport;
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return CombinedLayerExporter.class;
    }

    @Override
    public LayerExporter getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return EXPORTER;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        List<Action> superActions = super.getActions();
        if (superActions != null) {
            actions.addAll(superActions);
        }
        actions.add(new AbstractAction("Apply"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension dimension = (Dimension)this.getValue("org.pepsoft.worldpainter.dimension");
                if (dimension != null && dimension.getAllLayers(false).contains(CombinedLayer.this)) {
                    dimension.armSavePoint();
                    CombinedLayer.this.apply(dimension);
                }
            }
        });
        return actions;
    }

    public boolean restoreCustomTerrain() {
        if (this.customTerrainPresent) {
            if (this.customTerrainMaterial == null) {
                this.terrain = null;
                return false;
            }
            int slot = -1;
            for (int i = 0; i < 96; ++i) {
                if (this.customTerrainMaterial.equals(Terrain.getCustomMaterial(i))) {
                    slot = i;
                    break;
                }
                if (slot != -1 || Terrain.getCustomMaterial(i) != null) continue;
                slot = i;
            }
            if (slot != -1) {
                Terrain.setCustomMaterial(slot, this.customTerrainMaterial);
                this.terrain = Terrain.getCustomTerrain(slot);
                return true;
            }
            this.terrain = null;
            return false;
        }
        return this.terrain == null || !this.terrain.isCustom();
    }

    @Override
    public CombinedLayer clone() {
        CombinedLayer clone = (CombinedLayer)super.clone();
        if (!this.layers.isEmpty()) {
            clone.layers = new ArrayList<Layer>(this.layers);
        }
        if (!this.factors.isEmpty()) {
            clone.factors = new HashMap<Layer, Float>(this.factors);
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.customTerrainPresent) {
            this.customTerrainMaterial = (MixedMaterial)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.customTerrainPresent = this.terrain != null && this.terrain.isCustom();
        out.defaultWriteObject();
        if (this.customTerrainPresent) {
            out.writeObject(Terrain.getCustomMaterial(this.terrain.getCustomTerrainIndex()));
        }
    }

    static class CombinedLayerExporter
    implements FirstPassLayerExporter,
    SecondPassLayerExporter {
        CombinedLayerExporter() {
        }

        @Override
        public Layer getLayer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void render(Tile tile, Chunk chunk) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<SecondPassLayerExporter.Stage> getStages() {
            return EnumSet.of(SecondPassLayerExporter.Stage.CARVE, SecondPassLayerExporter.Stage.ADD_FEATURES);
        }

        @Override
        public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
            throw new UnsupportedOperationException();
        }
    }
}

