/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.heightMaps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Random;
import javax.swing.Icon;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;

public final class NoiseHeightMap
extends AbstractHeightMap {
    private final PerlinNoise perlinNoise;
    private float height;
    private double dHeight;
    private final double scale;
    private final int octaves;
    private final long seedOffset;
    private int version = 1;
    private static final int[] FACTORS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_NOISE_HEIGHTMAP = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/noise.png");

    public NoiseHeightMap(NoiseSettings noiseSettings) {
        this(null, noiseSettings.getRange() * 2, noiseSettings.getScale() / 5.0f, noiseSettings.getRoughness() + 1, new Random().nextLong());
    }

    public NoiseHeightMap(NoiseSettings noiseSettings, long seedOffset) {
        this(null, noiseSettings.getRange() * 2, noiseSettings.getScale() / 5.0f, noiseSettings.getRoughness() + 1, seedOffset);
    }

    public NoiseHeightMap(String name, NoiseSettings noiseSettings) {
        this(name, noiseSettings.getRange() * 2, noiseSettings.getScale() / 5.0f, noiseSettings.getRoughness() + 1, new Random().nextLong());
    }

    public NoiseHeightMap(String name, NoiseSettings noiseSettings, long seedOffset) {
        this(name, noiseSettings.getRange() * 2, noiseSettings.getScale() / 5.0f, noiseSettings.getRoughness() + 1, seedOffset);
    }

    public NoiseHeightMap(double height, double scale, int octaves) {
        this(null, height, scale, octaves, new Random().nextLong());
    }

    public NoiseHeightMap(double height, double scale, int octaves, long seedOffset) {
        this(null, height, scale, octaves, seedOffset);
    }

    public NoiseHeightMap(String name, double height, double scale, int octaves) {
        this(name, height, scale, octaves, new Random().nextLong());
    }

    public NoiseHeightMap(String name, double height, double scale, int octaves, long seedOffset) {
        this.setName(name);
        if (octaves > 10) {
            throw new IllegalArgumentException("More than 10 octaves not supported");
        }
        this.dHeight = height;
        this.scale = scale;
        this.octaves = octaves;
        this.seedOffset = seedOffset;
        this.perlinNoise = new PerlinNoise(seedOffset);
    }

    public double getHeight() {
        return this.dHeight;
    }

    public double getScale() {
        return this.scale;
    }

    public int getOctaves() {
        return this.octaves;
    }

    public long getSeedOffset() {
        return this.seedOffset;
    }

    @Override
    public void setSeed(long seed) {
        if (seed != this.seed) {
            super.setSeed(seed);
            this.perlinNoise.setSeed(seed + this.seedOffset);
        }
    }

    @Override
    public double getHeight(int x, int y) {
        return this.getValue(x, y);
    }

    @Override
    public double getHeight(float x, float y) {
        return this.getValue(x, y);
    }

    @Override
    public int getColour(int x, int y) {
        int value = (int)MathUtils.clamp((long)0L, (long)Math.round(this.getHeight(x, y)), (long)255L);
        return value << 16 | value << 8 | value;
    }

    public double getValue(double x) {
        if (this.octaves == 1) {
            return ((double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale) + 0.5) * this.dHeight;
        }
        double noise = 0.0;
        for (int i = 0; i < this.octaves; ++i) {
            noise += (double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale * (double)FACTORS[i]);
        }
        return ((noise /= (double)this.octaves) + 0.5) * this.dHeight;
    }

    public double getValue(double x, double y) {
        if (this.octaves == 1) {
            return ((double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale, y / (double)65.537f / this.scale) + 0.5) * this.dHeight;
        }
        double noise = 0.0;
        for (int i = 0; i < this.octaves; ++i) {
            noise += (double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale * (double)FACTORS[i], y / (double)65.537f / this.scale * (double)FACTORS[i]);
        }
        return ((noise /= (double)this.octaves) + 0.5) * this.dHeight;
    }

    public double getValue(double x, double y, double z) {
        if (this.octaves == 1) {
            return ((double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale, y / (double)65.537f / this.scale, z / (double)65.537f / this.scale) + 0.5) * this.dHeight;
        }
        double noise = 0.0;
        for (int i = 0; i < this.octaves; ++i) {
            noise += (double)this.perlinNoise.getPerlinNoise(x / (double)65.537f / this.scale * (double)FACTORS[i], y / (double)65.537f / this.scale * (double)FACTORS[i], z / (double)65.537f / this.scale * (double)FACTORS[i]);
        }
        return ((noise /= (double)this.octaves) + 0.5) * this.dHeight;
    }

    @Override
    public NoiseHeightMap clone() {
        NoiseHeightMap clone = new NoiseHeightMap(this.name, this.dHeight, this.scale, this.octaves, this.seedOffset);
        clone.setSeed(this.getSeed());
        return clone;
    }

    @Override
    public Icon getIcon() {
        return ICON_NOISE_HEIGHTMAP;
    }

    @Override
    public double[] getRange() {
        return new double[]{0.0, this.dHeight};
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.version == 0) {
            this.dHeight = this.height;
            this.height = 0.0f;
            this.version = 1;
        }
    }
}

