/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.gardenofeden;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.pepsoft.minecraft.Material;

public class Theme
implements Serializable {
    public final Material floorMaterial;
    public final Material beamMaterial;
    public final Material wallMaterial;
    public final Material roofMaterial;
    public final Material windowMaterial;
    public final Material interiorWallMaterial;
    private transient BufferedImage preview;
    private static final long serialVersionUID = 1L;

    public Theme(Material floorMaterial, Material beamMaterial, Material wallMaterial, Material roofMaterial, Material windowMaterial, Material interiorWallMaterial) {
        this.floorMaterial = floorMaterial;
        this.beamMaterial = beamMaterial;
        this.wallMaterial = wallMaterial;
        this.roofMaterial = roofMaterial;
        this.windowMaterial = windowMaterial;
        this.interiorWallMaterial = interiorWallMaterial;
    }

    public BufferedImage getPreview(BufferedImage texturePack) {
        if (this.preview == null) {
            this.constructPreview(texturePack);
        }
        return this.preview;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Theme other = (Theme)obj;
        if (!(this.floorMaterial == other.floorMaterial || this.floorMaterial != null && this.floorMaterial.equals(other.floorMaterial))) {
            return false;
        }
        if (!(this.beamMaterial == other.beamMaterial || this.beamMaterial != null && this.beamMaterial.equals(other.beamMaterial))) {
            return false;
        }
        if (!(this.wallMaterial == other.wallMaterial || this.wallMaterial != null && this.wallMaterial.equals(other.wallMaterial))) {
            return false;
        }
        if (!(this.roofMaterial == other.roofMaterial || this.roofMaterial != null && this.roofMaterial.equals(other.roofMaterial))) {
            return false;
        }
        if (!(this.windowMaterial == other.windowMaterial || this.windowMaterial != null && this.windowMaterial.equals(other.windowMaterial))) {
            return false;
        }
        return this.interiorWallMaterial == other.interiorWallMaterial || this.interiorWallMaterial != null && this.interiorWallMaterial.equals(other.interiorWallMaterial);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.floorMaterial != null ? this.floorMaterial.hashCode() : 0);
        hash = 61 * hash + (this.beamMaterial != null ? this.beamMaterial.hashCode() : 0);
        hash = 61 * hash + (this.wallMaterial != null ? this.wallMaterial.hashCode() : 0);
        hash = 61 * hash + (this.roofMaterial != null ? this.roofMaterial.hashCode() : 0);
        hash = 61 * hash + (this.windowMaterial != null ? this.windowMaterial.hashCode() : 0);
        hash = 61 * hash + (this.interiorWallMaterial != null ? this.interiorWallMaterial.hashCode() : 0);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructPreview(BufferedImage texturePack) {
        BufferedImage tmp = new BufferedImage(72, 40, 2);
        Graphics2D g2 = tmp.createGraphics();
        g2.scale(0.5, 0.5);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        try {
            int y;
            int x;
            for (x = 1; x < 8; ++x) {
                this.paintImage(this.floorMaterial, g2, x * 16, 64, texturePack);
            }
            for (y = 1; y < 5; ++y) {
                this.paintImage(this.beamMaterial, g2, 0, y * 16, texturePack);
                this.paintImage(this.beamMaterial, g2, 128, y * 16, texturePack);
            }
            for (y = 1; y < 4; ++y) {
                this.paintImage(this.interiorWallMaterial, g2, 64, y * 16, texturePack);
            }
            for (int dx = 0; dx < 3; ++dx) {
                for (int dy = 0; dy < 3; ++dy) {
                    if (dx == 1 && dy == 1) {
                        this.paintImage(this.windowMaterial, g2, (1 + dx) * 16, (1 + dy) * 16, texturePack);
                        this.paintImage(this.windowMaterial, g2, (5 + dx) * 16, (1 + dy) * 16, texturePack);
                        continue;
                    }
                    this.paintImage(this.wallMaterial, g2, (1 + dx) * 16, (1 + dy) * 16, texturePack);
                    this.paintImage(this.wallMaterial, g2, (5 + dx) * 16, (1 + dy) * 16, texturePack);
                }
            }
            for (x = 0; x < 9; ++x) {
                this.paintImage(this.roofMaterial, g2, x * 16, 0, texturePack);
            }
        }
        finally {
            g2.dispose();
        }
        this.preview = tmp;
    }

    private void paintImage(Material material, Graphics2D g2, int x, int y, BufferedImage texturePack) {
    }
}

