/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.InvertedChunk;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public class InvertedWorld
implements MinecraftWorld {
    private final MinecraftWorld world;
    private final int minHeight;
    private final int maxHeight;
    private final int maxZ;
    private final int delta;
    private final Platform platform;

    public InvertedWorld(MinecraftWorld world, int delta, Platform platform) {
        this.world = world;
        this.delta = delta;
        this.platform = platform;
        this.minHeight = world.getMinHeight();
        this.maxHeight = world.getMaxHeight();
        this.maxZ = this.maxHeight + this.minHeight - delta - 1;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        if (this.maxZ - height < this.minHeight || this.maxZ - height >= this.maxHeight) {
            return 0;
        }
        return this.world.getBlockTypeAt(x, y, this.maxZ - height);
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        if (this.maxZ - height < this.minHeight || this.maxZ - height >= this.maxHeight) {
            return 0;
        }
        return this.world.getDataAt(x, y, this.maxZ - height);
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        if (this.maxZ - height < this.minHeight || this.maxZ - height >= this.maxHeight) {
            return Material.AIR;
        }
        return this.world.getMaterialAt(x, y, this.maxZ - height).invert(this.platform);
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        if (this.maxZ - height >= this.minHeight && this.maxZ - height < this.maxHeight) {
            this.world.setBlockTypeAt(x, y, this.maxZ - height, blockType);
        }
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        if (this.maxZ - height >= this.minHeight && this.maxZ - height < this.maxHeight) {
            this.world.setDataAt(x, y, this.maxZ - height, data);
        }
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        if (this.maxZ - height >= this.minHeight && this.maxZ - height < this.maxHeight) {
            this.world.setMaterialAt(x, y, this.maxZ - height, material.invert(this.platform));
        }
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        Entity worldEntity = entity.clone();
        double[] pos = worldEntity.getPos();
        pos[1] = (double)this.maxZ - pos[1];
        worldEntity.setPos(pos);
        this.world.addEntity(x, y, (double)this.maxZ - height, worldEntity);
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        if (height <= this.maxZ) {
            TileEntity worldEntity = (TileEntity)tileEntity.clone();
            worldEntity.setY(this.maxZ - worldEntity.getY());
            this.world.addTileEntity(x, y, this.maxZ - height, worldEntity);
        }
    }

    @Override
    public int getBlockLightLevel(int x, int y, int height) {
        if (this.maxZ - height < this.minHeight || this.maxZ - height >= this.maxHeight) {
            return 0;
        }
        return this.world.getBlockLightLevel(x, y, this.maxZ - height);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int height, int blockLightLevel) {
        if (this.maxZ - height >= this.minHeight && this.maxZ - height < this.maxHeight) {
            this.world.setBlockLightLevel(x, y, this.maxZ - height, blockLightLevel);
        }
    }

    @Override
    public int getSkyLightLevel(int x, int y, int height) {
        if (this.maxZ - height < this.minHeight || this.maxZ - height >= this.maxHeight) {
            return 15;
        }
        return this.world.getSkyLightLevel(x, y, this.maxZ - height);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int height, int skyLightLevel) {
        if (this.maxZ - height >= this.minHeight && this.maxZ - height < this.maxHeight) {
            this.world.setSkyLightLevel(x, y, this.maxZ - height, skyLightLevel);
        }
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return this.world.isChunkPresent(x, y);
    }

    @Override
    public void addChunk(Chunk chunk) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getHighestNonAirBlock(int x, int y) {
        int worldHighestNonAirBlock = this.world.getHighestNonAirBlock(x, y);
        if (worldHighestNonAirBlock >= 0) {
            for (int z = this.minHeight; z < worldHighestNonAirBlock; ++z) {
                if (this.world.getMaterialAt(x, y, z) == Material.AIR) continue;
                return this.maxZ - z;
            }
            return this.maxZ - worldHighestNonAirBlock;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        Chunk chunk = this.world.getChunk(x, z);
        return chunk != null ? new InvertedChunk(chunk, this.delta, this.platform) : null;
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        Chunk chunk = this.world.getChunkForEditing(x, z);
        return chunk != null ? new InvertedChunk(chunk, this.delta, this.platform) : null;
    }

    @Override
    public void close() {
    }
}

