/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.util.Map;
import java.util.Set;
import org.pepsoft.minecraft.ChunkFactory;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class BorderChunkFactory {
    private static final ThreadLocal<PerlinNoise> noiseGenerators = new ThreadLocal();

    public static ChunkFactory.ChunkCreationResult create(int chunkX, int chunkZ, Dimension dimension, Platform platform, Map<Layer, LayerExporter> exporters) {
        Set<Layer> minimumLayers;
        int z;
        int x;
        int biome;
        PerlinNoise noiseGenerator;
        int minHeight = dimension.getMinHeight();
        int maxHeight = dimension.getMaxHeight();
        Dimension.Border border = dimension.getBorder();
        final int borderLevel = dimension.getBorderLevel();
        Dimension.WallType roofType = dimension.getRoofType();
        boolean bottomless = dimension.isBottomless();
        Terrain subsurfaceMaterial = dimension.getSubsurfaceMaterial();
        if (noiseGenerators.get() == null) {
            noiseGenerator = new PerlinNoise(0L);
            noiseGenerators.set(noiseGenerator);
        } else {
            noiseGenerator = noiseGenerators.get();
        }
        long seed = dimension.getSeed();
        if (noiseGenerator.getSeed() != seed) {
            noiseGenerator.setSeed(seed);
        }
        final int floor = Math.max(borderLevel - 20, 0);
        final int variation = Math.min(15, (borderLevel - floor) / 2);
        BiomeUtils biomeUtils = new BiomeUtils();
        ChunkFactory.ChunkCreationResult result = new ChunkFactory.ChunkCreationResult();
        result.chunk = PlatformManager.getInstance().createChunk(platform, chunkX, chunkZ, minHeight, maxHeight);
        int maxY = maxHeight - 1;
        block0 : switch (dimension.getAnchor().dim) {
            case 1: {
                biome = 8;
                break;
            }
            case 2: {
                biome = 9;
                break;
            }
            default: {
                switch (border) {
                    case VOID: 
                    case BARRIER: {
                        biome = BiomeUtils.getBiomeScheme(platform).isBiomePresent(127) ? 127 : 1;
                        break block0;
                    }
                    case WATER: {
                        biome = 0;
                        break block0;
                    }
                }
                biome = 1;
            }
        }
        if (platform.supportsBiomes()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    biomeUtils.set2DBiome(result.chunk, x, z, biome);
                }
            }
        }
        if (border == Dimension.Border.BARRIER) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (int y = minHeight; y <= maxY; ++y) {
                        result.chunk.setMaterial(x, y, z, Material.BARRIER);
                    }
                    if (roofType == Dimension.WallType.BEDROCK) {
                        result.chunk.setMaterial(x, maxY, z, Material.BEDROCK);
                    }
                    result.chunk.setHeight(x, z, maxY);
                }
            }
        } else {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    if (border != Dimension.Border.VOID) {
                        int worldX = chunkX << 4 | x;
                        int worldZ = chunkZ << 4 | z;
                        int floorLevel = Math.round((float)floor + (noiseGenerator.getPerlinNoise((double)((float)worldX / 32.771f), (double)((float)worldZ / 32.771f)) + 0.5f) * (float)variation);
                        int surfaceLayerLevel = floorLevel - dimension.getTopLayerDepth(worldX, worldZ, floorLevel);
                        block19: for (int y = minHeight; y <= maxY; ++y) {
                            if (y == minHeight && !bottomless) {
                                result.chunk.setMaterial(x, y, z, Material.BEDROCK);
                                continue;
                            }
                            if (y <= surfaceLayerLevel) {
                                result.chunk.setMaterial(x, y, z, subsurfaceMaterial.getMaterial(platform, seed, worldX, worldZ, y, floorLevel));
                                continue;
                            }
                            if (y <= floorLevel) {
                                result.chunk.setMaterial(x, y, z, Terrain.BEACHES.getMaterial(platform, seed, worldX, worldZ, y, floorLevel));
                                continue;
                            }
                            if (y > borderLevel) continue;
                            switch (border) {
                                case WATER: {
                                    result.chunk.setMaterial(x, y, z, Material.STATIONARY_WATER);
                                    continue block19;
                                }
                                case LAVA: {
                                    result.chunk.setMaterial(x, y, z, Material.STATIONARY_LAVA);
                                    continue block19;
                                }
                            }
                        }
                    }
                    if (roofType != null) {
                        result.chunk.setMaterial(x, maxY, z, roofType == Dimension.WallType.BEDROCK ? Material.BEDROCK : Material.BARRIER);
                        result.chunk.setHeight(x, z, maxY);
                        continue;
                    }
                    if (border == Dimension.Border.VOID) {
                        result.chunk.setHeight(x, z, minHeight);
                        continue;
                    }
                    result.chunk.setHeight(x, z, borderLevel < maxY ? borderLevel + 1 : maxY);
                }
            }
        }
        if (border != Dimension.Border.VOID && border != Dimension.Border.BARRIER && !(minimumLayers = dimension.getMinimumLayers()).isEmpty()) {
            Tile virtualTile = new Tile(chunkX >> 3, chunkZ >> 3, dimension.getMinHeight(), dimension.getMaxHeight()){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized float getHeight(int x, int y) {
                    return (float)floor + (noiseGenerator.getPerlinNoise((double)((float)(this.getX() << 7 | x) / 32.771f), (double)((float)(this.getY() << 7 | y) / 32.771f)) + 0.5f) * (float)variation;
                }

                @Override
                public synchronized int getWaterLevel(int x, int y) {
                    return borderLevel;
                }
            };
            for (Layer layer : minimumLayers) {
                LayerExporter layerExporter = exporters.get(layer);
                if (!(layerExporter instanceof FirstPassLayerExporter)) continue;
                ((FirstPassLayerExporter)layerExporter).render(virtualTile, result.chunk);
            }
        }
        result.chunk.setTerrainPopulated(!platform.capabilities.contains((Object)Platform.Capability.POPULATE) || !dimension.isPopulate());
        result.stats.surfaceArea = 256L;
        if (border == Dimension.Border.WATER || border == Dimension.Border.LAVA) {
            result.stats.waterArea = 256L;
        }
        return result;
    }
}

