/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.exporting;

import java.awt.Rectangle;
import java.util.function.Supplier;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public abstract class AbstractLayerExporter<L extends Layer>
implements LayerExporter {
    protected final Dimension dimension;
    protected final Platform platform;
    protected final L layer;
    protected final int minHeight;
    protected final int maxHeight;
    protected final int minZ;
    protected final int maxZ;
    protected final ExporterSettings settings;

    public AbstractLayerExporter(Dimension dimension, Platform platform, ExporterSettings settings, L layer) {
        this.dimension = dimension;
        this.platform = platform;
        this.settings = settings;
        this.layer = layer;
        this.minHeight = Math.max(dimension.getMinHeight(), platform.minMinHeight);
        this.minZ = dimension.isBottomless() ? this.minHeight : this.minHeight + 1;
        this.maxHeight = Math.min(dimension.getMaxHeight(), platform.maxMaxHeight);
        this.maxZ = this.maxHeight - 1;
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public final L getLayer() {
        return this.layer;
    }

    protected final boolean visitChunksForLayerInAreaForEditing(MinecraftWorld world, Layer layer, Rectangle area, Dimension dimension, ChunksInTilesVisitor visitor) {
        int chunkX1 = area.x >> 4;
        int chunkX2 = area.x + area.width - 1 >> 4;
        int chunkZ1 = area.y >> 4;
        int chunkZ2 = area.y + area.height - 1 >> 4;
        int tileX1 = chunkX1 >> 3;
        int tileX2 = chunkX2 >> 3;
        int tileY1 = chunkZ1 >> 3;
        int tileY2 = chunkZ2 >> 3;
        boolean applyEverywhere = dimension.getLayerSettings(layer) != null && dimension.getLayerSettings(layer).isApplyEverywhere();
        for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
            for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                Tile tile = dimension.getTile(tileX, tileY);
                if (tile == null || !applyEverywhere && !tile.containsOneOf(layer)) continue;
                for (int chunkXInTile = 0; chunkXInTile < 8; ++chunkXInTile) {
                    for (int chunkYInTile = 0; chunkYInTile < 8; ++chunkYInTile) {
                        int chunkX = tileX << 3 | chunkXInTile;
                        int chunkZ = tileY << 3 | chunkYInTile;
                        if (chunkX < chunkX1 || chunkX > chunkX2 || chunkZ < chunkZ1 || chunkZ > chunkZ2 || !world.isChunkPresent(chunkX, chunkZ) || visitor.visitChunk(tile, chunkX, chunkZ, () -> world.getChunkForEditing(chunkX, chunkZ))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface ChunksInTilesVisitor {
        public boolean visitChunk(Tile var1, int var2, int var3, Supplier<Chunk> var4);
    }
}

