/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.biomeschemes;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.util.Checksum;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_7JarBiomeScheme;

public final class Minecraft1_7LargeBiomeScheme
extends Minecraft1_7JarBiomeScheme {
    private final Object largeBiomesGenerator;
    private static final Map<Checksum, String[]> HASHES_TO_CLASSNAMES = new HashMap<Checksum, String[]>();

    public Minecraft1_7LargeBiomeScheme(File minecraftJar, File libDir, Checksum md5Sum) {
        super(minecraftJar, libDir, md5Sum, HASHES_TO_CLASSNAMES, "1.7.9 or 1.7.2 Large Biomes");
        try {
            Field field = this.worldGeneratorClass.getField("d");
            this.largeBiomesGenerator = field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Not a valid 1.7.9 or 1.7.2 minecraft.jar", e);
        }
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.seed || this.landscape == null) {
            try {
                this.landscape = ((Object[])this.getLandscapesMethod.invoke(null, seed, this.largeBiomesGenerator))[1];
                this.seed = seed;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Access denied while trying to set the seed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception thrown while trying to set the seed", e);
            }
        }
    }

    static {
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{122, 48, 69, 84, -3, -22, -121, -102, 121, -98, -2, 110, -82, -35, -116, -107}), new String[]{"avz", "avx", "afy"});
        HASHES_TO_CLASSNAMES.put(new Checksum(new byte[]{95, 124, -57, -21, 1, -53, -39, 53, -87, -105, 60, -74, -23, -60, -63, 14}), new String[]{"axm", "axk", "ahl"});
    }
}

