/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.WPCustomObjectInputStream;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.UnloadableWorldException;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.vo.EventVO;

public class WorldIO {
    private World2 world;

    public WorldIO() {
    }

    public WorldIO(World2 world) {
        this.world = world;
    }

    public World2 getWorld() {
        return this.world;
    }

    public void setWorld(World2 world) {
        this.world = world;
    }

    public void save(OutputStream out) throws IOException {
        try (ObjectOutputStream wrappedOut = new ObjectOutputStream(new GZIPOutputStream(out));){
            wrappedOut.writeObject(this.getMetadata());
            wrappedOut.writeObject(this.world);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCompartmentalised(OutputStream out) throws IOException {
        try (ZipOutputStream wrappedOut = new ZipOutputStream(out);){
            ObjectMapper objectMapper = new ObjectMapper().disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            wrappedOut.putNextEntry(new ZipEntry("metadata.json"));
            try {
                objectMapper.writeValue((OutputStream)wrappedOut, this.getMetadata());
            }
            finally {
                wrappedOut.closeEntry();
            }
            this.world.save(wrappedOut);
        }
    }

    public void load(InputStream in) throws IOException, UnloadableWorldException {
        Map metadata;
        block20: {
            metadata = null;
            this.world = null;
            try (WPCustomObjectInputStream wrappedIn = new WPCustomObjectInputStream((InputStream)new GZIPInputStream(in), PluginManager.getPluginClassLoader(), new Class[]{AbstractObject.class});){
                Object object = wrappedIn.readObject();
                if (object instanceof Map) {
                    metadata = (Map)object;
                    object = wrappedIn.readObject();
                }
                if (object instanceof World2) {
                    this.world = (World2)object;
                    break block20;
                }
                if (object instanceof World) {
                    this.world = this.migrate(object);
                    break block20;
                }
                throw new UnloadableWorldException("Object of unexpected type " + object.getClass() + " encountered", metadata);
            }
            catch (EOFException | InvalidClassException | StreamCorruptedException | ClassNotFoundException | IllegalArgumentException | ZipException e) {
                throw new UnloadableWorldException(e.getClass().getSimpleName() + " while loading world", e, metadata);
            }
            catch (IOException e) {
                if ("Not in GZIP format".equals(e.getMessage())) {
                    throw new UnloadableWorldException("Not in GZIP format", e, metadata);
                }
                throw e;
            }
        }
        if (metadata != null) {
            this.world.setMetadata(metadata);
        }
    }

    @NotNull
    private Map<String, Object> getMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", this.world.getName());
        metadata.put("org.pepsoft.worldpainter.wp.version", Version.VERSION);
        metadata.put("org.pepsoft.worldpainter.wp.build", Version.BUILD);
        metadata.put("org.pepsoft.worldpainter.timestamp", new Date());
        if (WPPluginManager.getInstance() != null) {
            ArrayList pluginArray = new ArrayList();
            WPPluginManager.getInstance().getAllPlugins().stream().filter(plugin -> !plugin.getClass().getName().startsWith("org.pepsoft.worldpainter")).forEach(plugin -> pluginArray.add(new String[]{plugin.getName(), plugin.getVersion()}));
            if (!pluginArray.isEmpty()) {
                metadata.put("org.pepsoft.worldpainter.plugins", pluginArray.toArray((T[])new String[pluginArray.size()][]));
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private World2 migrate(Object object) {
        if (object instanceof World) {
            World oldWorld = (World)object;
            World2 newWorld = new World2(DefaultPlugin.JAVA_MCREGION, oldWorld.getMinecraftSeed(), oldWorld.getTileFactory());
            newWorld.setCreateGoodiesChest(oldWorld.isCreateGoodiesChest());
            newWorld.setImportedFrom(oldWorld.getImportedFrom());
            newWorld.setName(oldWorld.getName());
            newWorld.setSpawnPoint(oldWorld.getSpawnPoint());
            Dimension dim0 = newWorld.getDimension(Dimension.Anchor.NORMAL_DETAIL);
            newWorld.setAskToConvertToAnvil(true);
            newWorld.setUpIs(Direction.WEST);
            newWorld.setAskToRotate(true);
            newWorld.setAllowMerging(false);
            dim0.setEventsInhibited(true);
            try {
                dim0.setWallType(oldWorld.isBedrockWall() ? Dimension.WallType.BEDROCK : null);
                dim0.setBorder(oldWorld.getBorder() != null ? Dimension.Border.valueOf(oldWorld.getBorder().name()) : null);
                dim0.setRoofType(oldWorld.isDarkLevel() ? Dimension.WallType.BEDROCK : null);
                for (Map.Entry<Layer, ExporterSettings> entry : oldWorld.getAllLayerSettings().entrySet()) {
                    dim0.setLayerSettings(entry.getKey(), entry.getValue());
                }
                dim0.setMinecraftSeed(oldWorld.getMinecraftSeed());
                dim0.setPopulate(oldWorld.isPopulate());
                dim0.setContoursEnabled(false);
                Terrain subsurfaceMaterial = oldWorld.getSubsurfaceMaterial();
                ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)dim0.getLayerSettings(Resources.INSTANCE);
                if (subsurfaceMaterial == Terrain.RESOURCES) {
                    dim0.setSubsurfaceMaterial(Terrain.STONE);
                } else {
                    dim0.setSubsurfaceMaterial(subsurfaceMaterial);
                    resourcesSettings.setMinimumLevel(0);
                }
                TileFactory tileFactory = dim0.getTileFactory();
                if (tileFactory instanceof HeightMapTileFactory && ((HeightMapTileFactory)tileFactory).getWaterHeight() < 32 && ((HeightMapTileFactory)tileFactory).getBaseHeight() < 32.0) {
                    dim0.setGenerator(new SuperflatGenerator(SuperflatPreset.defaultPreset(DefaultPlugin.JAVA_MCREGION)));
                } else {
                    dim0.setGenerator(new SeededGenerator(Generator.DEFAULT, oldWorld.getMinecraftSeed()));
                }
                resourcesSettings.setChance(Material.GOLD_ORE, 1);
                resourcesSettings.setChance(Material.IRON_ORE, 5);
                resourcesSettings.setChance(Material.COAL, 9);
                resourcesSettings.setChance(Material.LAPIS_LAZULI_ORE, 1);
                resourcesSettings.setChance(Material.DIAMOND_ORE, 1);
                resourcesSettings.setChance(Material.REDSTONE_ORE, 6);
                resourcesSettings.setChance(Material.STATIONARY_WATER, 1);
                resourcesSettings.setChance(Material.STATIONARY_LAVA, 1);
                resourcesSettings.setChance(Material.DIRT, 9);
                resourcesSettings.setChance(Material.GRAVEL, 9);
                resourcesSettings.setChance(Material.EMERALD_ORE, 0);
                resourcesSettings.setMaxLevel(Material.GOLD_ORE, 32);
                resourcesSettings.setMaxLevel(Material.IRON_ORE, 48);
                resourcesSettings.setMaxLevel(Material.COAL, Integer.MAX_VALUE);
                resourcesSettings.setMaxLevel(Material.LAPIS_LAZULI_ORE, 32);
                resourcesSettings.setMaxLevel(Material.DIAMOND_ORE, 16);
                resourcesSettings.setMaxLevel(Material.REDSTONE_ORE, 16);
                resourcesSettings.setMaxLevel(Material.STATIONARY_WATER, Integer.MAX_VALUE);
                resourcesSettings.setMaxLevel(Material.STATIONARY_LAVA, 80);
                resourcesSettings.setMaxLevel(Material.DIRT, Integer.MAX_VALUE);
                resourcesSettings.setMaxLevel(Material.GRAVEL, Integer.MAX_VALUE);
                resourcesSettings.setMaxLevel(Material.EMERALD_ORE, 32);
                oldWorld.getTiles().forEach(dim0::addTile);
            }
            finally {
                dim0.setEventsInhibited(false);
            }
            Configuration config = Configuration.getInstance();
            if (config != null) {
                config.logEvent(new EventVO("action.migrateWorld").addTimestamp());
            }
            newWorld.addHistoryEntry(1, new Serializable[0]);
            return newWorld;
        }
        throw new IllegalArgumentException("Don't know how to migrate object of type " + object.getClass());
    }
}

