/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;

public final class Translation
extends CoordinateTransform {
    private final int dx;
    private final int dy;

    public Translation(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            throw new IllegalArgumentException("dx and dy may not both be zero");
        }
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public void transformInPlace(Point coords) {
        coords.x += this.dx;
        coords.y += this.dy;
    }

    @Override
    public void transformInPlace(Point3i coords) {
        coords.x += this.dx;
        coords.y += this.dy;
    }

    @Override
    public Direction transform(Direction direction) {
        return direction;
    }

    @Override
    public Direction inverseTransform(Direction direction) {
        return direction;
    }

    @Override
    public float transformAngle(float angle) {
        return angle;
    }

    @Override
    public float transformScalar(float scalar) {
        return scalar;
    }

    @Override
    public HeightMap transform(HeightMap heightMap) {
        return TransformingHeightMap.build().withHeightMap(heightMap).withName(heightMap.getName()).withOffset(this.dx, this.dy).now();
    }
}

