/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;

public class ScalingHelper {
    private final Map<Point, Tile> unscaledTiles;
    private final TileFactory scaledTileFactory;
    private final float scale;
    private final int minHeight;
    private final int maxHeight;
    private final int lowestTileX;
    private final int lowestTileY;
    private final int highestTileX;
    private final int highestTileY;
    private final HeightMap heightMap;
    private final Map<Layer, HeightMap> layerHeightMaps;
    private final Set<Layer> discreteLayers;
    private final Set<Point> tileCoords;

    public ScalingHelper(final Map<Point, Tile> tiles, final TileFactory tileFactory, float scale) {
        this.unscaledTiles = tiles;
        if (tileFactory instanceof HeightMapTileFactory) {
            HeightMapTileFactory heightMapTileFactory = (HeightMapTileFactory)tileFactory;
            this.scaledTileFactory = new HeightMapTileFactory(tileFactory.getSeed(), heightMapTileFactory.getHeightMap().scaled(scale), tileFactory.getMinHeight(), tileFactory.getMaxHeight(), heightMapTileFactory.isFloodWithLava(), heightMapTileFactory.getTheme());
        } else {
            this.scaledTileFactory = tileFactory;
        }
        this.scale = scale;
        this.minHeight = tileFactory.getMinHeight();
        this.maxHeight = tileFactory.getMaxHeight();
        this.heightMap = new AbstractHeightMap(){
            private final Map<Point, Tile> additionalTiles = new ConcurrentHashMap<Point, Tile>();

            @Override
            public double getHeight(int x, int y) {
                Tile tile = (Tile)tiles.get(new Point(x >> 7, y >> 7));
                if (tile != null) {
                    return tile.getHeight(x & 0x7F, y & 0x7F);
                }
                return this.additionalTiles.computeIfAbsent(new Point(x >> 7, y >> 7), coords -> tileFactory.createTile(coords.x, coords.y)).getHeight(x & 0x7F, y & 0x7F);
            }

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public double[] getRange() {
                return new double[]{ScalingHelper.this.minHeight, ScalingHelper.this.maxHeight};
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new NotSerializableException();
            }
        }.smoothed().scaled(scale).clamped(this.minHeight, this.maxHeight);
        HashSet<Layer> allLayers = new HashSet<Layer>();
        for (Tile tile : tiles.values()) {
            allLayers.addAll(tile.getLayers());
        }
        this.layerHeightMaps = allLayers.stream().filter(layer -> !layer.discrete).collect(Collectors.toMap(Function.identity(), layer -> new AbstractHeightMap((Layer)layer){
            private final Layer.DataSize dataSize;
            final /* synthetic */ Layer val$layer;
            {
                this.val$layer = layer;
                this.dataSize = this.val$layer.dataSize;
            }

            @Override
            public double getHeight(int x, int y) {
                Tile tile = (Tile)tiles.get(new Point(x >> 7, y >> 7));
                if (tile != null) {
                    switch (this.dataSize) {
                        case BIT: 
                        case BIT_PER_CHUNK: {
                            return tile.getBitLayerValue(this.val$layer, x & 0x7F, y & 0x7F) ? 1.0 : 0.0;
                        }
                        case NIBBLE: 
                        case BYTE: {
                            return tile.getLayerValue(this.val$layer, x & 0x7F, y & 0x7F);
                        }
                    }
                    throw new IllegalStateException("Unsupported data size " + (Object)((Object)this.dataSize) + " for layer " + this.val$layer);
                }
                return this.val$layer.getDefaultValue();
            }

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public double[] getRange() {
                switch (this.dataSize) {
                    case BIT: 
                    case BIT_PER_CHUNK: {
                        return new double[]{0.0, 1.0};
                    }
                    case NIBBLE: {
                        return new double[]{0.0, 15.0};
                    }
                    case BYTE: {
                        return new double[]{0.0, 255.0};
                    }
                }
                throw new IllegalStateException("Unsupported data size " + (Object)((Object)this.dataSize) + " for layer " + this.val$layer);
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new NotSerializableException();
            }
        }.smoothed().scaled(scale).clamped(0.0, layer.dataSize.maxValue)));
        this.discreteLayers = allLayers.stream().filter(layer -> layer.discrete).collect(Collectors.toSet());
        this.tileCoords = new HashSet<Point>();
        int lowestTileX = Integer.MAX_VALUE;
        int lowestTileY = Integer.MAX_VALUE;
        int highestTileX = Integer.MIN_VALUE;
        int highestTileY = Integer.MIN_VALUE;
        for (Tile tile : tiles.values()) {
            Point coordsOfTile = new Point(tile.getX(), tile.getY());
            int scaledTileX1 = Math.round((float)(coordsOfTile.x << 7) * scale) >> 7;
            int scaledTileX2 = Math.round((float)((coordsOfTile.x << 7) + 128 - 1) * scale) >> 7;
            int scaledTileY1 = Math.round((float)(coordsOfTile.y << 7) * scale) >> 7;
            int scaledTileY2 = Math.round((float)((coordsOfTile.y << 7) + 128 - 1) * scale) >> 7;
            for (int x = scaledTileX1; x <= scaledTileX2; ++x) {
                for (int y = scaledTileY1; y <= scaledTileY2; ++y) {
                    if (x < lowestTileX) {
                        lowestTileX = x;
                    }
                    if (x > highestTileX) {
                        highestTileX = x;
                    }
                    if (y < lowestTileY) {
                        lowestTileY = y;
                    }
                    if (y > highestTileY) {
                        highestTileY = y;
                    }
                    this.tileCoords.add(new Point(x, y));
                }
            }
        }
        this.lowestTileX = lowestTileX;
        this.lowestTileY = lowestTileY;
        this.highestTileX = highestTileX;
        this.highestTileY = highestTileY;
    }

    public Tile createScaledTile(int tileX, int tileY) {
        if (!this.tileCoords.contains(new Point(tileX, tileY))) {
            return null;
        }
        Tile scaledTile = this.scaledTileFactory.createTile(tileX, tileY);
        int[] notPresentBlocksPerChunk = new int[64];
        Tile cachedUnscaledTile = null;
        int cachedTileX = Integer.MIN_VALUE;
        int cachedTileY = Integer.MIN_VALUE;
        for (int xInTile = 0; xInTile < 128; ++xInTile) {
            for (int yInTile = 0; yInTile < 128; ++yInTile) {
                int x = xInTile + (tileX << 7);
                int y = yInTile + (tileY << 7);
                float scaledX = (float)x / this.scale;
                float scaledY = (float)y / this.scale;
                int intX = (int)scaledX;
                int intY = (int)scaledY;
                int unscaledTileX = intX >> 7;
                int unscaledTileY = intY >> 7;
                if (unscaledTileX != cachedTileX || unscaledTileY != cachedTileY) {
                    cachedUnscaledTile = this.unscaledTiles.get(new Point(unscaledTileX, unscaledTileY));
                    cachedTileX = unscaledTileX;
                    cachedTileY = unscaledTileY;
                }
                if (cachedUnscaledTile == null) {
                    int n = xInTile >> 4 << 3 | yInTile >> 4;
                    notPresentBlocksPerChunk[n] = notPresentBlocksPerChunk[n] + 1;
                    continue;
                }
                scaledTile.setHeight(xInTile, yInTile, (float)this.heightMap.getHeight(x, y));
                scaledTile.setWaterLevel(xInTile, yInTile, cachedUnscaledTile.getWaterLevel(intX & 0x7F, intY & 0x7F));
                scaledTile.setTerrain(xInTile, yInTile, cachedUnscaledTile.getTerrain(intX & 0x7F, intY & 0x7F));
                for (Map.Entry<Layer, HeightMap> entry : this.layerHeightMaps.entrySet()) {
                    Layer layer = entry.getKey();
                    int layerValue = (int)Math.round(entry.getValue().getHeight(x, y));
                    if (layerValue == layer.getDefaultValue()) continue;
                    switch (layer.dataSize) {
                        case BIT: 
                        case BIT_PER_CHUNK: {
                            scaledTile.setBitLayerValue(layer, xInTile, yInTile, true);
                            break;
                        }
                        case NIBBLE: 
                        case BYTE: {
                            scaledTile.setLayerValue(layer, xInTile, yInTile, layerValue);
                        }
                    }
                }
                for (Layer layer : this.discreteLayers) {
                    switch (layer.dataSize) {
                        case BIT: 
                        case BIT_PER_CHUNK: {
                            if (!cachedUnscaledTile.getBitLayerValue(layer, intX & 0x7F, intY & 0x7F)) break;
                            scaledTile.setBitLayerValue(layer, xInTile, yInTile, true);
                            break;
                        }
                        case NIBBLE: 
                        case BYTE: {
                            int layerValue = cachedUnscaledTile.getLayerValue(layer, intX & 0x7F, intY & 0x7F);
                            if (layerValue == layer.getDefaultValue()) break;
                            scaledTile.setLayerValue(layer, xInTile, yInTile, layerValue);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < 64; ++i) {
            if (notPresentBlocksPerChunk[i] != 256) continue;
            scaledTile.setBitLayerValue(NotPresent.INSTANCE, i >> 3 << 4, (i & 7) << 4, true);
        }
        return scaledTile;
    }

    public Set<Tile> getAllScaledTiles(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        HashSet<Tile> result = new HashSet<Tile>();
        int count = 0;
        for (Point coordsOfTile : this.tileCoords) {
            int tileX = coordsOfTile.x;
            int tileY = coordsOfTile.y;
            Tile scaledTile = this.createScaledTile(tileX, tileY);
            result.add(scaledTile);
            ++count;
            if (progressReceiver == null) continue;
            progressReceiver.setProgress((float)count / (float)this.tileCoords.size());
        }
        return result;
    }

    public int getLowestTileX() {
        return this.lowestTileX;
    }

    public int getLowestTileY() {
        return this.lowestTileY;
    }

    public int getHighestTileX() {
        return this.highestTileX;
    }

    public int getHighestTileY() {
        return this.highestTileY;
    }

    public Set<Point> getTileCoords() {
        return this.tileCoords;
    }

    public float getHeightAt(int x, int y) {
        return (float)this.heightMap.getHeight(x, y);
    }

    public int getLayerValueAt(Layer layer, int x, int y) {
        return this.layerHeightMaps.containsKey(layer) ? (int)Math.round(this.layerHeightMaps.get(layer).getHeight(x, y)) : layer.getDefaultValue();
    }

    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        return (this.layerHeightMaps.containsKey(layer) ? this.layerHeightMaps.get(layer).getHeight(x, y) : (double)layer.getDefaultValue()) >= 0.5;
    }
}

