/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.pepsoft.util.FileUtils;

public class Overlay
implements Serializable {
    private final File file;
    private float scale = 1.0f;
    private float transparency = 0.5f;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean enabled = true;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient BufferedImage image;
    private static final long serialVersionUID = 1L;

    public Overlay(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = FileUtils.absolutise((File)file);
    }

    public File getFile() {
        return this.file;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        if (scale != this.scale) {
            float oldScale = this.scale;
            this.scale = scale;
            this.propertyChangeSupport.firePropertyChange("scale", Float.valueOf(oldScale), Float.valueOf(scale));
        }
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        if (transparency != this.transparency) {
            float oldTransparency = this.transparency;
            this.transparency = transparency;
            this.propertyChangeSupport.firePropertyChange("transparency", Float.valueOf(oldTransparency), Float.valueOf(transparency));
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        if (offsetX != this.offsetX) {
            int oldOffsetX = this.offsetX;
            this.offsetX = offsetX;
            this.propertyChangeSupport.firePropertyChange("offsetX", oldOffsetX, offsetX);
        }
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        if (offsetY != this.offsetY) {
            int oldOffsetY = this.offsetY;
            this.offsetY = offsetY;
            this.propertyChangeSupport.firePropertyChange("offsetY", oldOffsetY, offsetY);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.propertyChangeSupport.firePropertyChange("enabled", !enabled, enabled);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        if (!Objects.equals(image, this.image)) {
            BufferedImage oldImage = this.image;
            this.image = image;
            this.propertyChangeSupport.firePropertyChange("image", oldImage, image);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }
}

