/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.pepsoft.worldpainter.MixedMaterial;

public class MixedMaterialManager {
    private final Map<UUID, MixedMaterial> materialsById = new HashMap<UUID, MixedMaterial>();
    private static final MixedMaterialManager INSTANCE = new MixedMaterialManager();

    public MixedMaterial[] getMaterials() {
        return this.materialsById.values().toArray(new MixedMaterial[0]);
    }

    public synchronized void clear() {
        this.materialsById.clear();
    }

    public synchronized void clear(MixedMaterial material) {
        if (!this.materialsById.containsKey(material.getId())) {
            throw new IllegalArgumentException("Material " + material + " not registered");
        }
        this.materialsById.remove(material.getId());
    }

    public synchronized MixedMaterial register(MixedMaterial material) {
        UUID id = material.getId();
        if (id == null) {
            for (Map.Entry<UUID, MixedMaterial> entry : this.materialsById.entrySet()) {
                MixedMaterial existingMaterial = entry.getValue();
                if (existingMaterial.getBiome() != material.getBiome() || existingMaterial.getMode() != material.getMode() || existingMaterial.getScale() != material.getScale() || existingMaterial.isRepeat() != material.isRepeat() || existingMaterial.getLayerXSlope() != material.getLayerXSlope() || existingMaterial.getLayerYSlope() != material.getLayerYSlope() || !(existingMaterial.getVariation() == null ? material.getVariation() == null : existingMaterial.getVariation().equals(material.getVariation())) || !Arrays.equals(existingMaterial.getRows(), material.getRows())) continue;
                return existingMaterial;
            }
            return this.registerAsNew(material);
        }
        if (this.materialsById.containsKey(id)) {
            return this.materialsById.get(id);
        }
        this.materialsById.put(id, material);
        return material;
    }

    public synchronized MixedMaterial registerAsNew(MixedMaterial material) {
        material = new MixedMaterial(material.getName(), material.getRows(), material.getBiome(), material.getMode(), material.getScale(), material.getColour(), material.getVariation(), material.getLayerXSlope(), material.getLayerYSlope(), material.isRepeat());
        this.materialsById.put(material.getId(), material);
        return material;
    }

    public static MixedMaterialManager getInstance() {
        return INSTANCE;
    }
}

