/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.ProductHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;

public class HeightTransform {
    private final float scalingFactor;
    private final int translateAmount;
    public static final HeightTransform IDENTITY = new HeightTransform(100, 0){

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public float transformHeight(float height) {
            return height;
        }

        @Override
        public int transformHeight(int height) {
            return height;
        }

        @Override
        public HeightMap transformHeightMap(HeightMap heightMap) {
            return heightMap;
        }
    };

    private HeightTransform(int scaleAmount, int translateAmount) {
        this.scalingFactor = (float)scaleAmount / 100.0f;
        this.translateAmount = translateAmount;
    }

    public boolean isIdentity() {
        return false;
    }

    public float transformHeight(float height) {
        return height * this.scalingFactor + (float)this.translateAmount;
    }

    public int transformHeight(int height) {
        return Math.round((float)height * this.scalingFactor + (float)this.translateAmount);
    }

    public HeightMap transformHeightMap(HeightMap heightMap) {
        if (this.scalingFactor != 1.0f) {
            heightMap = new ProductHeightMap(heightMap.getName(), heightMap, new ConstantHeightMap("scale", this.scalingFactor));
        }
        if (this.translateAmount != 0) {
            heightMap = new SumHeightMap(heightMap.getName(), heightMap, new ConstantHeightMap("translate", this.translateAmount));
        }
        return heightMap;
    }

    public static HeightTransform get(int scaleAmount, int translateAmount) {
        if (scaleAmount == 100 && translateAmount == 0) {
            return IDENTITY;
        }
        return new HeightTransform(scaleAmount, translateAmount);
    }
}

