/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.SortedMap;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.AbstractTileFactory;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.Theme;

public class HeightMapTileFactory
extends AbstractTileFactory {
    @Deprecated
    int waterHeight = -1;
    @Deprecated
    private Terrain[] terrainRangesTable;
    private final boolean floodWithLava;
    private int minHeight;
    private int maxHeight;
    @Deprecated
    private SortedMap<Integer, Terrain> terrainRanges;
    @Deprecated
    private boolean randomise;
    @Deprecated
    private boolean beaches;
    private long seed;
    private HeightMap heightMap;
    private Theme theme;
    private int version = 1;
    private static final long serialVersionUID = 2011032801L;
    private static final int CURRENT_VERSION = 1;

    public HeightMapTileFactory(long seed, HeightMap heightMap, int minHeight, int maxHeight, boolean floodWithLava, Theme theme) {
        this.seed = seed;
        this.minHeight = minHeight;
        this.heightMap = heightMap;
        this.maxHeight = maxHeight;
        this.floodWithLava = floodWithLava;
        heightMap.setSeed(seed);
        theme.setSeed(seed);
        this.theme = theme;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public final int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.heightMap.setSeed(seed);
        this.theme.setSeed(seed);
    }

    @Override
    public final void setMinMaxHeight(int minHeight, int maxHeight, HeightTransform transform) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.theme.setMinMaxHeight(minHeight, maxHeight, transform);
        if (!transform.isIdentity()) {
            this.heightMap = transform.transformHeightMap(this.heightMap);
        }
    }

    public final int getWaterHeight() {
        return this.theme.getWaterHeight();
    }

    public final void setWaterHeight(int waterHeight) {
        this.theme.setWaterHeight(waterHeight);
    }

    public final boolean isFloodWithLava() {
        return this.floodWithLava;
    }

    public final HeightMap getHeightMap() {
        return this.heightMap;
    }

    public final double getBaseHeight() {
        return this.heightMap.getBaseHeight();
    }

    public final void setHeightMap(HeightMap heightMap) {
        if (heightMap == null) {
            throw new NullPointerException();
        }
        this.heightMap = heightMap;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        theme.setMinMaxHeight(this.minHeight, this.maxHeight, HeightTransform.IDENTITY);
    }

    @Override
    public boolean isTilePresent(int x, int y) {
        Rectangle extent = this.getExtent();
        return extent == null || extent.contains(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tile createTile(int tileX, int tileY) {
        int maxZ = this.maxHeight - 1;
        int myWaterHeight = this.getWaterHeight();
        Tile tile = new Tile(tileX, tileY, this.minHeight, this.maxHeight);
        tile.inhibitEvents();
        int worldTileX = tileX * 128;
        int worldTileY = tileY * 128;
        try {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int blockX = worldTileX + x;
                    int blockY = worldTileY + y;
                    float height = MathUtils.clamp((float)this.minHeight, (float)((float)this.heightMap.getHeight(blockX, blockY)), (float)maxZ);
                    tile.setHeight(x, y, height);
                    tile.setWaterLevel(x, y, myWaterHeight);
                    if (this.floodWithLava) {
                        tile.setBitLayerValue(FloodWithLava.INSTANCE, x, y, true);
                    }
                    this.theme.apply(tile, x, y);
                }
            }
            Tile tile2 = tile;
            return tile2;
        }
        finally {
            tile.releaseEvents();
        }
    }

    @Override
    public Rectangle getExtent() {
        Rectangle heightMapExtent = this.heightMap.getExtent();
        if (heightMapExtent != null) {
            int tileX1 = heightMapExtent.x >> 7;
            int tileY1 = heightMapExtent.y >> 7;
            int tileX2 = heightMapExtent.x + heightMapExtent.width - 1 >> 7;
            int tileY2 = heightMapExtent.y + heightMapExtent.height - 1 >> 7;
            return new Rectangle(tileX1, tileY1, tileX2 - tileX1 + 1, tileY2 - tileY1 + 1);
        }
        return null;
    }

    @Override
    public final void applyTheme(Tile tile, int x, int y) {
        this.theme.apply(tile, x, y);
    }

    @Override
    public void transform(CoordinateTransform transform) {
        this.heightMap = transform.transform(this.heightMap);
    }

    protected final void setRandomise(boolean randomise) {
        this.randomise = randomise;
    }

    protected final void setBeaches(boolean beaches) {
        this.beaches = beaches;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.maxHeight == 0) {
            this.maxHeight = 128;
        }
        if (this.version < 1) {
            this.theme = this.terrainRanges != null ? new SimpleTheme(this.seed, this.waterHeight, this.terrainRanges, null, this.minHeight, this.maxHeight, this.randomise, this.beaches) : new SimpleTheme(this.seed, this.waterHeight, this.terrainRangesTable, this.minHeight, this.maxHeight, this.randomise, this.beaches);
            this.waterHeight = -1;
            this.terrainRanges = null;
            this.terrainRangesTable = null;
            this.randomise = false;
            this.beaches = false;
        }
        this.version = 1;
    }
}

