/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.Icon;
import javax.vecmath.Point3i;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.CoordinateTransform;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.DimensionSnapshot;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.InstanceKeeper;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.ScalingHelper;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.biomeschemes.CustomBiome;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.gardenofeden.Garden;
import org.pepsoft.worldpainter.gardenofeden.Seed;
import org.pepsoft.worldpainter.heightMaps.AbstractHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.DeciduousForest;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.GardenCategory;
import org.pepsoft.worldpainter.layers.Jungle;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.LayerContainer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.PineForest;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.River;
import org.pepsoft.worldpainter.layers.SwampLand;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.selection.SelectionBlock;
import org.pepsoft.worldpainter.selection.SelectionChunk;
import org.pepsoft.worldpainter.util.GeometryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dimension
extends InstanceKeeper
implements TileProvider,
Serializable,
Tile.Listener,
Cloneable {
    private World2 world;
    private final long seed;
    @Deprecated
    private int dim = 0;
    Map<Point, Tile> tiles = new HashMap<Point, Tile>();
    private final TileFactory tileFactory;
    private int lowestX = Integer.MAX_VALUE;
    private int highestX = Integer.MIN_VALUE;
    private int lowestY = Integer.MAX_VALUE;
    private int highestY = Integer.MIN_VALUE;
    private Terrain subsurfaceMaterial = Terrain.STONE_MIX;
    private boolean populate;
    private Border border;
    private int borderLevel = 62;
    private int borderSize = 2;
    @Deprecated
    private boolean darkLevel;
    @Deprecated
    private boolean bedrockWall;
    private Map<Layer, ExporterSettings> layerSettings = new HashMap<Layer, ExporterSettings>();
    private long minecraftSeed;
    @Deprecated
    private File overlay;
    @Deprecated
    private float overlayScale = 1.0f;
    @Deprecated
    private float overlayTransparency = 0.5f;
    @Deprecated
    private int overlayOffsetX;
    @Deprecated
    private int overlayOffsetY;
    private int gridSize = 128;
    private boolean overlayEnabled;
    private boolean gridEnabled;
    private boolean biomesConverted = true;
    private int minHeight;
    private int maxHeight;
    private int contourSeparation = 10;
    private boolean contoursEnabled = true;
    private int topLayerMinDepth = 3;
    private int topLayerVariation = 4;
    private boolean bottomless;
    private Point lastViewPosition = new Point();
    private List<CustomBiome> customBiomes;
    private boolean coverSteepTerrain = true;
    private List<CustomLayer> customLayers = new ArrayList<CustomLayer>();
    private int wpVersion = 9;
    private boolean fixOverlayCoords;
    private int ceilingHeight;
    private Map<String, Object> attributes;
    private LayerAnchor subsurfaceLayerAnchor = LayerAnchor.BEDROCK;
    private LayerAnchor topLayerAnchor = LayerAnchor.BEDROCK;
    private ExportSettings exportSettings;
    private MapGenerator generator;
    private WallType wallType;
    private WallType roofType;
    private Anchor anchor;
    private float scale = 1.0f;
    private String name;
    private Set<String> hiddenPalettes;
    private String soloedPalette;
    private UUID id = UUID.randomUUID();
    private List<Overlay> overlays = new ArrayList<Overlay>();
    private transient List<Listener> listeners = new ArrayList<Listener>();
    private transient boolean eventsInhibited;
    private transient Set<Tile> dirtyTiles = new HashSet<Tile>();
    private transient Set<Tile> addedTiles = new HashSet<Tile>();
    private transient Set<Tile> removedTiles = new HashSet<Tile>();
    private transient UndoManager undoManager;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient WPGarden garden = new WPGarden();
    private transient PerlinNoise topLayerDepthNoise;
    private transient long changeNo;
    private transient long rememberedChangeNo = -1L;
    private transient ThreadLocal<int[]> biomeHistogramRef = ThreadLocal.withInitial(() -> new int[255]);
    private transient ReadWriteLock lock = new ReentrantReadWriteLock();
    private transient Lock readLock = this.lock.readLock();
    private transient Lock writeLock = this.lock.writeLock();
    public static final int[] POSSIBLE_AUTO_BIOMES = new int[]{1, 4, 6, 21, 37, 2, 16, 7, 0, 24, 12, 30, 11, 10, 14, 8, 9};
    private static final long TOP_LAYER_DEPTH_SEED_OFFSET = 180728193L;
    private static final float ROOT_EIGHT = (float)Math.sqrt(8.0);
    private static final int CURRENT_WP_VERSION = 9;
    private static final Logger logger = LoggerFactory.getLogger(Dimension.class);
    private static final long serialVersionUID = 2011062401L;

    public Dimension(World2 world, String name, long minecraftSeed, TileFactory tileFactory, Anchor anchor) {
        this(world, name, minecraftSeed, tileFactory, anchor, true);
    }

    public Dimension(World2 world, String name, long minecraftSeed, TileFactory tileFactory, Anchor anchor, boolean init) {
        if (world == null) {
            throw new NullPointerException("world");
        }
        this.world = world;
        this.seed = tileFactory.getSeed();
        this.name = name;
        this.minecraftSeed = minecraftSeed;
        this.tileFactory = tileFactory;
        this.anchor = anchor;
        this.minHeight = tileFactory.getMinHeight();
        this.ceilingHeight = this.maxHeight = tileFactory.getMaxHeight();
        if (init) {
            this.layerSettings.put(Resources.INSTANCE, ResourcesExporter.ResourcesExporterSettings.defaultSettings(world.getPlatform(), anchor, this.minHeight, this.maxHeight));
            this.topLayerDepthNoise = new PerlinNoise(this.seed + 180728193L);
            if (anchor.role == Role.DETAIL) {
                switch (anchor.dim) {
                    case 0: {
                        this.generator = new SeededGenerator(Generator.DEFAULT, minecraftSeed);
                        break;
                    }
                    case 1: {
                        this.generator = new SeededGenerator(Generator.NETHER, minecraftSeed);
                        break;
                    }
                    case 2: {
                        this.generator = new SeededGenerator(Generator.END, minecraftSeed);
                    }
                }
            }
        }
    }

    public World2 getWorld() {
        return this.world;
    }

    public void setWorld(World2 world) {
        this.world = world;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!Objects.equals(name, this.name)) {
            String oldName = this.name;
            this.name = name;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("name", oldName, name);
        }
    }

    public long getChangeNo() {
        return this.changeNo;
    }

    public void changed() {
        ++this.changeNo;
    }

    public long getSeed() {
        return this.seed;
    }

    public Terrain getSubsurfaceMaterial() {
        return this.subsurfaceMaterial;
    }

    public void setSubsurfaceMaterial(Terrain subsurfaceMaterial) {
        if (subsurfaceMaterial != this.subsurfaceMaterial) {
            Terrain oldSubsurfaceMaterial = this.subsurfaceMaterial;
            this.subsurfaceMaterial = subsurfaceMaterial;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("subsurfaceMaterial", (Object)oldSubsurfaceMaterial, (Object)subsurfaceMaterial);
        }
    }

    public boolean isPopulate() {
        return this.populate;
    }

    public void setPopulate(boolean populate) {
        if (populate != this.populate) {
            this.populate = populate;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("populate", !populate, populate);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border oldBorder = this.border;
            this.border = border;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("border", (Object)oldBorder, (Object)border);
        }
    }

    public int getBorderLevel() {
        return this.borderLevel;
    }

    public void setBorderLevel(int borderLevel) {
        if (borderLevel != this.borderLevel) {
            int oldBorderLevel = this.borderLevel;
            this.borderLevel = borderLevel;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("borderLevel", oldBorderLevel, borderLevel);
        }
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        if (borderSize != this.borderSize) {
            int oldBorderSize = this.borderSize;
            this.borderSize = borderSize;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("borderSize", oldBorderSize, borderSize);
        }
    }

    public TileFactory getTileFactory() {
        return this.tileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTilePresent(int x, int y) {
        this.readLock.lock();
        try {
            boolean bl = this.tiles.containsKey(new Point(x, y));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBorderTile(int x, int y) {
        this.readLock.lock();
        try {
            if (this.border == null || !this.border.isEndless() && (x < this.lowestX - this.borderSize || x > this.highestX + this.borderSize || y < this.lowestY - this.borderSize || y > this.highestY + this.borderSize)) {
                boolean bl = false;
                return bl;
            }
            if (this.tiles.containsKey(new Point(x, y))) {
                boolean bl = false;
                return bl;
            }
            if (this.border.isEndless()) {
                boolean bl = true;
                return bl;
            }
            for (int r = 1; r <= this.borderSize; ++r) {
                for (int i = 0; i <= r * 2; ++i) {
                    if (!this.tiles.containsKey(new Point(x + i - r, y - r)) && !this.tiles.containsKey(new Point(x + r, y + i - r)) && !this.tiles.containsKey(new Point(x + r - i, y + r)) && !this.tiles.containsKey(new Point(x - r, y - i + r))) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tile getTile(int x, int y) {
        this.readLock.lock();
        try {
            Tile tile = this.tiles.get(new Point(x, y));
            return tile;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Tile getTile(Point coords) {
        this.readLock.lock();
        try {
            Tile tile = this.tiles.get(coords);
            return tile;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tile getTileForEditing(int x, int y) {
        this.readLock.lock();
        try {
            Tile tile = this.tiles.get(new Point(x, y));
            if (tile != null && this.eventsInhibited && !tile.isEventsInhibited()) {
                tile.inhibitEvents();
                this.dirtyTiles.add(tile);
            }
            Tile tile2 = tile;
            return tile2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tile getTileForEditing(Point coords) {
        this.readLock.lock();
        try {
            Tile tile = this.tiles.get(coords);
            if (tile != null && this.eventsInhibited && !tile.isEventsInhibited()) {
                tile.inhibitEvents();
                this.dirtyTiles.add(tile);
            }
            Tile tile2 = tile;
            return tile2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Rectangle getExtent() {
        return new Rectangle(this.lowestX, this.lowestY, this.highestX - this.lowestX + 1, this.highestY - this.lowestY + 1);
    }

    public int getTileCount() {
        return this.tiles.size();
    }

    public Collection<? extends Tile> getTiles() {
        this.readLock.lock();
        try {
            Collection<Tile> collection = Collections.unmodifiableCollection(this.tiles.values());
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Point> getTileCoords() {
        this.readLock.lock();
        try {
            Set<Point> set = Collections.unmodifiableSet(this.tiles.keySet());
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTile(Tile tile) {
        this.writeLock.lock();
        try {
            int y;
            if (tile.getMaxHeight() != this.maxHeight) {
                throw new IllegalArgumentException("Tile has different max height (" + tile.getMaxHeight() + ") than dimension (" + this.maxHeight + ")");
            }
            int x = tile.getX();
            Point key = new Point(x, y = tile.getY());
            if (this.tiles.containsKey(key)) {
                throw new IllegalStateException("Tile already set");
            }
            tile.addListener(this);
            if (this.undoManager != null) {
                tile.register(this.undoManager);
            }
            this.tiles.put(key, tile);
            if (x < this.lowestX) {
                this.lowestX = x;
            }
            if (x > this.highestX) {
                this.highestX = x;
            }
            if (y < this.lowestY) {
                this.lowestY = y;
            }
            if (y > this.highestY) {
                this.highestY = y;
            }
            this.fireTileAdded(tile);
            ++this.changeNo;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeTile(int tileX, int tileY) {
        this.removeTile(new Point(tileX, tileY));
    }

    public void removeTile(Tile tile) {
        this.removeTile(tile.getX(), tile.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTile(Point coords) {
        this.writeLock.lock();
        try {
            if (!this.tiles.containsKey(coords)) {
                throw new IllegalStateException("Tile not set");
            }
            Tile tile = this.tiles.remove(coords);
            if (this.undoManager != null) {
                tile.unregister();
            }
            tile.removeListener(this);
            if (coords.x == this.lowestX || coords.x == this.highestX || coords.y == this.lowestY || coords.y == this.highestY) {
                this.lowestX = Integer.MAX_VALUE;
                this.highestX = Integer.MIN_VALUE;
                this.lowestY = Integer.MAX_VALUE;
                this.highestY = Integer.MIN_VALUE;
                for (Tile myTile : this.tiles.values()) {
                    int myTileX = myTile.getX();
                    int myTileY = myTile.getY();
                    if (myTileX < this.lowestX) {
                        this.lowestX = myTileX;
                    }
                    if (myTileX > this.highestX) {
                        this.highestX = myTileX;
                    }
                    if (myTileY < this.lowestY) {
                        this.lowestY = myTileY;
                    }
                    if (myTileY <= this.highestY) continue;
                    this.highestY = myTileY;
                }
            }
            this.fireTileRemoved(tile);
            ++this.changeNo;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getHighestX() {
        return this.highestX;
    }

    public int getHighestY() {
        return this.highestY;
    }

    public int getLowestX() {
        return this.lowestX;
    }

    public int getLowestY() {
        return this.lowestY;
    }

    public int getWidth() {
        if (this.highestX == Integer.MIN_VALUE) {
            return 0;
        }
        return this.highestX - this.lowestX + 1;
    }

    public int getHeight() {
        if (this.highestY == Integer.MIN_VALUE) {
            return 0;
        }
        return this.highestY - this.lowestY + 1;
    }

    public int getIntHeightAt(int x, int y) {
        return this.getIntHeightAt(x, y, Integer.MIN_VALUE);
    }

    public int getIntHeightAt(int x, int y, int defaultHeight) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getIntHeight(x & 0x7F, y & 0x7F);
        }
        return defaultHeight;
    }

    public int getIntHeightAt(Point coords) {
        return this.getIntHeightAt(coords.x, coords.y, Integer.MIN_VALUE);
    }

    public int getLowestIntHeight() {
        return Math.round((float)this.getLowestRawHeight() / 256.0f + (float)this.minHeight);
    }

    public int getHighestIntHeight() {
        return Math.round((float)this.getHighestRawHeight() / 256.0f + (float)this.minHeight);
    }

    public int[] getIntHeightRange() {
        int[] rawHeightRange = this.getRawHeightRange();
        return new int[]{Math.round((float)rawHeightRange[0] / 256.0f + (float)this.minHeight), Math.round((float)rawHeightRange[1] / 256.0f + (float)this.minHeight)};
    }

    public float getHeightAt(int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getHeight(x & 0x7F, y & 0x7F);
        }
        return -3.4028235E38f;
    }

    public float getHeightAt(Point coords) {
        return this.getHeightAt(coords.x, coords.y);
    }

    public float getLowestHeight() {
        return (float)this.getLowestRawHeight() / 256.0f + (float)this.minHeight;
    }

    public float getHighestHeight() {
        return (float)this.getHighestRawHeight() / 256.0f + (float)this.minHeight;
    }

    public float[] getHeightRange() {
        int[] rawHeightRange = this.getRawHeightRange();
        return new float[]{(float)rawHeightRange[0] / 256.0f + (float)this.minHeight, (float)rawHeightRange[1] / 256.0f + (float)this.minHeight};
    }

    public void setHeightAt(int x, int y, float height) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setHeight(x & 0x7F, y & 0x7F, height);
        }
    }

    public void setHeightAt(Point coords, float height) {
        this.setHeightAt(coords.x, coords.y, height);
    }

    public int getRawHeightAt(int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getRawHeight(x & 0x7F, y & 0x7F);
        }
        return Integer.MIN_VALUE;
    }

    public int getLowestRawHeight() {
        int lowestRawHeight = Integer.MAX_VALUE;
        for (Tile tile : this.getTiles()) {
            int tileLowestRawHeight = tile.getLowestRawHeight();
            if (tileLowestRawHeight < lowestRawHeight) {
                lowestRawHeight = tileLowestRawHeight;
            }
            if (lowestRawHeight > 0) continue;
            return 0;
        }
        return lowestRawHeight;
    }

    public int getHighestRawHeight() {
        int highestRawHeight = Integer.MIN_VALUE;
        int maxRawHeight = (this.maxHeight - 1 - this.minHeight) * 256;
        for (Tile tile : this.getTiles()) {
            int tileHighestRawHeight = tile.getHighestRawHeight();
            if (tileHighestRawHeight > highestRawHeight) {
                highestRawHeight = tileHighestRawHeight;
            }
            if (highestRawHeight < maxRawHeight) continue;
            return maxRawHeight;
        }
        return highestRawHeight;
    }

    public int[] getRawHeightRange() {
        int lowestRawHeight = Integer.MAX_VALUE;
        int highestRawHeight = Integer.MIN_VALUE;
        int maxRawHeight = (this.maxHeight - 1 - this.minHeight) * 256;
        for (Tile tile : this.getTiles()) {
            int[] tileRawHeightRange = tile.getRawHeightRange();
            if (tileRawHeightRange[0] < lowestRawHeight) {
                lowestRawHeight = tileRawHeightRange[0];
            }
            if (tileRawHeightRange[1] > highestRawHeight) {
                highestRawHeight = tileRawHeightRange[1];
            }
            if (lowestRawHeight > 0 || highestRawHeight < maxRawHeight) continue;
            return new int[]{0, maxRawHeight};
        }
        return new int[]{lowestRawHeight, highestRawHeight};
    }

    public int getRawHeightAt(Point coords) {
        return this.getRawHeightAt(coords.x, coords.y);
    }

    public void setRawHeightAt(int x, int y, int rawHeight) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setRawHeight(x & 0x7F, y & 0x7F, rawHeight);
        }
    }

    public void setRawHeightAt(Point coords, int rawHeight) {
        this.setRawHeightAt(coords.x, coords.y, rawHeight);
    }

    public float getSlope(int x, int y) {
        return this.doGetSlope(x, y);
    }

    protected final float doGetSlope(int x, int y) {
        int xInTile = x & 0x7F;
        int yInTile = y & 0x7F;
        if (xInTile > 0 && xInTile < 127 && yInTile > 0 && yInTile < 127) {
            Tile tile = this.getTile(x >> 7, y >> 7);
            if (tile != null) {
                return tile.getSlope(xInTile, yInTile);
            }
            return 0.0f;
        }
        return Math.max(Math.max(Math.abs(this.getHeightAt(x + 1, y) - this.getHeightAt(x - 1, y)) / 2.0f, Math.abs(this.getHeightAt(x + 1, y + 1) - this.getHeightAt(x - 1, y - 1)) / ROOT_EIGHT), Math.max(Math.abs(this.getHeightAt(x, y + 1) - this.getHeightAt(x, y - 1)) / 2.0f, Math.abs(this.getHeightAt(x - 1, y + 1) - this.getHeightAt(x + 1, y - 1)) / ROOT_EIGHT));
    }

    public Terrain getTerrainAt(int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getTerrain(x & 0x7F, y & 0x7F);
        }
        return null;
    }

    public void setTerrainAt(int x, int y, Terrain terrain) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setTerrain(x & 0x7F, y & 0x7F, terrain);
        }
    }

    public Set<Terrain> getAllTerrains() {
        return this.tiles != null ? this.tiles.values().parallelStream().flatMap(tile -> tile.getAllTerrains().parallelStream()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public void setTerrainAt(Point coords, Terrain terrain) {
        this.setTerrainAt(coords.x, coords.y, terrain);
    }

    public void applyTheme(int x, int y) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            this.tileFactory.applyTheme(tile, x & 0x7F, y & 0x7F);
        }
    }

    public int getWaterLevelAt(int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getWaterLevel(x & 0x7F, y & 0x7F);
        }
        return Integer.MIN_VALUE;
    }

    public int getWaterLevelAt(Point coords) {
        return this.getWaterLevelAt(coords.x, coords.y);
    }

    public void setWaterLevelAt(int x, int y, int waterLevel) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setWaterLevel(x & 0x7F, y & 0x7F, waterLevel);
        }
    }

    public int getLayerValueAt(Layer layer, int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getLayerValue(layer, x & 0x7F, y & 0x7F);
        }
        return layer.getDefaultValue();
    }

    public int getLayerValueAt(Layer layer, Point coords) {
        return this.getLayerValueAt(layer, coords.x, coords.y);
    }

    public void setLayerValueAt(Layer layer, int x, int y, int value) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setLayerValue(layer, x & 0x7F, y & 0x7F, value);
        }
    }

    public boolean getBitLayerValueAt(Layer layer, int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getBitLayerValue(layer, x & 0x7F, y & 0x7F);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBitLayerCount(Layer layer, int x, int y, int r) {
        this.readLock.lock();
        try {
            int tileX = x >> 7;
            int tileY = y >> 7;
            if (x - r >> 7 == tileX && x + r >> 7 == tileX && y - r >> 7 == tileY && y + r >> 7 == tileY) {
                Tile tile = this.getTile(tileX, tileY);
                if (tile != null) {
                    int n = tile.getBitLayerCount(layer, x & 0x7F, y & 0x7F, r);
                    return n;
                }
                int n = 0;
                return n;
            }
            int count = 0;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    if (!this.getBitLayerValueAt(layer, x + dx, y + dy)) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<Layer, Integer> getLayersAt(int x, int y) {
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return tile.getLayersAt(x & 0x7F, y & 0x7F);
        }
        return null;
    }

    public int getFloodedCount(int x, int y, int r, boolean lava) {
        return this.doGetFloodedCount(x, y, r, lava);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int doGetFloodedCount(int x, int y, int r, boolean lava) {
        this.readLock.lock();
        try {
            int tileX = x >> 7;
            int tileY = y >> 7;
            if (x - r >> 7 == tileX && x + r >> 7 == tileX && y - r >> 7 == tileY && y + r >> 7 == tileY) {
                Tile tile = this.getTile(tileX, tileY);
                if (tile != null) {
                    int n = tile.getFloodedCount(x & 0x7F, y & 0x7F, r, lava);
                    return n;
                }
                int n = 0;
                return n;
            }
            int count = 0;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    int xx = x + dx;
                    int yy = y + dy;
                    if (this.getWaterLevelAt(xx, yy) <= this.getIntHeightAt(xx, yy) || !(lava ? this.getBitLayerValueAt(FloodWithLava.INSTANCE, xx, yy) : !this.getBitLayerValueAt(FloodWithLava.INSTANCE, xx, yy))) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public float getDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        return this.doGetDistanceToEdge(layer, x, y, maxDistance);
    }

    public HeightMap getDistancesToEdge(Layer layer, final float maxDistance) {
        float[][] distances = GeometryUtil.getDistancesToCentre(maxDistance);
        int[] coords = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        HashSet tilesToProcess = new HashSet();
        HashSet<Point> tileCoordsToProcess = new HashSet<Point>();
        this.visitTiles().forFilter(DefaultFilter.buildForDimension(this).onlyOn(layer).build()).andDo(tile -> {
            int tileX = tile.getX();
            int tileY = tile.getY();
            if (tileX < coords[0]) {
                coords[0] = tileX;
            }
            if (tileX > coords[1]) {
                coords[1] = tileX;
            }
            if (tileY < coords[2]) {
                coords[2] = tileY;
            }
            if (tileY > coords[3]) {
                coords[3] = tileY;
            }
            tilesToProcess.add(tile);
            tileCoordsToProcess.add(new Point(tileX, tileY));
        });
        if (tilesToProcess.isEmpty()) {
            return new ConstantHeightMap(0.0);
        }
        int[] deltas = new int[]{0, -1, 1, 0, 0, 1, -1, 0};
        for (Tile tile2 : tilesToProcess) {
            for (int i = 0; i < 4; ++i) {
                Point adjacentCoords = new Point(tile2.getX() + deltas[i * 2], tile2.getY() + deltas[i * 2 + 1]);
                if (tileCoordsToProcess.contains(adjacentCoords)) continue;
                tileCoordsToProcess.add(adjacentCoords);
            }
        }
        int tileX1 = coords[0];
        int tileX2 = coords[1];
        int tileY1 = coords[2];
        int tileY2 = coords[3];
        Tile[][] tileCache = new Tile[tileX2 - tileX1 + 1][tileY2 - tileY1 + 1];
        final float[][][][] distanceCache = new float[tileX2 - tileX1 + 1][tileY2 - tileY1 + 1][][];
        final int tileXOffset = tileX1;
        final int tileYOffset = tileY1;
        Iterator iterator = tilesToProcess.iterator();
        while (iterator.hasNext()) {
            float[][] cacheForTile;
            Tile tile3;
            tileCache[tile3.getX() - tileXOffset][tile3.getY() - tileYOffset] = tile3 = (Tile)iterator.next();
            for (float[] column : cacheForTile = new float[128][128]) {
                Arrays.fill(column, maxDistance);
            }
            distanceCache[tile3.getX() - tileXOffset][tile3.getY() - tileYOffset] = cacheForTile;
        }
        int r = (int)Math.ceil(maxDistance);
        int d = 2 * r + 1;
        for (Point tileCoords : tileCoordsToProcess) {
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int worldX = tileCoords.x << 7 | x;
                    int worldY = tileCoords.y << 7 | y;
                    if (this.getBitLayerValueAt(tileCache, tileXOffset, tileYOffset, layer, worldX, worldY) || !this.getBitLayerValueAt(tileCache, tileXOffset, tileYOffset, layer, worldX - 1, worldY) && !this.getBitLayerValueAt(tileCache, tileXOffset, tileYOffset, layer, worldX, worldY - 1) && !this.getBitLayerValueAt(tileCache, tileXOffset, tileYOffset, layer, worldX + 1, worldY) && !this.getBitLayerValueAt(tileCache, tileXOffset, tileYOffset, layer, worldX, worldY + 1)) continue;
                    for (int dx = -r; dx <= r; ++dx) {
                        for (int dy = -r; dy <= r; ++dy) {
                            this.setCachedValueIfLower(distanceCache, tileXOffset, tileYOffset, worldX + dx, worldY + dy, distances[dx + r][dy + r]);
                        }
                    }
                }
            }
        }
        return new AbstractHeightMap(){

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public double[] getRange() {
                return new double[]{0.0, maxDistance};
            }

            @Override
            public double getHeight(int x, int y) {
                int tileX = (x >> 7) - tileXOffset;
                int tileY = (y >> 7) - tileYOffset;
                if (tileX < 0 || tileX >= distanceCache.length || tileY < 0 || tileY >= distanceCache[0].length || distanceCache[tileX][tileY] == null) {
                    return 0.0;
                }
                return distanceCache[tileX][tileY][x & 0x7F][y & 0x7F];
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                throw new NotSerializableException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final float doGetDistanceToEdge(Layer layer, int x, int y, float maxDistance) {
        this.readLock.lock();
        try {
            int r = (int)Math.ceil(maxDistance);
            int tileX1 = x - r >> 7;
            int tileX2 = x + r >> 7;
            int tileY1 = y - r >> 7;
            int tileY2 = y + r >> 7;
            if (tileX1 == tileX2 && tileY1 == tileY2) {
                Tile tile = this.getTile(tileX1, tileY1);
                if (tile != null) {
                    float f = tile.getDistanceToEdge(layer, x & 0x7F, y & 0x7F, maxDistance);
                    return f;
                }
                float f = 0.0f;
                return f;
            }
            if (!this.getBitLayerValueAt(layer, x, y)) {
                float tile = 0.0f;
                return tile;
            }
            Tile[][] tiles = new Tile[tileX2 - tileX1 + 1][tileY2 - tileY1 + 1];
            for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
                for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                    tiles[tileX - tileX1][tileY - tileY1] = this.getTile(tileX, tileY);
                }
            }
            float distance = maxDistance;
            block9: for (int i = 1; i <= r; ++i) {
                if (!(this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x - i, y) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x + i, y) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x, y - i) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x, y + i) || !((float)i < distance))) {
                    float f = i;
                    return f;
                }
                for (int d = 1; d <= i; ++d) {
                    if (this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x - i, y - d) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x + d, y - i) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x + i, y + d) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x - d, y + i) && (d >= i || this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x - i, y + d) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x - d, y - i) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x + i, y - d) && this.getBitLayerValueAt(tiles, tileX1, tileY1, layer, x + d, y + i))) continue;
                    float tDistance = MathUtils.getDistance((int)i, (int)d);
                    if (!(tDistance < distance)) continue block9;
                    distance = tDistance;
                    continue block9;
                }
            }
            float f = distance;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setBitLayerValueAt(Layer layer, int x, int y, boolean value) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.setBitLayerValue(layer, x & 0x7F, y & 0x7F, value);
        }
    }

    public void clearLayerData(Layer layer) {
        this.tiles.values().stream().filter(tile -> tile.hasLayer(layer)).forEach(tile -> {
            if (this.eventsInhibited && !tile.isEventsInhibited()) {
                tile.inhibitEvents();
                this.dirtyTiles.add((Tile)tile);
            }
            tile.clearLayerData(layer);
        });
    }

    public void clearLayerData(int x, int y, Set<Layer> excludedLayers) {
        Tile tile = this.getTileForEditing(x >> 7, y >> 7);
        if (tile != null) {
            tile.clearLayerData(x & 0x7F, y & 0x7F, excludedLayers);
        }
    }

    public void setEventsInhibited(boolean eventsInhibited) {
        if (eventsInhibited != this.eventsInhibited) {
            this.eventsInhibited = eventsInhibited;
            if (!eventsInhibited) {
                this.fireTilesAdded(this.addedTiles);
                this.addedTiles.clear();
                this.fireTilesRemoved(this.removedTiles);
                this.removedTiles.clear();
                this.dirtyTiles.forEach(Tile::releaseEvents);
                this.dirtyTiles.clear();
            }
        } else {
            throw new IllegalStateException("eventsInhibited already " + eventsInhibited);
        }
    }

    public boolean isEventsInhibited() {
        return this.eventsInhibited;
    }

    public Map<Layer, ExporterSettings> getAllLayerSettings() {
        return Collections.unmodifiableMap(this.layerSettings);
    }

    public ExporterSettings getLayerSettings(Layer layer) {
        return this.layerSettings.get(layer);
    }

    public void setLayerSettings(Layer layer, ExporterSettings settings) {
        if (settings != null ? !this.layerSettings.containsKey(layer) || !settings.equals(this.layerSettings.get(layer)) : this.layerSettings.containsKey(layer)) {
            if (settings != null) {
                this.layerSettings.put(layer, settings);
            } else {
                this.layerSettings.remove(layer);
            }
            ++this.changeNo;
        }
    }

    public long getMinecraftSeed() {
        return this.minecraftSeed;
    }

    public void setMinecraftSeed(long minecraftSeed) {
        if (minecraftSeed != this.minecraftSeed) {
            long oldMinecraftSeed = this.minecraftSeed;
            this.minecraftSeed = minecraftSeed;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("minecraftSeed", oldMinecraftSeed, minecraftSeed);
        }
    }

    public List<Overlay> getOverlays() {
        return Collections.unmodifiableList(this.overlays);
    }

    public int addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
        ++this.changeNo;
        int rowIndex = this.overlays.size() - 1;
        for (Listener listener : this.listeners) {
            listener.overlayAdded(this, rowIndex, overlay);
        }
        return rowIndex;
    }

    public void removeOverlay(int index) {
        Overlay overlay = this.overlays.remove(index);
        ++this.changeNo;
        for (Listener listener : this.listeners) {
            listener.overlayRemoved(this, index, overlay);
        }
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        if (gridEnabled != this.gridEnabled) {
            this.gridEnabled = gridEnabled;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("gridEnabled", !gridEnabled, gridEnabled);
        }
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        if (gridSize != this.gridSize) {
            int oldGridSize = this.gridSize;
            this.gridSize = gridSize;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("gridSize", oldGridSize, gridSize);
        }
    }

    public boolean isOverlaysEnabled() {
        return this.overlayEnabled;
    }

    public void setOverlaysEnabled(boolean overlaysEnabled) {
        if (overlaysEnabled != this.overlayEnabled) {
            this.overlayEnabled = overlaysEnabled;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("overlaysEnabled", !overlaysEnabled, overlaysEnabled);
        }
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        if (minHeight != this.minHeight) {
            int oldMinHeight = this.minHeight;
            this.minHeight = minHeight;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("minHeight", oldMinHeight, minHeight);
        }
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        if (maxHeight != this.maxHeight) {
            int oldMaxHeight = this.maxHeight;
            this.maxHeight = maxHeight;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("maxHeight", oldMaxHeight, maxHeight);
        }
    }

    public int getContourSeparation() {
        return this.contourSeparation;
    }

    public void setContourSeparation(int contourSeparation) {
        if (contourSeparation != this.contourSeparation) {
            int oldContourSeparation = this.contourSeparation;
            this.contourSeparation = contourSeparation;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("contourSeparation", oldContourSeparation, contourSeparation);
        }
    }

    public boolean isContoursEnabled() {
        return this.contoursEnabled;
    }

    public void setContoursEnabled(boolean contoursEnabled) {
        if (contoursEnabled != this.contoursEnabled) {
            this.contoursEnabled = contoursEnabled;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("contoursEnabled", !contoursEnabled, contoursEnabled);
        }
    }

    public int getTopLayerMinDepth() {
        return this.topLayerMinDepth;
    }

    public void setTopLayerMinDepth(int topLayerMinDepth) {
        if (topLayerMinDepth != this.topLayerMinDepth) {
            int oldTopLayerMinDepth = this.topLayerMinDepth;
            this.topLayerMinDepth = topLayerMinDepth;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("topLayerMinDepth", oldTopLayerMinDepth, topLayerMinDepth);
        }
    }

    public int getTopLayerVariation() {
        return this.topLayerVariation;
    }

    public void setTopLayerVariation(int topLayerVariation) {
        if (topLayerVariation != this.topLayerVariation) {
            int oldTopLayerVariation = this.topLayerVariation;
            this.topLayerVariation = topLayerVariation;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("topLayerVariation", oldTopLayerVariation, topLayerVariation);
        }
    }

    public boolean isBottomless() {
        return this.bottomless;
    }

    public void setBottomless(boolean bottomless) {
        if (bottomless != this.bottomless) {
            this.bottomless = bottomless;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("bottomless", !bottomless, bottomless);
        }
    }

    public Point getLastViewPosition() {
        return this.lastViewPosition;
    }

    public void setLastViewPosition(Point lastViewPosition) {
        if (lastViewPosition == null) {
            throw new NullPointerException();
        }
        if (!lastViewPosition.equals(this.lastViewPosition)) {
            Point oldLastViewPosition = this.lastViewPosition;
            this.lastViewPosition = lastViewPosition;
            this.propertyChangeSupport.firePropertyChange("lastViewPosition", oldLastViewPosition, lastViewPosition);
        }
    }

    public List<CustomBiome> getCustomBiomes() {
        return CollectionUtils.copyOf(this.customBiomes);
    }

    public void setCustomBiomes(List<CustomBiome> customBiomes) {
        if (!Objects.equals(customBiomes, this.customBiomes)) {
            List<CustomBiome> oldCustomBiomes = this.customBiomes;
            this.customBiomes = CollectionUtils.copyOf(customBiomes);
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("customBiomes", oldCustomBiomes, customBiomes);
        }
    }

    public boolean isCoverSteepTerrain() {
        return this.coverSteepTerrain;
    }

    public void setCoverSteepTerrain(boolean coverSteepTerrain) {
        if (coverSteepTerrain != this.coverSteepTerrain) {
            this.coverSteepTerrain = coverSteepTerrain;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("coverSteepTerrain", !coverSteepTerrain, coverSteepTerrain);
        }
    }

    public boolean isFixOverlayCoords() {
        return this.fixOverlayCoords;
    }

    public void setFixOverlayCoords(boolean fixOverlayCoords) {
        this.fixOverlayCoords = fixOverlayCoords;
    }

    public Garden getGarden() {
        return this.garden;
    }

    public List<CustomLayer> getCustomLayers() {
        return this.getCustomLayers(false);
    }

    public List<CustomLayer> getCustomLayers(boolean applyCombinedLayers) {
        ArrayList copyOfCustomLayers = CollectionUtils.copyOf(this.customLayers);
        if (applyCombinedLayers) {
            this.applyLayerContainers(copyOfCustomLayers);
            copyOfCustomLayers.removeIf(layer -> !(layer instanceof CustomLayer));
        }
        return copyOfCustomLayers;
    }

    public void setCustomLayers(List<CustomLayer> customLayers) {
        this.customLayers = CollectionUtils.copyOf(customLayers);
    }

    public Set<Layer> getAllLayers(boolean applyCombinedLayers) {
        HashSet<Layer> allLayers = new HashSet<Layer>();
        for (Tile tile : this.tiles.values()) {
            allLayers.addAll(tile.getLayers());
        }
        if (applyCombinedLayers) {
            this.applyLayerContainers(allLayers);
        }
        return allLayers;
    }

    private void applyLayerContainers(Collection layers) {
        HashSet<LayerContainer> containersProcessed = new HashSet<LayerContainer>();
        HashSet<Layer> additionalLayers = new HashSet<Layer>();
        do {
            additionalLayers.clear();
            Iterator i = layers.iterator();
            while (i.hasNext()) {
                Layer layer2 = (Layer)i.next();
                if (!(layer2 instanceof LayerContainer)) continue;
                i.remove();
                if (containersProcessed.contains(layer2)) continue;
                additionalLayers.addAll(((LayerContainer)((Object)layer2)).getLayers());
                containersProcessed.add((LayerContainer)((Object)layer2));
            }
            additionalLayers.forEach(layer -> {
                if (!layers.contains(layer)) {
                    layers.add(layer);
                }
            });
        } while (!additionalLayers.isEmpty());
    }

    public Set<Layer> getMinimumLayers() {
        Set<Layer> layers = this.layerSettings.values().stream().filter(ExporterSettings::isApplyEverywhere).map(ExporterSettings::getLayer).collect(Collectors.toSet());
        return layers;
    }

    public int getCeilingHeight() {
        return this.ceilingHeight;
    }

    public void setCeilingHeight(int ceilingHeight) {
        if (ceilingHeight != this.ceilingHeight) {
            int oldCeilingHeight = this.ceilingHeight;
            this.ceilingHeight = ceilingHeight;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("ceilingHeight", oldCeilingHeight, ceilingHeight);
        }
    }

    public LayerAnchor getSubsurfaceLayerAnchor() {
        return this.subsurfaceLayerAnchor;
    }

    public void setSubsurfaceLayerAnchor(LayerAnchor subsurfaceLayerAnchor) {
        if (subsurfaceLayerAnchor != this.subsurfaceLayerAnchor) {
            LayerAnchor oldSubsurfaceLayerAnchor = this.subsurfaceLayerAnchor;
            this.subsurfaceLayerAnchor = subsurfaceLayerAnchor;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("subsurfaceLayerAnchor", (Object)oldSubsurfaceLayerAnchor, (Object)subsurfaceLayerAnchor);
        }
    }

    public LayerAnchor getTopLayerAnchor() {
        return this.topLayerAnchor;
    }

    public void setTopLayerAnchor(LayerAnchor topLayerAnchor) {
        if (topLayerAnchor != this.topLayerAnchor) {
            LayerAnchor oldTopLayerAnchor = this.topLayerAnchor;
            this.topLayerAnchor = topLayerAnchor;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("topLayerAnchor", (Object)oldTopLayerAnchor, (Object)topLayerAnchor);
        }
    }

    public ExportSettings getExportSettings() {
        return this.exportSettings;
    }

    public void setExportSettings(ExportSettings exportSettings) {
        if (!Objects.equals(exportSettings, this.exportSettings)) {
            ExportSettings oldExportSettings = this.exportSettings;
            this.exportSettings = exportSettings;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("exportSettings", oldExportSettings, exportSettings);
        }
    }

    public MapGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(MapGenerator generator) {
        if (this.propertyChangeSupport != null) {
            if (!Objects.equals(this.generator, generator)) {
                MapGenerator oldGenerator = this.generator;
                this.generator = generator;
                ++this.changeNo;
                this.propertyChangeSupport.firePropertyChange("generator", oldGenerator, generator);
            }
        } else {
            this.generator = generator;
        }
    }

    public WallType getWallType() {
        return this.wallType;
    }

    public void setWallType(WallType wallType) {
        if (wallType != this.wallType) {
            WallType oldWallType = this.wallType;
            this.wallType = wallType;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("wallType", (Object)oldWallType, (Object)wallType);
        }
    }

    public WallType getRoofType() {
        return this.roofType;
    }

    public void setRoofType(WallType roofType) {
        if (roofType != this.roofType) {
            WallType oldRoofType = this.roofType;
            this.roofType = roofType;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("roofType", (Object)oldRoofType, (Object)roofType);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        if (scale != this.scale) {
            float oldScale = this.scale;
            this.scale = scale;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("scale", Float.valueOf(oldScale), Float.valueOf(scale));
        }
    }

    public Set<String> getHiddenPalettes() {
        return CollectionUtils.copyOf(this.hiddenPalettes);
    }

    public void setHiddenPalettes(Set<String> hiddenPalettes) {
        if (!Objects.equals(hiddenPalettes, this.hiddenPalettes)) {
            Set<String> oldHiddenPalettes = this.hiddenPalettes;
            this.hiddenPalettes = CollectionUtils.copyOf(hiddenPalettes);
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("hiddenPalettes", oldHiddenPalettes, hiddenPalettes);
        }
    }

    public String getSoloedPalette() {
        return this.soloedPalette;
    }

    public void setSoloedPalette(String soloedPalette) {
        if (!Objects.equals(soloedPalette, this.soloedPalette)) {
            String oldSoloedPalette = this.soloedPalette;
            this.soloedPalette = soloedPalette;
            ++this.changeNo;
            this.propertyChangeSupport.firePropertyChange("soloedPalette", oldSoloedPalette, soloedPalette);
        }
    }

    public void applyTheme(Point coords) {
        this.applyTheme(coords.x, coords.y);
    }

    public boolean isUndoAvailable() {
        return this.undoManager != null;
    }

    public void registerUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
        for (Tile tile : this.tiles.values()) {
            tile.register(undoManager);
        }
    }

    public boolean undoChanges() {
        if (this.rememberedChangeNo != -1L) {
            this.changeNo = this.rememberedChangeNo;
            this.rememberedChangeNo = -1L;
        }
        if (this.undoManager != null && this.undoManager.isDirty()) {
            return this.undoManager.undo();
        }
        return false;
    }

    public void clearUndo() {
        this.rememberedChangeNo = -1L;
        if (this.undoManager != null) {
            this.undoManager.clear();
        }
    }

    public void armSavePoint() {
        if (this.undoManager != null) {
            this.undoManager.armSavePoint();
        }
    }

    public void rememberChanges() {
        this.rememberedChangeNo = this.changeNo;
        if (this.undoManager != null) {
            if (this.undoManager.isDirty()) {
                this.undoManager.savePoint();
            } else {
                this.undoManager.armSavePoint();
            }
        }
    }

    public void clearRedo() {
        if (this.undoManager != null) {
            this.undoManager.clearRedo();
        }
    }

    public void unregisterUndoManager() {
        for (Tile tile : this.tiles.values()) {
            tile.unregister();
        }
        this.undoManager = null;
    }

    public final int getAutoBiome(int x, int y) {
        return this.getAutoBiome(x, y, -1);
    }

    public final int getAutoBiome(int x, int y, int defaultBiome) {
        switch (this.anchor.dim) {
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
        }
        Tile tile = this.getTile(x >> 7, y >> 7);
        if (tile != null) {
            return this.getAutoBiome(tile, x & 0x7F, y & 0x7F, defaultBiome);
        }
        return defaultBiome;
    }

    public final int getAutoBiome(Tile tile, int x, int y) {
        return this.getAutoBiome(tile, x, y, -1);
    }

    public final int getAutoBiome(Tile tile, int x, int y, int defaultBiome) {
        int biome;
        switch (this.anchor.dim) {
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
        }
        if (tile.getBitLayerValue(Frost.INSTANCE, x, y)) {
            int waterDepth;
            biome = tile.getBitLayerValue(River.INSTANCE, x, y) ? 11 : (tile.getLayerValue(DeciduousForest.INSTANCE, x, y) > 0 || tile.getLayerValue(PineForest.INSTANCE, x, y) > 0 || tile.getLayerValue(SwampLand.INSTANCE, x, y) > 0 || tile.getLayerValue(Jungle.INSTANCE, x, y) > 0 ? 30 : (tile.getTerrain(x, y) == Terrain.WATER ? 11 : ((waterDepth = tile.getWaterLevel(x, y) - tile.getIntHeight(x, y)) > 0 && !tile.getBitLayerValue(FloodWithLava.INSTANCE, x, y) ? (waterDepth <= 5 ? 11 : 10) : 12)));
        } else if (tile.getBitLayerValue(River.INSTANCE, x, y)) {
            biome = 7;
        } else if (tile.getLayerValue(SwampLand.INSTANCE, x, y) > 0) {
            biome = 6;
        } else if (tile.getLayerValue(Jungle.INSTANCE, x, y) > 0) {
            biome = 21;
        } else {
            int waterDepth = tile.getWaterLevel(x, y) - tile.getIntHeight(x, y);
            if (waterDepth > 0 && !tile.getBitLayerValue(FloodWithLava.INSTANCE, x, y)) {
                biome = waterDepth <= 5 ? 7 : (waterDepth <= 20 ? 0 : 24);
            } else {
                Terrain terrain = tile.getTerrain(x, y);
                if (terrain.isConfigured() && terrain.getDefaultBiome() != -1) {
                    defaultBiome = terrain.getDefaultBiome();
                }
                biome = (tile.getLayerValue(DeciduousForest.INSTANCE, x, y) > 0 || tile.getLayerValue(PineForest.INSTANCE, x, y) > 0) && defaultBiome != 2 && defaultBiome != 17 && defaultBiome != 130 && defaultBiome != 37 && defaultBiome != 165 && defaultBiome != 39 && defaultBiome != 38 && defaultBiome != 166 && defaultBiome != 167 ? 4 : defaultBiome;
            }
        }
        return biome;
    }

    public Dimension getSnapshot() {
        if (this.undoManager == null) {
            throw new IllegalStateException("No undo manager installed");
        }
        return new DimensionSnapshot(this, this.undoManager.getSnapshot());
    }

    public int getTopLayerDepth(int x, int y, int z) {
        return this.topLayerMinDepth + Math.round((this.topLayerDepthNoise.getPerlinNoise((double)((float)x / 16.411f), (double)((float)y / 16.411f), (double)((float)z / 16.411f)) + 0.5f) * (float)this.topLayerVariation);
    }

    void ensureAllReadable() {
        this.tiles.values().forEach(Tile::ensureAllReadable);
    }

    public void addDimensionListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeDimensionListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(CoordinateTransform transform, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        if (progressReceiver != null) {
            progressReceiver.setMessage("transforming " + this.getName() + "...");
        }
        this.eventsInhibited = true;
        try {
            HashSet<Tile> removedTiles;
            this.addedTiles.clear();
            this.removedTiles.clear();
            this.dirtyTiles.clear();
            ++this.changeNo;
            HashMap<Point, Tile> oldTiles = new HashMap<Point, Tile>(this.tiles);
            this.writeLock.lock();
            try {
                this.tiles.clear();
                removedTiles = new HashSet<Tile>(oldTiles.values());
                for (Tile removedTile : removedTiles) {
                    removedTile.removeListener(this);
                    removedTile.unregister();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            this.clearUndo();
            for (Listener listener : this.listeners) {
                listener.tilesRemoved(this, removedTiles);
            }
            this.lowestX = Integer.MAX_VALUE;
            this.highestX = Integer.MIN_VALUE;
            this.lowestY = Integer.MAX_VALUE;
            this.highestY = Integer.MIN_VALUE;
            if (transform.isScaling()) {
                ScalingHelper scalingHelper = new ScalingHelper(oldTiles, this.tileFactory, transform.getScale());
                Set<Tile> scaledTiles = scalingHelper.getAllScaledTiles(progressReceiver);
                for (Tile tile : scaledTiles) {
                    if (tile.containsOneOf(NotPresent.INSTANCE)) {
                        boolean presentChunkFound = false;
                        block11: for (int x = 0; x < 128; x += 16) {
                            for (int y = 0; y < 128; y += 16) {
                                if (tile.getBitLayerValue(NotPresent.INSTANCE, x, y)) continue;
                                presentChunkFound = true;
                                break block11;
                            }
                        }
                        if (!presentChunkFound) continue;
                        this.addTile(tile);
                        continue;
                    }
                    this.addTile(tile);
                }
            } else {
                int tileCount = removedTiles.size();
                int tileNo = 0;
                Iterator i = removedTiles.iterator();
                while (i.hasNext()) {
                    Tile tile;
                    tile = (Tile)i.next();
                    this.addTile(tile.transform(transform));
                    i.remove();
                    ++tileNo;
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)tileNo / (float)tileCount);
                }
            }
            this.tileFactory.transform(transform);
            for (Overlay overlay : this.overlays) {
                if (overlay.getFile().canRead()) {
                    try {
                        java.awt.Dimension overlaySize = this.getImageSize(overlay.getFile());
                        if (overlaySize != null) {
                            float overlayScale = overlay.getScale();
                            Rectangle overlayCoords = transform.transform(new Rectangle(overlay.getOffsetX(), overlay.getOffsetY(), Math.round((float)overlaySize.width * overlayScale), Math.round((float)overlaySize.height * overlayScale)));
                            overlay.setOffsetX(overlayCoords.x);
                            overlay.setOffsetY(overlayCoords.y);
                            overlay.setScale(transform.transformScalar(overlayScale));
                            continue;
                        }
                        logger.error("Size of " + overlay.getFile() + " could not be determined; overlay will not be adjusted");
                        overlay.setEnabled(false);
                    }
                    catch (IOException e) {
                        logger.error("I/O error while trying to determine size of " + overlay.getFile() + "; overlay will not be adjusted", (Throwable)e);
                        overlay.setEnabled(false);
                    }
                    continue;
                }
                logger.error("Overlay " + overlay.getFile() + " could not be read; overlay will not be adjusted");
                overlay.setEnabled(false);
            }
        }
        finally {
            this.eventsInhibited = false;
            this.fireTilesAdded(this.addedTiles);
        }
    }

    public boolean containsOneOf(Layer ... layers) {
        for (Tile tile : this.tiles.values()) {
            if (!tile.containsOneOf(layers)) continue;
            return true;
        }
        return false;
    }

    public TileVisitationBuilder visitTilesForEditing() {
        return new TileVisitationBuilder(false);
    }

    public TileVisitationBuilder visitTiles() {
        return new TileVisitationBuilder(true);
    }

    public <T> T getAttribute(AttributeKey<T> key) {
        if (this.attributes != null) {
            return (T)(this.attributes.containsKey(key.key) ? this.attributes.get(key.key) : key.defaultValue);
        }
        return (T)key.defaultValue;
    }

    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null ? value.equals(key.defaultValue) : key.defaultValue == null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key.key, value);
        }
        ++this.changeNo;
    }

    public int getMostPrevalentBiome(int x, int y, int defaultBiome) {
        Tile tile = this.getTile(x >> 5, y >> 5);
        if (tile == null) {
            return defaultBiome;
        }
        int xx1 = x << 2 & 0x7F;
        int yy1 = y << 2 & 0x7F;
        int xx2 = xx1 + 4;
        int yy2 = yy1 + 4;
        int[] histogram = this.biomeHistogramRef.get();
        Arrays.fill(histogram, 0);
        for (int xx = xx1; xx < xx2; ++xx) {
            for (int yy = yy1; yy < yy2; ++yy) {
                int biome = tile.getLayerValue(Biome.INSTANCE, xx, yy);
                if (biome == 255 && ((biome = this.getAutoBiome(tile, xx, yy)) < 0 || biome > 254)) {
                    biome = defaultBiome;
                }
                int n = biome;
                histogram[n] = histogram[n] + 1;
                if (histogram[biome] <= 7) continue;
                return biome;
            }
        }
        int mostPrevalentBiome = -1;
        int mostPrevalentBiomePrevalence = -1;
        for (int i = 0; i < 255; ++i) {
            if (histogram[i] <= mostPrevalentBiomePrevalence) continue;
            mostPrevalentBiome = i;
            mostPrevalentBiomePrevalence = histogram[i];
        }
        return mostPrevalentBiome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ZipOutputStream out) throws IOException {
        this.readLock.lock();
        try {
            this.setEventsInhibited(true);
            try {
                String path = this.anchor + "/";
                out.putNextEntry(new ZipEntry(path + "dim-data.bin"));
                try {
                    Map<Point, Tile> savedTiles = this.tiles;
                    World2 savedWorld = this.world;
                    try {
                        this.tiles = null;
                        this.world = null;
                        ObjectOutputStream dataout = new ObjectOutputStream(out);
                        dataout.writeObject(this);
                        dataout.flush();
                    }
                    finally {
                        this.tiles = savedTiles;
                        this.world = savedWorld;
                    }
                }
                finally {
                    out.closeEntry();
                }
                int regionX1 = this.lowestX >> 2;
                int regionX2 = this.highestX >> 2;
                int regionY1 = this.lowestY >> 2;
                int regionY2 = this.highestY >> 2;
                for (int regionX = regionX1; regionX <= regionX2; ++regionX) {
                    for (int regionY = regionY1; regionY <= regionY2; ++regionY) {
                        ArrayList<Tile> tileList = new ArrayList<Tile>();
                        for (int tileX = 0; tileX < 4; ++tileX) {
                            for (int tileY = 0; tileY < 4; ++tileY) {
                                Tile tile = this.tiles.get(new Point(regionX << 2 | tileX, regionY << 2 | tileY));
                                if (tile == null) continue;
                                tile.prepareForSaving();
                                tileList.add(tile);
                            }
                        }
                        out.putNextEntry(new ZipEntry(path + "region-data-" + regionX + "," + regionY + ".bin"));
                        try {
                            ObjectOutputStream dataout = new ObjectOutputStream(out);
                            dataout.writeObject(tileList);
                            dataout.flush();
                            continue;
                        }
                        finally {
                            out.closeEntry();
                        }
                    }
                }
            }
            finally {
                this.setEventsInhibited(false);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void heightMapChanged(Tile tile) {
        ++this.changeNo;
    }

    @Override
    public void terrainChanged(Tile tile) {
        ++this.changeNo;
    }

    @Override
    public void waterLevelChanged(Tile tile) {
        ++this.changeNo;
    }

    @Override
    public void seedsChanged(Tile tile) {
        ++this.changeNo;
    }

    @Override
    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
        ++this.changeNo;
    }

    @Override
    public void allBitLayerDataChanged(Tile tile) {
        ++this.changeNo;
    }

    @Override
    public void allNonBitlayerDataChanged(Tile tile) {
        ++this.changeNo;
    }

    private boolean getBitLayerValueAt(Tile[][] tileCache, int tileXOffset, int tileYOffset, Layer layer, int x, int y) {
        int tileX = (x >> 7) - tileXOffset;
        int tileY = (y >> 7) - tileYOffset;
        if (tileX < 0 || tileX >= tileCache.length || tileY < 0 || tileY >= tileCache[0].length || tileCache[tileX][tileY] == null) {
            return false;
        }
        return tileCache[tileX][tileY].getBitLayerValue(layer, x & 0x7F, y & 0x7F);
    }

    private void setCachedValueIfLower(float[][][][] cache, int tileXOffset, int tileYOffset, int x, int y, float value) {
        int tileX = (x >> 7) - tileXOffset;
        int tileY = (y >> 7) - tileYOffset;
        if (tileX < 0 || tileX >= cache.length || tileY < 0 || tileY >= cache[0].length || cache[tileX][tileY] == null) {
            return;
        }
        int xInTile = x & 0x7F;
        int yInTile = y & 0x7F;
        if (value < cache[tileX][tileY][xInTile][yInTile]) {
            cache[tileX][tileY][xInTile][yInTile] = value;
        }
    }

    private void fireTileAdded(Tile tile) {
        if (this.eventsInhibited) {
            this.addedTiles.add(tile);
        } else {
            Set<Tile> tiles = Collections.singleton(tile);
            for (Listener listener : this.listeners) {
                listener.tilesAdded(this, tiles);
            }
        }
    }

    private void fireTileRemoved(Tile tile) {
        if (this.eventsInhibited) {
            this.removedTiles.add(tile);
        } else {
            Set<Tile> tiles = Collections.singleton(tile);
            for (Listener listener : this.listeners) {
                listener.tilesRemoved(this, tiles);
            }
        }
    }

    private void fireTilesAdded(Set<Tile> tiles) {
        if (this.eventsInhibited) {
            this.addedTiles.addAll(tiles);
        } else {
            for (Listener listener : this.listeners) {
                listener.tilesAdded(this, tiles);
            }
        }
    }

    private void fireTilesRemoved(Set<Tile> tiles) {
        if (this.eventsInhibited) {
            this.removedTiles.addAll(tiles);
        } else {
            for (Listener listener : this.listeners) {
                listener.tilesRemoved(this, tiles);
            }
        }
    }

    /*
     * Loose catch block
     */
    private java.awt.Dimension getImageSize(File image) throws IOException {
        String filename = image.getName();
        int p = filename.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        String suffix = filename.substring(p + 1).toLowerCase();
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                try (FileImageInputStream in = new FileImageInputStream(image);){
                    reader.setInput(in);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    java.awt.Dimension dimension = new java.awt.Dimension(width, height);
                    return dimension;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int tileMaxHeight;
        in.defaultReadObject();
        this.listeners = new ArrayList<Listener>();
        this.dirtyTiles = new HashSet<Tile>();
        this.addedTiles = new HashSet<Tile>();
        this.removedTiles = new HashSet<Tile>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.garden = new WPGarden();
        this.topLayerDepthNoise = new PerlinNoise(this.seed + 180728193L);
        this.rememberedChangeNo = -1L;
        this.biomeHistogramRef = ThreadLocal.withInitial(() -> new int[255]);
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        if (this.tiles == null) {
            this.tiles = new HashMap<Point, Tile>();
        }
        for (Tile tile : this.tiles.values()) {
            tile.addListener(this);
            HashSet<Seed> seeds = tile.getSeeds();
            if (seeds == null) continue;
            for (Seed gardenSeed : seeds) {
                gardenSeed.garden = this.garden;
            }
        }
        if (this.wpVersion < 1) {
            if (this.borderSize == 0) {
                this.borderSize = 2;
            }
            if (this.overlayScale == 0.0f) {
                this.overlayScale = 1.0f;
            }
            if (this.overlayTransparency == 0.0f) {
                this.overlayTransparency = 0.5f;
            }
            if (this.gridSize == 0) {
                this.gridSize = 128;
            }
            if (!this.biomesConverted) {
                this.tiles.values().forEach(Tile::convertBiomeData);
                this.biomesConverted = true;
            }
            if (this.maxHeight == 0) {
                this.maxHeight = 128;
            }
            if (this.subsurfaceMaterial == Terrain.RESOURCES) {
                this.subsurfaceMaterial = Terrain.STONE;
                ResourcesExporter.ResourcesExporterSettings settings = ResourcesExporter.ResourcesExporterSettings.defaultSettings(DefaultPlugin.JAVA_ANVIL, Anchor.NORMAL_DETAIL, this.minHeight, this.maxHeight);
                settings.setChance(Material.GOLD_ORE, 1);
                settings.setChance(Material.IRON_ORE, 5);
                settings.setChance(Material.COAL, 9);
                settings.setChance(Material.LAPIS_LAZULI_ORE, 1);
                settings.setChance(Material.DIAMOND_ORE, 1);
                settings.setChance(Material.REDSTONE_ORE, 6);
                settings.setChance(Material.STATIONARY_WATER, 1);
                settings.setChance(Material.STATIONARY_LAVA, 1);
                settings.setChance(Material.DIRT, 9);
                settings.setChance(Material.GRAVEL, 9);
                settings.setMaxLevel(Material.GOLD_ORE, 32);
                settings.setMaxLevel(Material.IRON_ORE, 48);
                settings.setMaxLevel(Material.COAL, Integer.MAX_VALUE);
                settings.setMaxLevel(Material.LAPIS_LAZULI_ORE, 32);
                settings.setMaxLevel(Material.DIAMOND_ORE, 16);
                settings.setMaxLevel(Material.REDSTONE_ORE, 16);
                settings.setMaxLevel(Material.STATIONARY_WATER, Integer.MAX_VALUE);
                settings.setMaxLevel(Material.STATIONARY_LAVA, 80);
                settings.setMaxLevel(Material.DIRT, Integer.MAX_VALUE);
                settings.setMaxLevel(Material.GRAVEL, Integer.MAX_VALUE);
                this.layerSettings.put(Resources.INSTANCE, settings);
            }
            if (this.contourSeparation == 0) {
                this.contourSeparation = 10;
            }
            if (this.topLayerMinDepth == 0) {
                this.topLayerMinDepth = 3;
                this.topLayerVariation = 4;
            }
            if (this.lastViewPosition == null) {
                this.lastViewPosition = new Point();
            }
            if (this.customLayers == null || this.customLayers.isEmpty()) {
                this.customLayers = new ArrayList<CustomLayer>();
                this.customLayers.addAll(this.getAllLayers(false).stream().filter(layer -> layer instanceof CustomLayer).map(layer -> (CustomLayer)layer).collect(Collectors.toList()));
            }
        }
        if (this.wpVersion < 2 && this.overlay != null) {
            this.fixOverlayCoords = true;
        }
        if (this.wpVersion < 3) {
            this.ceilingHeight = this.maxHeight;
        }
        if (this.wpVersion < 4) {
            this.subsurfaceLayerAnchor = LayerAnchor.BEDROCK;
            this.topLayerAnchor = LayerAnchor.BEDROCK;
        }
        if (this.wpVersion < 5) {
            if (this.darkLevel) {
                this.roofType = WallType.BEDROCK;
                this.darkLevel = false;
            }
            if (this.bedrockWall) {
                this.wallType = WallType.BEDROCK;
                this.bedrockWall = false;
            }
        }
        if (this.wpVersion < 6) {
            switch (this.dim) {
                case -3: {
                    this.anchor = Anchor.END_DETAIL_CEILING;
                    break;
                }
                case -2: {
                    this.anchor = Anchor.NETHER_DETAIL_CEILING;
                    break;
                }
                case -1: {
                    this.anchor = Anchor.NORMAL_DETAIL_CEILING;
                    break;
                }
                case 0: {
                    this.anchor = Anchor.NORMAL_DETAIL;
                    break;
                }
                case 1: {
                    this.anchor = Anchor.NETHER_DETAIL;
                    break;
                }
                case 2: {
                    this.anchor = Anchor.END_DETAIL;
                }
            }
        }
        if (this.wpVersion < 7) {
            this.scale = 1.0f;
            StringBuilder sb = new StringBuilder();
            switch (this.anchor.dim) {
                case 0: {
                    sb.append("Surface");
                    break;
                }
                case 1: {
                    sb.append("Nether");
                    break;
                }
                case 2: {
                    sb.append("End");
                    break;
                }
                default: {
                    sb.append("Dimension " + this.anchor.dim);
                }
            }
            if (this.anchor.invert) {
                sb.append(" Ceiling");
            }
            this.name = sb.toString();
        }
        if (this.wpVersion < 8) {
            this.id = UUID.randomUUID();
        }
        if (this.wpVersion < 9) {
            this.overlays = new ArrayList<Overlay>();
            if (this.overlay != null) {
                Overlay overlay = new Overlay(this.overlay);
                overlay.setOffsetX(this.overlayOffsetX);
                overlay.setOffsetY(this.overlayOffsetY);
                overlay.setScale(this.overlayScale);
                overlay.setTransparency(this.overlayTransparency);
                this.overlays.add(overlay);
                this.overlay = null;
                this.overlayOffsetX = 0;
                this.overlayOffsetY = 0;
                this.overlayScale = 0.0f;
                this.overlayTransparency = 0.0f;
            }
        }
        this.wpVersion = 9;
        this.getAllLayers(false).stream().filter(layer -> layer instanceof CustomLayer && !this.customLayers.contains(layer)).forEach(layer -> {
            if (!(this.customLayers instanceof ArrayList) && !(this.customLayers instanceof LinkedList)) {
                this.customLayers = new ArrayList<CustomLayer>(this.customLayers);
            }
            this.customLayers.add((CustomLayer)layer);
        });
        if (!this.tiles.isEmpty() && (tileMaxHeight = this.tiles.values().iterator().next().getMaxHeight()) != this.maxHeight) {
            logger.warn("Fixing maxHeight of dimension " + this.getName() + " (was " + this.maxHeight + ", should be " + tileMaxHeight + ")");
            this.maxHeight = tileMaxHeight;
        }
    }

    public static enum Role {
        DETAIL,
        MASTER,
        CAVE_FLOOR;

    }

    public static final class Anchor
    implements Serializable,
    Comparable {
        public final int dim;
        public final Role role;
        public final boolean invert;
        public final int id;
        public static final Anchor NORMAL_DETAIL = new Anchor(0, Role.DETAIL, false, 0);
        public static final Anchor NORMAL_MASTER = new Anchor(0, Role.MASTER, false, 0);
        public static final Anchor NETHER_DETAIL = new Anchor(1, Role.DETAIL, false, 0);
        public static final Anchor END_DETAIL = new Anchor(2, Role.DETAIL, false, 0);
        public static final Anchor NORMAL_DETAIL_CEILING = new Anchor(0, Role.DETAIL, true, 0);
        public static final Anchor NETHER_DETAIL_CEILING = new Anchor(1, Role.DETAIL, true, 0);
        public static final Anchor END_DETAIL_CEILING = new Anchor(2, Role.DETAIL, true, 0);
        private static final Comparator<Anchor> COMPARATOR = Comparator.comparing(a -> a.dim).thenComparing(a -> a.role).thenComparing(a -> a.invert).thenComparing(a -> a.id);
        private static final long serialVersionUID = 1L;

        public Anchor(int dim, Role role, boolean invert, int id) {
            if (role == null) {
                throw new NullPointerException("role");
            }
            this.dim = dim;
            this.role = role;
            this.invert = invert;
            this.id = id;
        }

        public String getDefaultName() {
            StringBuilder sb = new StringBuilder();
            switch (this.dim) {
                case 0: {
                    sb.append("Surface");
                    break;
                }
                case 1: {
                    sb.append("Nether");
                    break;
                }
                case 2: {
                    sb.append("End");
                    break;
                }
                default: {
                    sb.append("Dimension ");
                    sb.append(this.dim);
                }
            }
            switch (this.role) {
                case MASTER: {
                    sb.append(" Master");
                    break;
                }
                case CAVE_FLOOR: {
                    sb.append(" Cave Floor");
                }
            }
            if (this.invert) {
                sb.append(" Ceiling");
            }
            if (this.id != 0) {
                sb.append(' ');
                sb.append(this.id);
            }
            return sb.toString();
        }

        public String toString() {
            return this.dim + " " + (Object)((Object)this.role) + (this.invert ? " CEILING" : "") + (this.id != 0 ? " " + this.id : "");
        }

        public boolean equals(Object o) {
            return o instanceof Anchor && ((Anchor)o).dim == this.dim && ((Anchor)o).role == this.role && ((Anchor)o).invert == this.invert && ((Anchor)o).id == this.id;
        }

        public int hashCode() {
            return 31 * (31 * (31 * this.dim + this.role.hashCode()) + (this.invert ? 1 : 0)) + this.id;
        }

        public int compareTo(@NotNull Object o) {
            return COMPARATOR.compare(this, (Anchor)o);
        }

        public static Anchor fromString(String str) {
            boolean invert;
            String[] parts = str.split(" ");
            int dim = Integer.parseInt(parts[0]);
            Role role = Role.valueOf(parts[1]);
            boolean bl = invert = parts.length > 2 && parts[2].equals("CEILING");
            int id = invert ? (parts.length > 3 ? Integer.parseInt(parts[3]) : 0) : (parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
            return new Anchor(dim, role, invert, id);
        }
    }

    private class WPGarden
    implements Garden {
        private final HashSet<Point> activeTiles = new HashSet();

        private WPGarden() {
        }

        @Override
        public void clearLayer(int x, int y, Layer layer, int radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    Dimension.this.setLayerValueAt(layer, x + dx, y + dy, 0);
                }
            }
        }

        @Override
        public void setCategory(int x, int y, int category) {
            Dimension.this.setLayerValueAt(GardenCategory.INSTANCE, x, y, category);
        }

        @Override
        public int getCategory(int x, int y) {
            return Dimension.this.getLayerValueAt(GardenCategory.INSTANCE, x, y);
        }

        @Override
        public Set<Seed> getSeeds() {
            HashSet<Seed> allSeeds = new HashSet<Seed>();
            for (Tile tile : Dimension.this.tiles.values()) {
                allSeeds.addAll(tile.getSeeds());
            }
            return allSeeds;
        }

        @Override
        public <T extends Seed> List<T> findSeeds(Class<T> type, int x, int y, int radius) {
            ArrayList seedsFound = new ArrayList();
            int topLeftTileX = x - radius >> 7;
            int topLeftTileY = y - radius >> 7;
            int bottomRightTileX = x + radius >> 7;
            int bottomRightTileY = y + radius >> 7;
            for (int tileX = topLeftTileX; tileX <= bottomRightTileX; ++tileX) {
                for (int tileY = topLeftTileY; tileY <= bottomRightTileY; ++tileY) {
                    HashSet<Seed> seeds;
                    Tile tile = Dimension.this.getTile(tileX, tileY);
                    if (tile == null || (seeds = tile.getSeeds()) == null) continue;
                    seeds.stream().filter(seed -> seed.getClass() == type).forEach(seed -> {
                        int distance = (int)MathUtils.getDistance((int)(seed.location.x - x), (int)(seed.location.y - y));
                        if (distance <= radius) {
                            seedsFound.add(seed);
                        }
                    });
                }
            }
            return seedsFound;
        }

        @Override
        public boolean isOccupied(int x, int y) {
            return Dimension.this.getLayerValueAt(GardenCategory.INSTANCE, x, y) != 0 || Dimension.this.getWaterLevelAt(x, y) > Dimension.this.getIntHeightAt(x, y);
        }

        @Override
        public boolean isWater(int x, int y) {
            return Dimension.this.getLayerValueAt(GardenCategory.INSTANCE, x, y) == 5 || Dimension.this.getWaterLevelAt(x, y) > Dimension.this.getIntHeightAt(x, y) && !Dimension.this.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y);
        }

        @Override
        public boolean isLava(int x, int y) {
            return Dimension.this.getWaterLevelAt(x, y) > Dimension.this.getIntHeightAt(x, y) && Dimension.this.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y);
        }

        @Override
        public boolean plantSeed(Seed seed) {
            Point3i location = seed.getLocation();
            if (location.x < Dimension.this.lowestX * 128 || location.x > (Dimension.this.highestX + 1) * 128 - 1 || location.y < Dimension.this.lowestY * 128 || location.y > (Dimension.this.highestY + 1) * 128 - 1) {
                return false;
            }
            Tile tile = Dimension.this.getTileForEditing(location.x >> 7, location.y >> 7);
            if (tile != null && tile.plantSeed(seed)) {
                this.activeTiles.add(new Point(location.x >> 7, location.y >> 7));
                return true;
            }
            return false;
        }

        @Override
        public void removeSeed(Seed seed) {
            Point3i location = seed.getLocation();
            if (location.x < Dimension.this.lowestX * 128 || location.x > (Dimension.this.highestX + 1) * 128 - 1 || location.y < Dimension.this.lowestY * 128 || location.y > (Dimension.this.highestY + 1) * 128 - 1) {
                return;
            }
            Tile tile = Dimension.this.getTileForEditing(location.x >> 7, location.y >> 7);
            if (tile != null) {
                tile.removeSeed(seed);
            }
        }

        @Override
        public float getHeight(int x, int y) {
            return Dimension.this.getHeightAt(x, y);
        }

        @Override
        public int getIntHeight(int x, int y) {
            return Dimension.this.getIntHeightAt(x, y);
        }

        @Override
        public boolean tick() {
            for (Point tileCoords : (HashSet)this.activeTiles.clone()) {
                Tile tile = Dimension.this.getTile(tileCoords.x, tileCoords.y);
                if (tile == null) continue;
                ((HashSet)tile.getSeeds().clone()).forEach(Seed::tick);
            }
            boolean finished = true;
            Iterator<Point> i = this.activeTiles.iterator();
            while (i.hasNext()) {
                Point tileCoords = i.next();
                Tile tile = Dimension.this.getTile(tileCoords.x, tileCoords.y);
                boolean tileFinished = true;
                if (tile != null) {
                    for (Seed seed : tile.getSeeds()) {
                        if (seed.isFinished()) continue;
                        tileFinished = false;
                        break;
                    }
                }
                if (tileFinished) {
                    i.remove();
                    continue;
                }
                finished = false;
            }
            return finished;
        }

        @Override
        public void neutralise() {
            for (Point tileCoords : this.activeTiles) {
                Tile tile = Dimension.this.getTile(tileCoords.x, tileCoords.y);
                if (tile == null) continue;
                tile.getSeeds().stream().filter(seed -> !seed.isFinished()).forEach(Seed::neutralise);
            }
            this.activeTiles.clear();
        }
    }

    public class TileVisitationBuilder {
        private final boolean readOnly;
        private Filter filter;
        private Brush brush;
        private int x;
        private int y;
        private boolean selection;

        public TileVisitationBuilder(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public TileVisitationBuilder forFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public TileVisitationBuilder forBrush(Brush brush, int x, int y) {
            this.brush = brush;
            this.x = x;
            this.y = y;
            return this;
        }

        public TileVisitationBuilder forSelection() {
            this.selection = true;
            return this;
        }

        public void andDo(TileVisitor visitor) {
            try {
                this.andDo(visitor, null);
            }
            catch (ProgressReceiver.OperationCancelled operationCancelled) {
                throw new InternalError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void andDo(TileVisitor visitor, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
            Set<Point> tileCoords;
            boolean checkSelection = !this.selection && this.filter instanceof DefaultFilter && ((DefaultFilter)this.filter).isInSelection();
            Layer layerPresent = this.filter instanceof DefaultFilter ? ((DefaultFilter)this.filter).getOnlyOnLayer() : null;
            Layer layerNotPresent = this.filter instanceof DefaultFilter ? ((DefaultFilter)this.filter).getExceptOnLayer() : null;
            boolean checkLayerPresent = layerPresent != null;
            boolean checkLayerNotPresent = layerNotPresent != null;
            int totalTiles = Dimension.this.tiles.size();
            int tileCount = 0;
            int tileX1 = Integer.MIN_VALUE;
            int tileX2 = Integer.MAX_VALUE;
            int tileY1 = Integer.MIN_VALUE;
            int tileY2 = Integer.MAX_VALUE;
            if (this.brush != null) {
                int effectiveRadius = this.brush.getEffectiveRadius();
                int x1 = this.x - effectiveRadius;
                int x2 = this.x + effectiveRadius;
                int y1 = this.y - effectiveRadius;
                int y2 = this.y + effectiveRadius;
                tileX1 = x1 >> 7;
                tileX2 = x2 >> 7;
                tileY1 = y1 >> 7;
                tileY2 = y2 >> 7;
            }
            Dimension.this.readLock.lock();
            try {
                tileCoords = Dimension.this.getTileCoords();
            }
            finally {
                Dimension.this.readLock.unlock();
            }
            for (Point coords : tileCoords) {
                Tile tile = this.readOnly ? Dimension.this.getTile(coords) : Dimension.this.getTileForEditing(coords);
                int tileX = tile.getX();
                int tileY = tile.getY();
                if (!(tileX < tileX1 || tileX > tileX2 || tileY < tileY1 || tileY > tileY2 || checkSelection && !tile.containsOneOf(SelectionBlock.INSTANCE, SelectionChunk.INSTANCE) || checkLayerPresent && !tile.containsOneOf(layerPresent) || checkLayerNotPresent && tile.containsOneOf(layerNotPresent))) {
                    if (this.readOnly) {
                        visitor.visit(tile);
                    } else {
                        tile.inhibitEvents();
                        try {
                            visitor.visit(tile);
                        }
                        finally {
                            tile.releaseEvents();
                        }
                    }
                }
                ++tileCount;
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)tileCount / (float)totalTiles);
            }
        }
    }

    public static enum WallType {
        BEDROCK,
        BARIER;

    }

    public static enum LayerAnchor {
        BEDROCK,
        TERRAIN;

    }

    public static enum Border {
        VOID(false),
        WATER(false),
        LAVA(false),
        ENDLESS_VOID(true),
        ENDLESS_WATER(true),
        ENDLESS_LAVA(true),
        BARRIER(false),
        ENDLESS_BARRIER(true);

        private final boolean endless;

        private Border(boolean endless) {
            this.endless = endless;
        }

        public boolean isEndless() {
            return this.endless;
        }
    }

    public static interface TileVisitor {
        public void visit(Tile var1);
    }

    public static interface Listener {
        public void tilesAdded(Dimension var1, Set<Tile> var2);

        public void tilesRemoved(Dimension var1, Set<Tile> var2);

        public void overlayAdded(Dimension var1, int var2, Overlay var3);

        public void overlayRemoved(Dimension var1, int var2, Overlay var3);
    }
}

