/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.layers.bo2.Bo2Object;
import org.pepsoft.worldpainter.layers.bo2.Bo3Object;
import org.pepsoft.worldpainter.layers.bo2.Schem;
import org.pepsoft.worldpainter.layers.bo2.Schematic;
import org.pepsoft.worldpainter.layers.bo2.Structure;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.AbstractPlugin;
import org.pepsoft.worldpainter.plugins.CustomObjectProvider;

public class DefaultCustomObjectProvider
extends AbstractPlugin
implements CustomObjectProvider {
    private static final List<String> SUPPORTED_EXTENSIONS = ImmutableList.of((Object)"bo2", (Object)"bo3", (Object)"schematic", (Object)"nbt", (Object)"schem");
    private static final List<String> TYPES = ImmutableList.of((Object)Bo2Object.class.getName(), (Object)Bo3Object.class.getName(), (Object)Structure.class.getName(), (Object)Schematic.class.getName(), (Object)Schem.class.getName());

    public DefaultCustomObjectProvider() {
        super("DefaultCustomObjects", Version.VERSION);
    }

    @Override
    public List<String> getKeys() {
        return TYPES;
    }

    @Override
    public List<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public WPObject loadObject(File file) throws IOException {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".bo2")) {
            return Bo2Object.load(file);
        }
        if (name.endsWith(".bo3")) {
            return Bo3Object.load(file);
        }
        if (name.endsWith(".nbt")) {
            return Structure.load(file);
        }
        if (name.endsWith(".schematic")) {
            return Schematic.load(file);
        }
        if (name.endsWith(".schem")) {
            return Schem.load(file);
        }
        throw new IllegalArgumentException("Not a supported filename extension: \"" + file.getName() + "\"");
    }
}

