/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;

public class PackedArrayCube<T> {
    private final Class<T> type;
    private final int arraySize;
    private final int minimumWordSize;
    private final int bitsPerCoordinate;
    private final boolean straddleLongs;
    private final T[] values;

    public PackedArrayCube(int size, int minimumWordSize, boolean straddleLongs, Class<T> type) {
        this.minimumWordSize = minimumWordSize;
        this.straddleLongs = straddleLongs;
        this.type = type;
        this.bitsPerCoordinate = (int)Math.ceil(Math.log(size) / Math.log(2.0));
        this.arraySize = size * size * size;
        this.values = (Object[])Array.newInstance(type, this.arraySize);
    }

    public PackedArrayCube(int size, long[] data, T[] palette, int minimumWordSize, boolean straddleLongs, Class<T> type) {
        block11: {
            this(size, minimumWordSize, straddleLongs, type);
            for (int i = 0; i < palette.length; ++i) {
                if (palette[i] == null || type.isAssignableFrom(palette[i].getClass())) continue;
                throw new IllegalArgumentException("Palette[" + i + "] is not a " + type.getSimpleName() + " (actual type: " + palette[i].getClass().getName() + "; value: " + palette[i] + ")");
            }
            int wordSize = Math.max(minimumWordSize, (int)Math.ceil(Math.log(palette.length) / Math.log(2.0)));
            int expectedPackedDataArrayLengthInBytes = wordSize * this.arraySize / 8;
            int dataArrayLengthInBytes = data.length * 8;
            if (wordSize == 4) {
                for (int w = 0; w < this.arraySize; w += 16) {
                    long arrayValue = data[w >> 4];
                    this.values[w] = palette[(int)(arrayValue & 0xFL)];
                    this.values[w + 1] = palette[(int)((arrayValue & 0xF0L) >> 4)];
                    this.values[w + 2] = palette[(int)((arrayValue & 0xF00L) >> 8)];
                    this.values[w + 3] = palette[(int)((arrayValue & 0xF000L) >> 12)];
                    this.values[w + 4] = palette[(int)((arrayValue & 0xF0000L) >> 16)];
                    this.values[w + 5] = palette[(int)((arrayValue & 0xF00000L) >> 20)];
                    this.values[w + 6] = palette[(int)((arrayValue & 0xF000000L) >> 24)];
                    this.values[w + 7] = palette[(int)((arrayValue & 0xF0000000L) >> 28)];
                    this.values[w + 8] = palette[(int)((arrayValue & 0xF00000000L) >> 32)];
                    this.values[w + 9] = palette[(int)((arrayValue & 0xF000000000L) >> 36)];
                    this.values[w + 10] = palette[(int)((arrayValue & 0xF0000000000L) >> 40)];
                    this.values[w + 11] = palette[(int)((arrayValue & 0xF00000000000L) >> 44)];
                    this.values[w + 12] = palette[(int)((arrayValue & 0xF000000000000L) >> 48)];
                    this.values[w + 13] = palette[(int)((arrayValue & 0xF0000000000000L) >> 52)];
                    this.values[w + 14] = palette[(int)((arrayValue & 0xF00000000000000L) >> 56)];
                    this.values[w + 15] = palette[(int)((arrayValue & 0xF000000000000000L) >>> 60)];
                }
            } else if (dataArrayLengthInBytes != expectedPackedDataArrayLengthInBytes) {
                long mask = (long)Math.pow(2.0, wordSize) - 1L;
                int bitsInUse = 64 / wordSize * wordSize;
                int materialIndex = 0;
                for (long packedData : data) {
                    for (int offset = 0; offset < bitsInUse; offset += wordSize) {
                        this.values[materialIndex++] = palette[(int)((packedData & mask << offset) >>> offset)];
                        if (materialIndex < this.arraySize) {
                            continue;
                        }
                        break block11;
                    }
                }
            } else {
                BitSet bitSet = BitSet.valueOf(data);
                for (int w = 0; w < this.arraySize; ++w) {
                    int wordOffset = w * wordSize;
                    int index = 0;
                    for (int b = 0; b < wordSize; ++b) {
                        index |= bitSet.get(wordOffset + b) ? 1 << b : 0;
                    }
                    this.values[w] = palette[index];
                }
            }
        }
    }

    public T getValue(int x, int y, int z) {
        return this.values[this.offset(x, y, z)];
    }

    public void setValue(int x, int y, int z, T value) {
        this.values[this.offset((int)x, (int)y, (int)z)] = value;
    }

    public void fill(T value) {
        Arrays.fill(this.values, value);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.arraySize; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return true;
    }

    public PackedData pack() {
        return this.pack(null);
    }

    public PackedData pack(T nullSubstitute) {
        long[] data;
        HashMap<T, Integer> reversePalette = new HashMap<T, Integer>();
        LinkedList<T> palette = new LinkedList<T>();
        for (T value : this.values) {
            if (value == null) {
                value = nullSubstitute;
            }
            if (reversePalette.containsKey(value)) continue;
            reversePalette.put(value, palette.size());
            palette.add(value);
        }
        int paletteIndexSize = Math.max((int)Math.ceil(Math.log(palette.size()) / Math.log(2.0)), this.minimumWordSize);
        if (paletteIndexSize == 4 && this.values.length % 16 == 0) {
            data = new long[this.values.length >> 4];
            for (int i = 0; i < this.values.length; i += 16) {
                data[i >> 4] = (long)((Integer)reversePalette.get(this.substituteNull(this.values[i], nullSubstitute)) | (Integer)reversePalette.get(this.substituteNull(this.values[i + 1], nullSubstitute)) << 4 | (Integer)reversePalette.get(this.substituteNull(this.values[i + 2], nullSubstitute)) << 8 | (Integer)reversePalette.get(this.substituteNull(this.values[i + 3], nullSubstitute)) << 12 | (Integer)reversePalette.get(this.substituteNull(this.values[i + 4], nullSubstitute)) << 16 | (Integer)reversePalette.get(this.substituteNull(this.values[i + 5], nullSubstitute)) << 20 | (Integer)reversePalette.get(this.substituteNull(this.values[i + 6], nullSubstitute)) << 24) | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 7], nullSubstitute))).intValue() << 28 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 8], nullSubstitute))).intValue() << 32 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 9], nullSubstitute))).intValue() << 36 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 10], nullSubstitute))).intValue() << 40 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 11], nullSubstitute))).intValue() << 44 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 12], nullSubstitute))).intValue() << 48 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 13], nullSubstitute))).intValue() << 52 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 14], nullSubstitute))).intValue() << 56 | (long)((Integer)reversePalette.get(this.substituteNull(this.values[i + 15], nullSubstitute))).intValue() << 60;
            }
        } else if (this.straddleLongs) {
            int requiredLength;
            BitSet dataBits = new BitSet(this.arraySize * paletteIndexSize);
            for (int i = 0; i < this.arraySize; ++i) {
                int offset = i * paletteIndexSize;
                int index = (Integer)reversePalette.get(this.substituteNull(this.values[i], nullSubstitute));
                for (int j = 0; j < paletteIndexSize; ++j) {
                    if ((index & 1 << j) == 0) continue;
                    dataBits.set(offset + j);
                }
            }
            long[] dataArray = dataBits.toLongArray();
            if (dataArray.length != (requiredLength = 64 * paletteIndexSize)) {
                long[] expandedArray = new long[requiredLength];
                System.arraycopy(dataArray, 0, expandedArray, 0, dataArray.length);
                data = expandedArray;
            } else {
                data = dataArray;
            }
        } else {
            int wordsPerLong = 64 / paletteIndexSize;
            int dataSize = this.arraySize / wordsPerLong + (this.arraySize % wordsPerLong == 0 ? 0 : 1);
            BitSet dataBits = new BitSet(dataSize * 64);
            for (int i = 0; i < this.arraySize; ++i) {
                int offset = i / wordsPerLong * 64 + i % wordsPerLong * paletteIndexSize;
                int index = (Integer)reversePalette.get(this.substituteNull(this.values[i], nullSubstitute));
                for (int j = 0; j < paletteIndexSize; ++j) {
                    if ((index & 1 << j) == 0) continue;
                    dataBits.set(offset + j);
                }
            }
            long[] dataArray = dataBits.toLongArray();
            data = dataArray.length == dataSize ? dataArray : Arrays.copyOf(dataArray, dataSize);
        }
        return new PackedData(data, palette.toArray((Object[])Array.newInstance(this.type, palette.size())));
    }

    private int offset(int x, int y, int z) {
        return x | (y | z << this.bitsPerCoordinate) << this.bitsPerCoordinate;
    }

    private T substituteNull(T value, T nullSubstitute) {
        return value == null ? nullSubstitute : value;
    }

    public class PackedData {
        public final long[] data;
        public final T[] palette;

        public PackedData(long[] data, T[] palette) {
            this.data = data;
            this.palette = palette;
        }
    }
}

