/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft.mapexplorer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pepsoft.minecraft.mapexplorer.FileSystemNode;
import org.pepsoft.minecraft.mapexplorer.NBTFileNode;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.mapexplorer.MapExplorerSupport;
import org.pepsoft.worldpainter.mapexplorer.Node;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryNode
extends FileSystemNode {
    protected static final Collator COLLATOR = Collator.getInstance();
    private final boolean showFiles;
    private static final List<MapExplorerSupport> MAP_RECOGNIZERS = new ArrayList<MapExplorerSupport>();
    private static final Logger logger = LoggerFactory.getLogger(DirectoryNode.class);

    public DirectoryNode(File dir) {
        this(dir, true);
    }

    public DirectoryNode(File dir, boolean showFiles) {
        this(dir, showFiles, null);
    }

    public DirectoryNode(File dir, boolean showFiles, String displayName) {
        super(dir, displayName);
        this.showFiles = showFiles;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    protected Node[] loadChildren() {
        File[] contents = this.file.listFiles(this.showFiles ? null : File::isDirectory);
        if (contents != null) {
            Node[] children = new Node[contents.length];
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isDirectory()) {
                    for (MapExplorerSupport mapRecognizer : MAP_RECOGNIZERS) {
                        try {
                            if (mapRecognizer.identifyMap(contents[i]) == null) continue;
                            children[i] = mapRecognizer.getMapNode(contents[i]);
                            break;
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                    if (children[i] != null) continue;
                    children[i] = new DirectoryNode(contents[i], true);
                    continue;
                }
                if (contents[i].isFile()) {
                    String lowercaseName = contents[i].getName().toLowerCase();
                    if (lowercaseName.endsWith(".nbt") || lowercaseName.endsWith(".dat") || lowercaseName.endsWith(".dat_old")) {
                        children[i] = new NBTFileNode(contents[i]);
                        continue;
                    }
                    if (this.isGzip(contents[i])) {
                        children[i] = new NBTFileNode(contents[i]);
                        continue;
                    }
                    children[i] = new FileSystemNode(contents[i]);
                    continue;
                }
                children[i] = new FileSystemNode(contents[i]);
            }
            Arrays.sort(children, (node1, node2) -> node1.isLeaf() ? (node2.isLeaf() ? COLLATOR.compare(node1.getName(), node2.getName()) : 1) : (node2.isLeaf() ? -1 : COLLATOR.compare(node1.getName(), node2.getName())));
            return children;
        }
        return new Node[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isGzip(File file) {
        if (file.length() < 18L) return false;
        try (FileInputStream in = new FileInputStream(file);){
            boolean bl = in.read() == 31 && in.read() == 139;
            return bl;
        }
        catch (IOException e) {
            logger.warn("I/O error while trying to determine whether " + file + " is a gzip file", (Throwable)e);
        }
        return false;
    }

    static {
        for (Platform platform : PlatformManager.getInstance().getAllPlatforms()) {
            PlatformProvider platformProvider = PlatformManager.getInstance().getPlatformProvider(platform);
            if (!(platformProvider instanceof MapExplorerSupport)) continue;
            MAP_RECOGNIZERS.add((MapExplorerSupport)platformProvider);
        }
    }
}

