/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.NumberTag;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_19Biomes;
import org.pepsoft.worldpainter.biomeschemes.StaticBiomeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperflatPreset
implements Serializable {
    private int biome = -1;
    private List<Layer> layers;
    @Deprecated
    private Set<Structure> structures;
    private Map<Structure, Map<String, String>> structuresMap;
    private String biomeName;
    private boolean features;
    private boolean lakes;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SuperflatPreset.class);

    public SuperflatPreset(int biome, List<Layer> layers, Map<Structure, Map<String, String>> structures) {
        this.biome = biome;
        this.layers = layers;
        this.structuresMap = structures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashMap((Map)entry.getValue())));
        this.features = this.structuresMap.containsKey((Object)Structure.DECORATION);
        this.lakes = this.structuresMap.containsKey((Object)Structure.LAKE) || this.structuresMap.containsKey((Object)Structure.LAVA_LAKE);
    }

    public SuperflatPreset(String biome, List<Layer> layers, Map<Structure, Map<String, String>> structures, boolean features, boolean lakes) {
        this.biomeName = biome;
        this.layers = layers;
        this.structuresMap = structures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashMap((Map)entry.getValue())));
        this.features = features;
        this.lakes = lakes;
    }

    public int getBiome() {
        return this.biome;
    }

    public void setBiome(int biome) {
        this.biome = biome;
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public void setBiomeName(String biomeName) {
        this.biomeName = biomeName;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public Map<Structure, Map<String, String>> getStructures() {
        return this.structuresMap;
    }

    public void setStructures(Map<Structure, Map<String, String>> structures) {
        this.structuresMap = structures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashMap((Map)entry.getValue())));
        this.features = this.structuresMap.containsKey((Object)Structure.DECORATION);
        this.lakes = this.structuresMap.containsKey((Object)Structure.LAKE) || this.structuresMap.containsKey((Object)Structure.LAVA_LAKE);
    }

    public boolean isFeatures() {
        return this.features;
    }

    public void setFeatures(boolean features) {
        this.features = features;
    }

    public boolean isLakes() {
        return this.lakes;
    }

    public void setLakes(boolean lakes) {
        this.lakes = lakes;
    }

    public String toMinecraft1_12_2() {
        return "3;" + this.layers.stream().map(layer -> (((Layer)layer).thickness == 1 ? "" : ((Layer)layer).thickness + "*") + ((Layer)layer).materialName).collect(Collectors.joining(",")) + ';' + this.biome + ';' + this.structuresMap.entrySet().stream().map(entry -> ((Structure)((Object)((Object)entry.getKey()))).name().toLowerCase() + (((Map)entry.getValue()).isEmpty() ? "" : "(" + ((Map)entry.getValue()).entrySet().stream().map(attr -> (String)attr.getKey() + "=" + (String)attr.getValue()).collect(Collectors.joining(" ")) + ")")).collect(Collectors.joining(","));
    }

    public CompoundTag toMinecraft1_15_2() {
        String biome = this.biomeName;
        if (biome == null && this.biome != -1 && Minecraft1_17Biomes.BIOME_NAMES[this.biome] != null) {
            biome = "minecraft:" + Minecraft1_17Biomes.BIOME_NAMES[this.biome].toLowerCase().replace(' ', '_');
        }
        if (biome == null) {
            logger.warn("Biome ID {} not recognised while exporting Superflat preset; substituting minecraft:plains", (Object)biome);
            biome = "minecraft:plains";
        }
        return new CompoundTag("generatorOptions", (Map)ImmutableMap.of((Object)"biome", (Object)new StringTag("biome", biome), (Object)"layers", (Object)new ListTag("layers", CompoundTag.class, this.layers.stream().map(layer -> new CompoundTag("", (Map)ImmutableMap.of((Object)"block", (Object)new StringTag("block", ((Layer)layer).materialName), (Object)"height", (Object)new ShortTag("height", (short)((Layer)layer).thickness)))).collect(Collectors.toList())), (Object)"structures", (Object)new CompoundTag("structures", this.structuresMap.entrySet().stream().collect(Collectors.toMap(structure -> ((Structure)((Object)((Object)structure.getKey()))).name().toLowerCase(), structure -> new CompoundTag(((Structure)((Object)((Object)structure.getKey()))).name().toLowerCase(), ((Map)structure.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new StringTag((String)entry.getKey(), (String)entry.getValue())))))))));
    }

    public CompoundTag toMinecraft1_18_0() {
        String biome = this.biomeName;
        if (biome == null && this.biome != -1) {
            biome = StaticBiomeInfo.MODERN_IDS[this.biome];
        }
        if (biome == null) {
            logger.warn("Biome ID {} not recognised while exporting Superflat preset; substituting minecraft:plains", (Object)biome);
            biome = "minecraft:plains";
        }
        return new CompoundTag("settings", (Map)ImmutableMap.of((Object)"biome", (Object)new StringTag("biome", biome), (Object)"features", (Object)new ByteTag("features", (byte)(this.features ? 1 : 0)), (Object)"lakes", (Object)new ByteTag("lakes", (byte)(this.lakes ? 1 : 0)), (Object)"layers", (Object)new ListTag("layers", CompoundTag.class, this.layers.stream().map(layer -> new CompoundTag("", (Map)ImmutableMap.of((Object)"block", (Object)new StringTag("block", ((Layer)layer).materialName), (Object)"height", (Object)new IntTag("height", ((Layer)layer).thickness)))).collect(Collectors.toList())), (Object)"structures", (Object)new CompoundTag("structures", (Map)ImmutableMap.of((Object)"stronghold", (Object)new CompoundTag("stronghold", Collections.emptyMap()), (Object)"structures", (Object)new CompoundTag("structures", Collections.emptyMap())))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperflatPreset that = (SuperflatPreset)o;
        return this.biome == that.biome && this.layers.equals(that.layers) && this.structuresMap.equals(that.structuresMap);
    }

    public int hashCode() {
        return Objects.hash(this.biome, this.layers, this.structuresMap);
    }

    public String toString() {
        return "SuperflatPreset{biome=" + this.biome + ", layers=" + this.layers + ", structures=" + this.structuresMap + '}';
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.structures != null) {
            this.structuresMap = this.structures.stream().collect(Collectors.toMap(Function.identity(), s -> Collections.emptyMap()));
            this.structures = null;
        }
    }

    public static SuperflatPreset fromMinecraft1_12_2(String str) {
        try {
            String[] tokens = str.split(";");
            if (tokens.length < 3 || !tokens[0].equals("3")) {
                throw new IllegalArgumentException("Invalid Superflat preset for Minecraft 1.12.2: too few tokens, or invalid version");
            }
            List<Layer> layers = Arrays.stream(tokens[1].split(",")).map(layerDescriptor -> {
                int p = layerDescriptor.indexOf(42);
                if (p == -1) {
                    return new Layer((String)layerDescriptor, 1);
                }
                return new Layer(layerDescriptor.substring(p + 1), Integer.parseInt(layerDescriptor.substring(0, p)));
            }).collect(Collectors.toList());
            int biome = Integer.parseInt(tokens[2]);
            HashMap<Structure, Map<String, String>> structures = new HashMap<Structure, Map<String, String>>();
            if (tokens.length >= 4 && tokens[3] != null) {
                Arrays.stream(tokens[3].split(",")).forEach(structure -> {
                    int p = structure.indexOf(40);
                    if (p == -1) {
                        structures.put(Structure.valueOf(structure.toUpperCase()), Collections.emptyMap());
                    } else {
                        Structure key = Structure.valueOf(structure.substring(0, p).toUpperCase());
                        HashMap<String, String> params = new HashMap<String, String>();
                        for (String attr : structure.substring(p + 1, structure.length() - 1).split(" ")) {
                            p = attr.indexOf(61);
                            if (p == -1) {
                                throw new IllegalArgumentException("Invalid Superflat preset for Minecraft 1.12.2: parameter missing");
                            }
                            params.put(attr.substring(0, p), attr.substring(p + 1));
                        }
                        structures.put(key, params);
                    }
                });
            }
            return new SuperflatPreset(biome, layers, structures);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getClass().getSimpleName() + " (message: \"" + e.getMessage() + "\") while parsing string: \"" + str + "\"", e);
        }
    }

    public static SuperflatPreset fromMinecraft1_15_2(CompoundTag tag) {
        try {
            String biomeName = ((StringTag)tag.getTag("biome")).getValue();
            SuperflatPreset preset = new SuperflatPreset(biomeName, ((ListTag)tag.getTag("layers")).getValue().stream().map(layerTag -> new Layer(((StringTag)layerTag.getTag("block")).getValue(), ((NumberTag)layerTag.getTag("height")).intValue())).collect(Collectors.toList()), ((CompoundTag)tag.getTag("structures")).getValue().values().stream().collect(Collectors.toMap(structureTag -> Structure.valueOf(structureTag.getName().toUpperCase()), structureTag -> ((CompoundTag)structureTag).getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, paramEntry -> ((StringTag)paramEntry.getValue()).getValue())))), false, false);
            try {
                preset.setBiome(SuperflatPreset.getBiomeByMinecraft117Name(biomeName));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Biome {} not recognised while importing Superflat preset; substituting Plains biome for older Minecraft versions", (Object)biomeName);
                preset.setBiome(1);
            }
            return preset;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getClass().getSimpleName() + " (message: \"" + e.getMessage() + "\") while parsing tag: " + tag, e);
        }
    }

    public static SuperflatPreset fromMinecraft1_18_0(CompoundTag tag) {
        try {
            String biomeName = ((StringTag)tag.getTag("biome")).getValue();
            SuperflatPreset preset = new SuperflatPreset(biomeName, ((ListTag)tag.getTag("layers")).getValue().stream().map(layerTag -> new Layer(((StringTag)layerTag.getTag("block")).getValue(), ((NumberTag)layerTag.getTag("height")).intValue())).collect(Collectors.toList()), Collections.emptyMap(), ((ByteTag)tag.getTag("features")).getValue() != 0, ((ByteTag)tag.getTag("lakes")).getValue() != 0);
            try {
                preset.setBiome(SuperflatPreset.getBiomeByMinecraft118Name(biomeName));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Biome {} not recognised while importing Superflat preset; substituting Plains biome for older Minecraft versions", (Object)biomeName);
                preset.setBiome(1);
            }
            return preset;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getClass().getSimpleName() + " (message: \"" + e.getMessage() + "\") while parsing tag: " + tag, e);
        }
    }

    public static SuperflatPreset defaultPreset(Platform platform) {
        return new SuperflatPreset(1, Arrays.asList(new Layer("minecraft:bedrock", 1), new Layer("minecraft:dirt", 2), new Layer(platform.getAttribute(Platform.ATTRIBUTE_GRASS_BLOCK_NAME), 1)), Collections.emptyMap());
    }

    public static Builder builder(int biome, Structure ... structures) {
        return new Builder(biome, structures);
    }

    private static int getBiomeByMinecraft117Name(String name) {
        if (name.startsWith("minecraft:")) {
            name = name.substring(10).replace('_', ' ');
            for (int i = 0; i < Minecraft1_17Biomes.BIOME_NAMES.length; ++i) {
                if (!name.equalsIgnoreCase(Minecraft1_17Biomes.BIOME_NAMES[i])) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("Unknown biome name: " + name);
    }

    private static int getBiomeByMinecraft118Name(String name) {
        if (Minecraft1_19Biomes.BIOMES_BY_MODERN_ID.containsKey(name)) {
            return Minecraft1_19Biomes.BIOMES_BY_MODERN_ID.get(name);
        }
        throw new IllegalArgumentException("Unknown biome name: " + name);
    }

    public static class Builder {
        private final int biome;
        private final String biomeName;
        private final Map<Structure, Map<String, String>> structures;
        private final List<Layer> layers = new ArrayList<Layer>();
        private final boolean features;
        private final boolean lakes;

        Builder(int biome, Structure ... structures) {
            this.biome = biome;
            this.biomeName = null;
            this.structures = structures != null && structures.length > 0 ? Arrays.stream(structures).collect(Collectors.toMap(Function.identity(), s -> Collections.emptyMap())) : Collections.emptyMap();
            this.lakes = false;
            this.features = false;
        }

        Builder(String biome, boolean features, boolean lakes, Structure ... structures) {
            this.biomeName = biome;
            this.biome = -1;
            this.features = features;
            this.lakes = lakes;
            this.structures = structures != null && structures.length > 0 ? Arrays.stream(structures).collect(Collectors.toMap(Function.identity(), s -> Collections.emptyMap())) : Collections.emptyMap();
        }

        public Builder addLayer(String materialName, int thickness) {
            this.layers.add(new Layer(materialName, thickness));
            return this;
        }

        public int getLayerDepth() {
            return this.layers.stream().mapToInt(Layer::getThickness).sum();
        }

        public SuperflatPreset build() {
            return this.biomeName != null ? new SuperflatPreset(this.biomeName, this.layers, this.structures, this.features, this.lakes) : new SuperflatPreset(this.biome, this.layers, this.structures);
        }
    }

    public static enum Structure {
        VILLAGE,
        BIOME_1,
        DECORATION,
        STRONGHOLD,
        MINESHAFT,
        LAKE,
        LAVA_LAKE,
        DUNGEON,
        OCEANMONUMENT,
        DESERT_PYRAMID,
        FORTRESS,
        MANSION,
        ENDCITY,
        PILLAGER_OUTPOST,
        RUINED_PORTAL,
        BASTION_REMNANT;

    }

    public static class Layer
    implements Serializable {
        private String materialName;
        private int thickness;
        private static final long serialVersionUID = 1L;

        public Layer(String materialName, int thickness) {
            this.materialName = materialName;
            this.thickness = thickness;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName;
        }

        public int getThickness() {
            return this.thickness;
        }

        public void setThickness(int thickness) {
            this.thickness = thickness;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Layer layer = (Layer)o;
            return this.thickness == layer.thickness && this.materialName.equals(layer.materialName);
        }

        public int hashCode() {
            return Objects.hash(this.materialName, this.thickness);
        }

        public String toString() {
            return "Layer{materialName='" + this.materialName + '\'' + ", thickness=" + this.thickness + '}';
        }
    }
}

