/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.CSVDataSource;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.StartupMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialImporter {
    private static final Set<String> NON_TRANSMITTING_TRANSPARENT_BLOCKS = ImmutableSet.of((Object)"minecraft:dirt_path", (Object)"minecraft:grass_path");
    private static final Logger logger = LoggerFactory.getLogger(MaterialImporter.class);

    static void importCustomMaterials(Map<String, Set<Map<String, Object>>> materialSpecs, Map<String, Set<String>> simpleNamesByNamespace) {
        File[] customSpecFiles;
        File customMaterialsDir = new File(Configuration.getConfigDir(), "materials");
        if (customMaterialsDir.isDirectory() && (customSpecFiles = customMaterialsDir.listFiles(pathname -> pathname.isFile() && pathname.getName().toLowerCase().endsWith(".csv"))) != null) {
            for (File customSpecFile : customSpecFiles) {
                int count = 0;
                HashSet<String> namespaces = new HashSet<String>();
                try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(customSpecFile), StandardCharsets.UTF_8);){
                    CSVDataSource csvDataSource = new CSVDataSource();
                    csvDataSource.openForReading((Reader)in);
                    do {
                        HashMap<String, Object> myMaterialSpecs = new HashMap<String, Object>();
                        String name = csvDataSource.getString("name");
                        myMaterialSpecs.put("name", name);
                        String str = csvDataSource.getString("discriminator", null);
                        if (!Strings.isNullOrEmpty((String)str)) {
                            myMaterialSpecs.put("discriminator", ImmutableSet.copyOf((Object[])str.split(",")));
                        }
                        if (!Strings.isNullOrEmpty((String)(str = csvDataSource.getString("properties", null)))) {
                            myMaterialSpecs.put("properties", Arrays.stream(str.split(",")).map(Material.PropertyDescriptor::fromString).collect(ImmutableSortedMap.toImmutableSortedMap(String::compareTo, d -> d.name, Function.identity())));
                        }
                        myMaterialSpecs.put("opacity", csvDataSource.getInt("opacity", MaterialImporter.guessOpacity(name)));
                        myMaterialSpecs.put("receivesLight", csvDataSource.getBoolean("receivesLight", MaterialImporter.guessReceivesLight(name)));
                        myMaterialSpecs.put("terrain", false);
                        boolean insubstantial = csvDataSource.getBoolean("insubstantial", MaterialImporter.guessInsubstantial(name));
                        myMaterialSpecs.put("insubstantial", insubstantial);
                        myMaterialSpecs.put("veryInsubstantial", csvDataSource.getBoolean("insubstantial", insubstantial || MaterialImporter.guessVeryInsubstantial(name)));
                        myMaterialSpecs.put("resource", csvDataSource.getBoolean("resource", MaterialImporter.guessResource(name)));
                        boolean tileEntity = csvDataSource.getBoolean("tileEntity", false);
                        myMaterialSpecs.put("tileEntity", tileEntity);
                        if (tileEntity) {
                            myMaterialSpecs.put("tileEntityId", csvDataSource.getString("tileEntityId"));
                        }
                        boolean treeRelated = csvDataSource.getBoolean("treeRelated", MaterialImporter.guessTreeRelated(name));
                        myMaterialSpecs.put("treeRelated", treeRelated);
                        boolean vegetation = csvDataSource.getBoolean("vegetation", !treeRelated && MaterialImporter.guessVegetation(name));
                        myMaterialSpecs.put("vegetation", vegetation);
                        myMaterialSpecs.put("blockLight", csvDataSource.getInt("blockLight", 0));
                        myMaterialSpecs.put("natural", csvDataSource.getBoolean("natural", vegetation || treeRelated || MaterialImporter.guessNatural(name)));
                        myMaterialSpecs.put("watery", csvDataSource.getBoolean("watery", false));
                        str = csvDataSource.getString("colour", null);
                        if (!Strings.isNullOrEmpty((String)str)) {
                            try {
                                myMaterialSpecs.put("colour", Integer.parseUnsignedInt(str, 16));
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Not a valid hexadecimal integer value for column colour: \"" + str + "\"", e);
                            }
                        }
                        materialSpecs.computeIfAbsent(name, s -> new HashSet()).add(myMaterialSpecs);
                        int p = name.indexOf(58);
                        String namespace = name.substring(0, p);
                        namespaces.add(namespace);
                        simpleNamesByNamespace.computeIfAbsent(namespace, s -> new HashSet()).add(name.substring(p + 1));
                        csvDataSource.next();
                        ++count;
                    } while (!csvDataSource.isEndOfFile());
                    logger.info("Loaded {} custom block(s) with namespace(s) {} from {}", new Object[]{count, namespaces, customSpecFile.getName()});
                }
                catch (IOException | RuntimeException e) {
                    String message = String.format("%s while reading custom block definition(s) from %s\nMessage: %s", e.getClass().getSimpleName(), customSpecFile.getName(), e.getMessage());
                    logger.error(message, (Throwable)e);
                    StartupMessages.addError(message);
                }
            }
        }
    }

    public static int guessOpacity(String name) {
        if (name.endsWith("_slab") || name.endsWith("_stairs") || name.contains("block") || name.endsWith("_log") || name.endsWith("_wood") || name.endsWith("_stem") || name.endsWith("_hyphea") || name.contains("bricks")) {
            return 15;
        }
        if (name.contains("leaves")) {
            return 1;
        }
        return 0;
    }

    public static boolean guessResource(String name) {
        return name.contains("ore");
    }

    public static boolean guessTreeRelated(String name) {
        return name.endsWith("_log") || name.endsWith("_wood") || name.endsWith("_stem") || name.endsWith("_hyphea") || name.endsWith("_leaves") || name.endsWith("_sapling");
    }

    public static boolean guessVeryInsubstantial(String name) {
        return MaterialImporter.guessVegetation(name) || name.contains("leaves");
    }

    public static boolean guessInsubstantial(String name) {
        return MaterialImporter.guessVegetation(name);
    }

    public static boolean guessVegetation(String name) {
        return !name.endsWith("_block") && !MaterialImporter.guessTreeRelated(name) && (name.contains("leaf") || name.contains("vine") || name.contains("fungus") || name.contains("roots") || name.contains("azalea") || name.contains("flowering") || name.contains("lichen") || name.contains("stem") || name.contains("blossom"));
    }

    public static boolean guessNatural(String material) {
        return (MaterialImporter.guessVegetation(material) || MaterialImporter.guessTreeRelated(material)) && !material.contains("stripped");
    }

    public static boolean guessReceivesLight(String name) {
        return NON_TRANSMITTING_TRANSPARENT_BLOCKS.contains(name) || name.endsWith("_slab") || name.endsWith("_stairs");
    }
}

