/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jnbt.CompoundTag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.MCNumberedBlocksChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.minecraft.exception.IncompatibleMaterialException;

public final class MCRegionChunk
extends MCNumberedBlocksChunk {
    public final boolean readOnly;
    final byte[] blocks;
    final byte[] data;
    final byte[] skyLight;
    final byte[] blockLight;
    final byte[] heightMap;
    final int xPos;
    final int zPos;
    boolean terrainPopulated;
    final List<Entity> entities;
    final List<TileEntity> tileEntities;
    final int maxHeight;

    public MCRegionChunk(int xPos, int zPos, int maxHeight) {
        super(new CompoundTag("Level", new HashMap()));
        this.xPos = xPos;
        this.zPos = zPos;
        this.maxHeight = maxHeight;
        this.blocks = new byte[256 * maxHeight];
        this.data = new byte[128 * maxHeight];
        this.skyLight = new byte[128 * maxHeight];
        this.blockLight = new byte[128 * maxHeight];
        this.heightMap = new byte[256];
        this.entities = new ArrayList<Entity>();
        this.tileEntities = new ArrayList<TileEntity>();
        this.readOnly = false;
    }

    public MCRegionChunk(CompoundTag tag, int maxHeight) {
        this(tag, maxHeight, false);
    }

    public MCRegionChunk(CompoundTag tag, int maxHeight, boolean readOnly) {
        super((CompoundTag)tag.getTag("Level"));
        this.maxHeight = maxHeight;
        this.readOnly = readOnly;
        this.blocks = this.getByteArray("Blocks");
        this.data = this.getByteArray("Data");
        this.skyLight = this.getByteArray("SkyLight");
        this.blockLight = this.getByteArray("BlockLight");
        this.heightMap = this.getByteArray("HeightMap");
        List entityTags = this.getList("Entities");
        this.entities = new ArrayList<Entity>(entityTags.size());
        this.entities.addAll(entityTags.stream().map(Entity::fromNBT).collect(Collectors.toList()));
        List tileEntityTags = this.getList("TileEntities");
        this.tileEntities = new ArrayList<TileEntity>(tileEntityTags.size());
        this.tileEntities.addAll(tileEntityTags.stream().map(TileEntity::fromNBT).collect(Collectors.toList()));
        this.xPos = this.getInt("xPos");
        this.zPos = this.getInt("zPos");
        this.terrainPopulated = this.getBoolean("TerrainPopulated");
    }

    @Override
    public CompoundTag toNBT() {
        this.normalise();
        this.setByteArray("Blocks", this.blocks);
        this.setByteArray("Data", this.data);
        this.setByteArray("SkyLight", this.skyLight);
        this.setByteArray("BlockLight", this.blockLight);
        this.setByteArray("HeightMap", this.heightMap);
        ArrayList entityTags = new ArrayList(this.entities.size());
        entityTags.addAll(this.entities.stream().map(AbstractNBTItem::toNBT).collect(Collectors.toList()));
        this.setList("Entities", CompoundTag.class, entityTags);
        ArrayList tileEntityTags = new ArrayList(this.entities.size());
        tileEntityTags.addAll(this.tileEntities.stream().map(AbstractNBTItem::toNBT).collect(Collectors.toList()));
        this.setList("TileEntities", CompoundTag.class, tileEntityTags);
        this.setLong("LastUpdate", System.currentTimeMillis());
        this.setInt("xPos", this.xPos);
        this.setInt("zPos", this.zPos);
        this.setBoolean("TerrainPopulated", this.terrainPopulated);
        return new CompoundTag("", Collections.singletonMap("", super.toNBT()));
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getzPos() {
        return this.zPos;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.xPos, this.zPos);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        return this.blocks[this.blockOffset(x, y, z)] & 0xFF;
    }

    @Override
    public void setBlockType(int x, int y, int z, int blockType) {
        if (blockType < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material without block ID in MCRegion chunk", null);
        }
        if (this.readOnly) {
            return;
        }
        this.blocks[this.blockOffset((int)x, (int)y, (int)z)] = (byte)blockType;
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        return this.getDataByte(this.data, x, y, z);
    }

    @Override
    public void setDataValue(int x, int y, int z, int dataValue) {
        if (dataValue < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material without data value in MCRegion chunk", null);
        }
        if (this.readOnly) {
            return;
        }
        this.setDataByte(this.data, x, y, z, dataValue);
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        return this.getDataByte(this.skyLight, x, y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.readOnly) {
            return;
        }
        this.setDataByte(this.skyLight, x, y, z, skyLightLevel);
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        return this.getDataByte(this.blockLight, x, y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.readOnly) {
            return;
        }
        this.setDataByte(this.blockLight, x, y, z, blockLightLevel);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.heightMap[x + z * 16] & 0xFF;
    }

    @Override
    public void setHeight(int x, int z, int height) {
        if (this.readOnly) {
            return;
        }
        this.heightMap[x + z * 16] = (byte)Math.min(height, 255);
    }

    @Override
    public boolean isTerrainPopulated() {
        return this.terrainPopulated;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        if (this.readOnly) {
            return;
        }
        this.terrainPopulated = terrainPopulated;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return Material.get(this.getBlockType(x, y, z), this.getDataValue(x, y, z));
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        if (material.blockType < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material " + material + " without block ID in MCRegion chunk", null);
        }
        this.setBlockType(x, y, z, material.blockType);
        this.setDataValue(x, y, z, material.data);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLightPopulated() {
        return false;
    }

    @Override
    public void setLightPopulated(boolean lightPopulated) {
    }

    @Override
    public long getInhabitedTime() {
        return 0L;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        int base = this.blockOffset(x, 0, z);
        for (int i = this.blockOffset(x, this.maxHeight - 1, z); i >= base; --i) {
            if (this.blocks[i] == 0) continue;
            return i - base;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int y = this.maxHeight - 1; y >= 0; --y) {
            for (int i = 0; i < this.blocks.length; i += this.maxHeight) {
                if (this.blocks[i | y] == 0) continue;
                return y;
            }
        }
        return Integer.MIN_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCRegionChunk other = (MCRegionChunk)obj;
        if (this.xPos != other.xPos) {
            return false;
        }
        return this.zPos == other.zPos;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.xPos;
        hash = 67 * hash + this.zPos;
        return hash;
    }

    @Override
    public MCRegionChunk clone() {
        throw new UnsupportedOperationException("ChunkImlp.clone() not supported");
    }

    private int getDataByte(byte[] array, int x, int y, int z) {
        byte dataByte = array[this.blockOffset(x, y, z) / 2];
        if (this.blockOffset(x, y, z) % 2 == 0) {
            return dataByte & 0xF;
        }
        return (dataByte & 0xF0) >> 4;
    }

    private void setDataByte(byte[] array, int x, int y, int z, int dataValue) {
        int blockOffset = this.blockOffset(x, y, z);
        int offset = blockOffset / 2;
        byte dataByte = array[offset];
        if (blockOffset % 2 == 0) {
            dataByte = (byte)(dataByte & 0xF0);
            dataByte = (byte)(dataByte | dataValue & 0xF);
        } else {
            dataByte = (byte)(dataByte & 0xF);
            dataByte = (byte)(dataByte | (dataValue & 0xF) << 4);
        }
        array[offset] = dataByte;
    }

    private int blockOffset(int x, int y, int z) {
        return y + (z + x * 16) * this.maxHeight;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("MCRegionChunk is not serializable");
    }
}

