/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3i;
import org.jnbt.CompoundTag;
import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.NBTChunk;
import org.pepsoft.minecraft.TileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MCNumberedBlocksChunk
extends NBTChunk {
    private static final Map<String, Set<Integer>> LEGACY_TILE_ENTITY_MAP = new HashMap<String, Set<Integer>>();
    private static final Logger logger;

    protected MCNumberedBlocksChunk(CompoundTag tag) {
        super(tag);
    }

    protected MCNumberedBlocksChunk(Map<DataType, CompoundTag> tags) {
        super(tags);
    }

    protected void normalise() {
        Iterator<TileEntity> i = this.getTileEntities().iterator();
        while (i.hasNext()) {
            TileEntity tileEntity = i.next();
            Set<Integer> blockIds = LEGACY_TILE_ENTITY_MAP.get(tileEntity.getId());
            if (blockIds == null) {
                logger.warn("Unknown tile entity ID \"" + tileEntity.getId() + "\" encountered @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + "; can't check whether the corresponding block is there!");
                continue;
            }
            int existingBlockId = this.getBlockType(tileEntity.getX() & 0xF, tileEntity.getY(), tileEntity.getZ() & 0xF);
            if (blockIds.contains(existingBlockId)) continue;
            i.remove();
            if (existingBlockId < Block.BLOCK_TYPE_NAMES.length) {
                logger.warn("Removing tile entity " + tileEntity.getId() + " @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + " because the block at that location is a " + Block.BLOCK_TYPE_NAMES[existingBlockId]);
                continue;
            }
            logger.warn("Removing tile entity " + tileEntity.getId() + " @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + " because the block at that location has ID " + existingBlockId);
        }
        HashSet<Point3i> occupiedCoords = new HashSet<Point3i>();
        Iterator<TileEntity> i2 = this.getTileEntities().iterator();
        while (i2.hasNext()) {
            TileEntity tileEntity = i2.next();
            Point3i coords = new Point3i(tileEntity.getX(), tileEntity.getZ(), tileEntity.getY());
            if (occupiedCoords.contains(coords)) {
                i2.remove();
                logger.warn("Removing tile entity " + tileEntity.getId() + " @ " + tileEntity.getX() + "," + tileEntity.getZ() + "," + tileEntity.getY() + " because there is already a tile entity of the same type at that location");
                continue;
            }
            occupiedCoords.add(coords);
        }
    }

    static {
        LEGACY_TILE_ENTITY_MAP.put("Airportal", Collections.singleton(119));
        LEGACY_TILE_ENTITY_MAP.put("Beacon", Collections.singleton(138));
        LEGACY_TILE_ENTITY_MAP.put("Cauldron", Collections.singleton(117));
        LEGACY_TILE_ENTITY_MAP.put("Chest", (Set<Integer>)ImmutableSet.of((Object)54, (Object)146));
        LEGACY_TILE_ENTITY_MAP.put("Comparator", (Set<Integer>)ImmutableSet.of((Object)149, (Object)150));
        LEGACY_TILE_ENTITY_MAP.put("Control", (Set<Integer>)ImmutableSet.of((Object)137, (Object)211, (Object)210));
        LEGACY_TILE_ENTITY_MAP.put("DLDetector", (Set<Integer>)ImmutableSet.of((Object)151, (Object)178));
        LEGACY_TILE_ENTITY_MAP.put("Dropper", Collections.singleton(158));
        LEGACY_TILE_ENTITY_MAP.put("EnchantTable", Collections.singleton(116));
        LEGACY_TILE_ENTITY_MAP.put("EnderChest", Collections.singleton(130));
        LEGACY_TILE_ENTITY_MAP.put("FlowerPot", Collections.singleton(140));
        LEGACY_TILE_ENTITY_MAP.put("Furnace", (Set<Integer>)ImmutableSet.of((Object)61, (Object)62));
        LEGACY_TILE_ENTITY_MAP.put("Hopper", Collections.singleton(154));
        LEGACY_TILE_ENTITY_MAP.put("MobSpawner", Collections.singleton(52));
        LEGACY_TILE_ENTITY_MAP.put("Music", Collections.singleton(25));
        LEGACY_TILE_ENTITY_MAP.put("Piston", Collections.singleton(34));
        LEGACY_TILE_ENTITY_MAP.put("RecordPlayer", Collections.singleton(84));
        LEGACY_TILE_ENTITY_MAP.put("Sign", (Set<Integer>)ImmutableSet.of((Object)63, (Object)68));
        LEGACY_TILE_ENTITY_MAP.put("Skull", Collections.singleton(144));
        LEGACY_TILE_ENTITY_MAP.put("Trap", Collections.singleton(23));
        LEGACY_TILE_ENTITY_MAP.put("Banner", (Set<Integer>)ImmutableSet.of((Object)176, (Object)177));
        LEGACY_TILE_ENTITY_MAP.put("Structure", Collections.singleton(255));
        LEGACY_TILE_ENTITY_MAP.put("shulker_box", (Set<Integer>)ImmutableSet.of((Object)219, (Object)220, (Object)221, (Object)222, (Object)223, (Object)224, (Object[])new Integer[]{225, 226, 227, 228, 229, 230, 231, 232, 233, 234}));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:end_portal", Collections.singleton(119));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:beacon", Collections.singleton(138));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:brewing_stand", Collections.singleton(117));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:chest", (Set<Integer>)ImmutableSet.of((Object)54, (Object)146));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:comparator", (Set<Integer>)ImmutableSet.of((Object)149, (Object)150));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:command_block", (Set<Integer>)ImmutableSet.of((Object)137, (Object)211, (Object)210));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:daylight_detector", (Set<Integer>)ImmutableSet.of((Object)151, (Object)178));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:dropper", Collections.singleton(158));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:enchanting_table", Collections.singleton(116));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:ender_chest", Collections.singleton(130));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:flower_pot", Collections.singleton(140));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:furnace", (Set<Integer>)ImmutableSet.of((Object)61, (Object)62));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:hopper", Collections.singleton(154));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:mob_spawner", Collections.singleton(52));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:noteblock", Collections.singleton(25));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:piston", Collections.singleton(34));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:jukebox", Collections.singleton(84));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:sign", (Set<Integer>)ImmutableSet.of((Object)63, (Object)68));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:skull", Collections.singleton(144));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:dispenser", Collections.singleton(23));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:banner", (Set<Integer>)ImmutableSet.of((Object)176, (Object)177));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:structure_block", Collections.singleton(255));
        LEGACY_TILE_ENTITY_MAP.put("minecraft:shulker_box", (Set<Integer>)ImmutableSet.of((Object)219, (Object)220, (Object)221, (Object)222, (Object)223, (Object)224, (Object[])new Integer[]{225, 226, 227, 228, 229, 230, 231, 232, 233, 234}));
        HashSet<Integer> allTileEntityIds = new HashSet<Integer>();
        for (Set<Integer> blockIdSet : LEGACY_TILE_ENTITY_MAP.values()) {
            allTileEntityIds.addAll(blockIdSet);
            for (int blockId : blockIdSet) {
                if (!Block.BLOCKS[blockId].tileEntity) {
                    throw new AssertionError((Object)("Block " + blockId + " not marked as tile entity!"));
                }
            }
        }
        for (Block block : Block.BLOCKS) {
            if (block.tileEntity && !allTileEntityIds.contains(block.id)) {
                throw new AssertionError((Object)("Block " + block.id + " marked as tile entity but not present in tile entity map!"));
            }
        }
        logger = LoggerFactory.getLogger(MCNumberedBlocksChunk.class);
    }
}

