/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jnbt.CompoundTag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.MCNumberedBlocksChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.SectionedChunk;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.minecraft.exception.IncompatibleMaterialException;
import org.pepsoft.util.ObjectUtils;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public final class MC12AnvilChunk
extends MCNumberedBlocksChunk
implements MinecraftWorld,
SectionedChunk {
    public final boolean readOnly;
    final Section[] sections;
    final int[] heightMap;
    final int xPos;
    final int zPos;
    byte[] biomes;
    boolean terrainPopulated;
    boolean lightPopulated;
    final List<Entity> entities;
    final List<TileEntity> tileEntities;
    final int maxHeight;
    long inhabitedTime;
    long lastUpdate;

    public MC12AnvilChunk(int xPos, int zPos, int maxHeight) {
        super(new CompoundTag("Level", new HashMap()));
        this.xPos = xPos;
        this.zPos = zPos;
        this.maxHeight = maxHeight;
        this.sections = new Section[maxHeight >> 4];
        this.heightMap = new int[256];
        this.entities = new ArrayList<Entity>();
        this.tileEntities = new ArrayList<TileEntity>();
        this.readOnly = false;
        this.lightPopulated = true;
    }

    public MC12AnvilChunk(CompoundTag tag, int maxHeight) {
        this(tag, maxHeight, false);
    }

    public MC12AnvilChunk(CompoundTag tag, int maxHeight, boolean readOnly) {
        super((CompoundTag)tag.getTag("Level"));
        this.maxHeight = maxHeight;
        this.readOnly = readOnly;
        this.sections = new Section[maxHeight >> 4];
        List sectionTags = (List)ObjectUtils.coalesce(this.getList("Sections"), (Supplier[])new Supplier[]{Collections::emptyList});
        for (CompoundTag sectionTag : sectionTags) {
            Section section;
            this.sections[section.level] = section = new Section(sectionTag);
        }
        this.biomes = this.getByteArray("Biomes");
        this.heightMap = (int[])ObjectUtils.coalesce((Object)this.getIntArray("HeightMap"), (Supplier[])new Supplier[]{() -> new int[256]});
        List entityTags = (List)ObjectUtils.coalesce(this.getList("Entities"), (Supplier[])new Supplier[]{Collections::emptyList});
        this.entities = new ArrayList<Entity>(entityTags.size());
        this.entities.addAll(entityTags.stream().map(Entity::fromNBT).collect(Collectors.toList()));
        List tileEntityTags = (List)ObjectUtils.coalesce(this.getList("TileEntities"), (Supplier[])new Supplier[]{Collections::emptyList});
        this.tileEntities = new ArrayList<TileEntity>(tileEntityTags.size());
        this.tileEntities.addAll(tileEntityTags.stream().map(TileEntity::fromNBT).collect(Collectors.toList()));
        this.lastUpdate = this.getLong("LastUpdate");
        this.xPos = this.getInt("xPos");
        this.zPos = this.getInt("zPos");
        this.terrainPopulated = this.getBoolean("TerrainPopulated");
        this.lightPopulated = this.getBoolean("LightPopulated");
        this.inhabitedTime = this.getLong("InhabitedTime");
    }

    @Override
    public boolean isSectionPresent(int y) {
        return y >= 0 && y < this.sections.length && this.sections[y] != null;
    }

    public Section[] getSections() {
        return this.sections;
    }

    @Override
    public CompoundTag toNBT() {
        this.normalise();
        ArrayList<CompoundTag> sectionTags = new ArrayList<CompoundTag>(this.maxHeight >> 4);
        for (Section section : this.sections) {
            if (section == null || section.isEmpty()) continue;
            sectionTags.add(section.toNBT());
        }
        this.setList("Sections", CompoundTag.class, sectionTags);
        if (this.biomes != null) {
            this.setByteArray("Biomes", this.biomes);
        }
        this.setIntArray("HeightMap", this.heightMap);
        ArrayList entityTags = new ArrayList(this.entities.size());
        this.entities.stream().map(AbstractNBTItem::toNBT).forEach(entityTags::add);
        this.setList("Entities", CompoundTag.class, entityTags);
        ArrayList tileEntityTags = new ArrayList(this.entities.size());
        this.tileEntities.stream().map(AbstractNBTItem::toNBT).forEach(tileEntityTags::add);
        this.setList("TileEntities", CompoundTag.class, tileEntityTags);
        this.setLong("LastUpdate", this.lastUpdate);
        this.setInt("xPos", this.xPos);
        this.setInt("zPos", this.zPos);
        this.setBoolean("TerrainPopulated", this.terrainPopulated);
        this.setBoolean("LightPopulated", this.lightPopulated);
        this.setLong("InhabitedTime", this.inhabitedTime);
        return new CompoundTag("", Collections.singletonMap("", super.toNBT()));
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getzPos() {
        return this.zPos;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.xPos, this.zPos);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        Section section = this.sections[y >> 4];
        if (section == null) {
            return 0;
        }
        if (section.add != null) {
            return section.blocks[this.blockOffset(x, y, z)] & 0xFF | this.getDataByte(section.add, x, y, z) << 8;
        }
        return section.blocks[this.blockOffset(x, y, z)] & 0xFF;
    }

    @Override
    public void setBlockType(int x, int y, int z, int blockType) {
        if (blockType < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material without block ID in pre-1.13 Anvil chunk", null);
        }
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (blockType == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        section.blocks[this.blockOffset((int)x, (int)y, (int)z)] = (byte)blockType;
        if (blockType > 255) {
            if (section.add == null) {
                section.add = new byte[2048];
            }
            this.setDataByte(section.add, x, y, z, blockType >> 8);
        } else if (section.add != null) {
            this.setDataByte(section.add, x, y, z, 0);
        }
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level] == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level].data, x, y, z);
    }

    @Override
    public void setDataValue(int x, int y, int z, int dataValue) {
        if (dataValue < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material without data value in pre-1.13 Anvil chunk", null);
        }
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (dataValue == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        this.setDataByte(section.data, x, y, z, dataValue);
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level] == null) {
            return 15;
        }
        return this.getDataByte(this.sections[level].skyLight, x, y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (skyLightLevel == 15) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        this.setDataByte(section.skyLight, x, y, z, skyLightLevel);
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (this.sections[level] == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level].blockLight, x, y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (blockLightLevel == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        this.setDataByte(section.blockLight, x, y, z, blockLightLevel);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.heightMap[x + z * 16];
    }

    @Override
    public void setHeight(int x, int z, int height) {
        if (this.readOnly) {
            return;
        }
        this.heightMap[x + z * 16] = height;
    }

    @Override
    public boolean isBiomesSupported() {
        return true;
    }

    @Override
    public boolean isBiomesAvailable() {
        return this.biomes != null;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomes[x + z * 16] & 0xFF;
    }

    @Override
    public void setBiome(int x, int z, int biome) {
        if (this.readOnly) {
            return;
        }
        if (this.biomes == null) {
            this.biomes = new byte[256];
        }
        this.biomes[x + z * 16] = (byte)biome;
    }

    @Override
    public boolean isTerrainPopulated() {
        return this.terrainPopulated;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        if (this.readOnly) {
            return;
        }
        this.terrainPopulated = terrainPopulated;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        Section section = this.sections[y >> 4];
        if (section == null) {
            return Material.AIR;
        }
        int blockType = section.add != null ? section.blocks[this.blockOffset(x, y, z)] & 0xFF | this.getDataByte(section.add, x, y, z) << 8 : section.blocks[this.blockOffset(x, y, z)] & 0xFF;
        return blockType != 0 ? Material.get(blockType, this.getDataByte(section.data, x, y, z)) : Material.AIR;
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        int blockType;
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (material == Material.AIR) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        if ((blockType = material.blockType) < 0) {
            throw new IncompatibleMaterialException("Cannot store modern material " + material + " without block ID in pre-1.13 Anvil chunk", material);
        }
        section.blocks[this.blockOffset((int)x, (int)y, (int)z)] = (byte)blockType;
        if (blockType > 255) {
            if (section.add == null) {
                section.add = new byte[2048];
            }
            this.setDataByte(section.add, x, y, z, blockType >> 8);
        } else if (section.add != null) {
            this.setDataByte(section.add, x, y, z, 0);
        }
        this.setDataByte(section.data, x, y, z, material.data);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLightPopulated() {
        return this.lightPopulated;
    }

    @Override
    public void setLightPopulated(boolean lightPopulated) {
        this.lightPopulated = lightPopulated;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            byte[] blocks = this.sections[yy].blocks;
            int base = this.blockOffset(x, 0, z);
            for (int i = this.blockOffset(x, 15, z); i >= base; i -= 256) {
                if (blocks[i] == 0) continue;
                return yy << 4 | i - base >> 8;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            byte[] blocks = this.sections[yy].blocks;
            for (int i = blocks.length - 1; i >= 0; --i) {
                if (blocks[i] == 0) continue;
                return yy << 4 | i >> 8;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        return this.getBlockType(x, height, y);
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        return this.getDataValue(x, height, y);
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        return this.getMaterial(x, height, y);
    }

    @Override
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        this.setBlockType(x, height, y, blockType);
    }

    @Override
    public void setDataAt(int x, int y, int height, int data) {
        this.setDataValue(x, height, y, data);
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        this.setMaterial(x, height, y, material);
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return x == this.xPos && y == this.zPos;
    }

    @Override
    public void addChunk(Chunk chunk) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        entity = entity.clone();
        entity.setPos(new double[]{x, height, y});
        this.getEntities().add(entity);
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        tileEntity = (TileEntity)tileEntity.clone();
        tileEntity.setX(x);
        tileEntity.setZ(y);
        tileEntity.setY(height);
        this.getTileEntities().add(tileEntity);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        if (x == this.xPos && z == this.zPos) {
            return this;
        }
        return null;
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MC12AnvilChunk other = (MC12AnvilChunk)obj;
        if (this.xPos != other.xPos) {
            return false;
        }
        return this.zPos == other.zPos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.xPos;
        hash = 37 * hash + this.zPos;
        return hash;
    }

    @Override
    public MC12AnvilChunk clone() {
        throw new UnsupportedOperationException("MC12AnvilChunk.clone() not supported");
    }

    private int getDataByte(byte[] array, int x, int y, int z) {
        int blockOffset = this.blockOffset(x, y, z);
        byte dataByte = array[blockOffset / 2];
        if (blockOffset % 2 == 0) {
            return dataByte & 0xF;
        }
        return (dataByte & 0xF0) >> 4;
    }

    private void setDataByte(byte[] array, int x, int y, int z, int dataValue) {
        int blockOffset = this.blockOffset(x, y, z);
        int offset = blockOffset / 2;
        byte dataByte = array[offset];
        if (blockOffset % 2 == 0) {
            dataByte = (byte)(dataByte & 0xF0);
            dataByte = (byte)(dataByte | dataValue & 0xF);
        } else {
            dataByte = (byte)(dataByte & 0xF);
            dataByte = (byte)(dataByte | (dataValue & 0xF) << 4);
        }
        array[offset] = dataByte;
    }

    private int blockOffset(int x, int y, int z) {
        return x | (z | (y & 0xF) << 4) << 4;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("MC12AnvilChunk is not serializable");
    }

    public static class Section
    extends AbstractNBTItem
    implements SectionedChunk.Section {
        final byte level;
        final byte[] blocks;
        final byte[] data;
        final byte[] skyLight;
        final byte[] blockLight;
        byte[] add;

        Section(CompoundTag tag) {
            super(tag);
            this.level = this.getByte("Y");
            this.blocks = this.getByteArray("Blocks");
            if (this.containsTag("Add")) {
                this.add = this.getByteArray("Add");
            }
            this.data = this.getByteArray("Data");
            this.skyLight = this.getByteArray("SkyLight");
            this.blockLight = this.getByteArray("BlockLight");
        }

        Section(byte level) {
            super(new CompoundTag("", new HashMap()));
            this.level = level;
            this.blocks = new byte[4096];
            this.data = new byte[2048];
            this.skyLight = new byte[2048];
            Arrays.fill(this.skyLight, (byte)-1);
            this.blockLight = new byte[2048];
        }

        @Override
        public CompoundTag toNBT() {
            this.setByte("Y", this.level);
            this.setByteArray("Blocks", this.blocks);
            if (this.add != null) {
                for (byte b : this.add) {
                    if (b == 0) continue;
                    this.setByteArray("Add", this.add);
                    break;
                }
            }
            this.setByteArray("Data", this.data);
            this.setByteArray("SkyLight", this.skyLight);
            this.setByteArray("BlockLight", this.blockLight);
            return super.toNBT();
        }

        @Override
        public boolean isEmpty() {
            for (byte b : this.blocks) {
                if (b == 0) continue;
                return false;
            }
            if (this.add != null) {
                for (byte b : this.add) {
                    if (b == 0) continue;
                    return false;
                }
            }
            for (byte b : this.skyLight) {
                if (b == -1) continue;
                return false;
            }
            for (byte b : this.blockLight) {
                if (b == 0) continue;
                return false;
            }
            for (byte b : this.data) {
                if (b == 0) continue;
                return false;
            }
            return true;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("MC12AnvilChunk.Section is not serializable");
        }
    }
}

