/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.LongArrayTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.MCNamedBlocksChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.minecraft.SectionedChunk;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.PackedArrayCube;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MC115AnvilChunk
extends MCNamedBlocksChunk
implements SectionedChunk,
MinecraftWorld {
    public final boolean readOnly;
    final Section[] sections;
    final int xPos;
    final int zPos;
    final int maxHeight;
    final List<Entity> entities;
    final List<TileEntity> tileEntities;
    final Map<String, long[]> heightMaps;
    final List<CompoundTag> liquidTicks = new ArrayList<CompoundTag>();
    final Integer inputDataVersion;
    int highestSectionWithSkylight = Integer.MIN_VALUE;
    int[] biomes3d;
    boolean lightOn;
    long inhabitedTime;
    long lastUpdate;
    String status;
    private static final Random RANDOM = new Random();
    private static final ThreadLocal<int[]> BIOME_BUCKETS_HOLDER = ThreadLocal.withInitial(() -> new int[256]);
    private static final Logger logger = LoggerFactory.getLogger(MC115AnvilChunk.class);

    public MC115AnvilChunk(int xPos, int zPos, int maxHeight) {
        super(new CompoundTag("Level", new HashMap()));
        this.xPos = xPos;
        this.zPos = zPos;
        this.maxHeight = maxHeight;
        this.inputDataVersion = null;
        this.sections = new Section[maxHeight >> 4];
        this.heightMaps = new HashMap<String, long[]>();
        this.entities = new ArrayList<Entity>();
        this.tileEntities = new ArrayList<TileEntity>();
        this.readOnly = false;
        this.lightOn = true;
        this.setTerrainPopulated(true);
    }

    public MC115AnvilChunk(CompoundTag tag, int maxHeight) {
        this(tag, maxHeight, false);
    }

    public MC115AnvilChunk(CompoundTag tag, int maxHeight, boolean readOnly) {
        super((CompoundTag)tag.getTag("Level"));
        try {
            List entityTags;
            Tag biomesTag;
            this.maxHeight = maxHeight;
            this.readOnly = readOnly;
            this.inputDataVersion = ((IntTag)tag.getTag("DataVersion")).getValue();
            this.sections = new Section[maxHeight >> 4];
            List sectionTags = this.getList("Sections");
            if (sectionTags != null) {
                for (CompoundTag sectionTag : sectionTags) {
                    try {
                        Section section = new Section(sectionTag);
                        if (section.level >= 0 && section.level < this.sections.length) {
                            this.sections[section.level] = section;
                            if (section.skyLight == null || section.level <= this.highestSectionWithSkylight) continue;
                            this.highestSectionWithSkylight = section.level;
                            continue;
                        }
                        if (section.isEmpty()) continue;
                        logger.warn("Ignoring non-empty out of bounds chunk section @ " + this.getxPos() + "," + section.level + "," + this.getzPos());
                    }
                    catch (IncompleteSectionException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Ignoring chunk section with missing data @ " + this.getxPos() + "," + ((ByteTag)sectionTag.getTag("Y")).getValue() + "," + this.getzPos());
                    }
                }
            }
            if ((biomesTag = this.getTag("Biomes")) instanceof IntArrayTag) {
                this.biomes3d = this.getIntArray("Biomes");
            } else if (biomesTag instanceof ByteArrayTag) {
                byte[] biomesArray = ((ByteArrayTag)biomesTag).getValue();
                this.biomes3d = new int[biomesArray.length];
                for (int i = 0; i < biomesArray.length; ++i) {
                    this.biomes3d[i] = biomesArray[i] & 0xFF;
                }
            }
            if (this.biomes3d != null) {
                this.fixNegativeValues(this.biomes3d);
                if (this.biomes3d.length == 256) {
                    this.biomes3d = this.migrate2DBiomesTo3D(this.biomes3d);
                }
            }
            this.heightMaps = new HashMap<String, long[]>();
            Map<String, Tag> heightMapTags = this.getMap("Heightmaps");
            if (heightMapTags != null) {
                for (Map.Entry<String, Tag> entry : heightMapTags.entrySet()) {
                    this.heightMaps.put(entry.getKey().intern(), ((LongArrayTag)entry.getValue()).getValue());
                }
            }
            if ((entityTags = this.getList("Entities")) != null) {
                this.entities = new ArrayList<Entity>(entityTags.size());
                this.entities.addAll(entityTags.stream().map(Entity::fromNBT).collect(Collectors.toList()));
            } else {
                this.entities = new ArrayList<Entity>();
            }
            List tileEntityTags = this.getList("TileEntities");
            if (tileEntityTags != null) {
                this.tileEntities = new ArrayList<TileEntity>(tileEntityTags.size());
                this.tileEntities.addAll(tileEntityTags.stream().map(TileEntity::fromNBT).collect(Collectors.toList()));
            } else {
                this.tileEntities = new ArrayList<TileEntity>();
            }
            this.lastUpdate = this.getLong("LastUpdate");
            this.xPos = this.getInt("xPos");
            this.zPos = this.getInt("zPos");
            this.status = this.getString("Status").intern();
            this.lightOn = this.getBoolean("isLightOn");
            this.inhabitedTime = this.getLong("InhabitedTime");
            if (this.containsTag("LiquidTicks")) {
                this.liquidTicks.addAll(this.getList("LiquidTicks"));
            }
        }
        catch (ExceptionParsingSectionException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("{} while creating chunk from NBT: {}", (Object)e.getClass().getSimpleName(), (Object)tag);
            throw e;
        }
    }

    private int[] migrate2DBiomesTo3D(int[] biomes2d) {
        int[] biomes3d = new int[1024];
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int biome = this.determineMostPrevalentBiome(biomes2d, x, z);
                for (int y = 0; y < 64; ++y) {
                    biomes3d[y << 4 | z << 2 | x] = biome;
                }
            }
        }
        return biomes3d;
    }

    private int determineMostPrevalentBiome(int[] biomes, int x, int z) {
        int[] biomeBuckets = BIOME_BUCKETS_HOLDER.get();
        Arrays.fill(biomeBuckets, 0);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dz = 0; dz < 4; ++dz) {
                int biome;
                int n = biome = biomes[(x << 2) + dx + ((z << 2) + dz) * 16];
                biomeBuckets[n] = biomeBuckets[n] + 1;
            }
        }
        int mostPrevalentBiome = 0;
        int mostPrevalentBiomeCount = 0;
        for (int i = 0; i < biomeBuckets.length; ++i) {
            if (biomeBuckets[i] <= mostPrevalentBiomeCount) continue;
            mostPrevalentBiome = i;
            mostPrevalentBiomeCount = biomeBuckets[i];
        }
        return mostPrevalentBiome;
    }

    @Override
    public boolean isSectionPresent(int y) {
        return y >= 0 && y < this.sections.length && this.sections[y] != null;
    }

    public Section[] getSections() {
        return this.sections;
    }

    public void setStatus(String status) {
        this.status = status.intern();
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, long[]> getHeightMaps() {
        return this.heightMaps;
    }

    public Integer getInputDataVersion() {
        return this.inputDataVersion;
    }

    private void addLiquidTick(int x, int y, int z) {
        Material material = this.getMaterial((x = this.xPos << 4 | x) & 0xF, y, (z = this.zPos << 4 | z) & 0xF);
        String id = material.containsWater() ? "minecraft:water" : (material.isNamed("minecraft:water") ? "minecraft:flowing_water" : (material.isNamed("minecraft:lava") ? (material.getProperty(Material.LEVEL) == 0 ? "minecraft:lava" : "minecraft:flowing_lava") : material.name));
        Iterator<CompoundTag> i = this.liquidTicks.iterator();
        while (i.hasNext()) {
            CompoundTag liquidTick = i.next();
            if (x != ((IntTag)liquidTick.getTag("x")).getValue() || y != ((IntTag)liquidTick.getTag("y")).getValue() || z != ((IntTag)liquidTick.getTag("z")).getValue()) continue;
            String existingId = ((StringTag)liquidTick.getTag("i")).getValue();
            if (id.equals(existingId)) {
                return;
            }
            logger.warn("Replacing liquid tick for type {} with type {} @ {},{},{}", new Object[]{existingId, id, x, y, z});
            i.remove();
            break;
        }
        this.liquidTicks.add(new CompoundTag("", (Map)ImmutableMap.builder().put((Object)"x", (Object)new IntTag("x", x)).put((Object)"y", (Object)new IntTag("y", y)).put((Object)"z", (Object)new IntTag("z", z)).put((Object)"i", (Object)new StringTag("i", id)).put((Object)"p", (Object)new IntTag("p", 0)).put((Object)"t", (Object)new IntTag("t", RANDOM.nextInt(30) + 1)).build()));
    }

    @Override
    public CompoundTag toNBT() {
        this.normalise();
        if (this.sections != null) {
            ArrayList<CompoundTag> sectionTags = new ArrayList<CompoundTag>(this.maxHeight >> 4);
            for (Section section : this.sections) {
                if (section == null || section.isEmpty()) continue;
                sectionTags.add(section.toNBT());
            }
            this.setList("Sections", CompoundTag.class, sectionTags);
        }
        if (this.biomes3d != null) {
            this.setIntArray("Biomes", this.biomes3d);
        }
        ArrayList entityTags = new ArrayList(this.entities.size());
        this.entities.stream().map(AbstractNBTItem::toNBT).forEach(entityTags::add);
        this.setList("Entities", CompoundTag.class, entityTags);
        ArrayList tileEntityTags = new ArrayList(this.entities.size());
        this.tileEntities.stream().map(AbstractNBTItem::toNBT).forEach(tileEntityTags::add);
        this.setList("TileEntities", CompoundTag.class, tileEntityTags);
        this.setLong("LastUpdate", this.lastUpdate);
        this.setInt("xPos", this.xPos);
        this.setInt("zPos", this.zPos);
        this.setString("Status", this.status);
        this.setBoolean("isLightOn", this.lightOn);
        this.setLong("InhabitedTime", this.inhabitedTime);
        this.setList("LiquidTicks", CompoundTag.class, this.liquidTicks);
        CompoundTag tag = new CompoundTag("", Collections.emptyMap());
        tag.setTag("Level", (Tag)super.toNBT());
        tag.setTag("DataVersion", (Tag)new IntTag("DataVersion", this.inputDataVersion != null ? this.inputDataVersion : 2230));
        return tag;
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getxPos() {
        return this.xPos;
    }

    @Override
    public int getzPos() {
        return this.zPos;
    }

    @Override
    public MinecraftCoords getCoords() {
        return new MinecraftCoords(this.xPos, this.zPos);
    }

    @Override
    public int getBlockType(int x, int y, int z) {
        return this.getMaterial((int)x, (int)y, (int)z).blockType;
    }

    @Override
    @Deprecated
    public void setBlockType(int x, int y, int z, int blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDataValue(int x, int y, int z) {
        return this.getMaterial((int)x, (int)y, (int)z).data;
    }

    @Override
    @Deprecated
    public void setDataValue(int x, int y, int z, int dataValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (z < 0 || z >= this.maxHeight || this.sections[level] == null || this.sections[level].skyLight == null) {
            return level > this.highestSectionWithSkylight ? 15 : 0;
        }
        return this.getDataByte(this.sections[level].skyLight, x, y, z);
    }

    @Override
    public void setSkyLightLevel(int x, int y, int z, int skyLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (skyLightLevel == (level > this.highestSectionWithSkylight ? 15 : 0)) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        if (section.skyLight == null) {
            if (skyLightLevel == (level > this.highestSectionWithSkylight ? 15 : 0)) {
                return;
            }
            section.skyLight = new byte[2048];
            if (level > this.highestSectionWithSkylight) {
                Arrays.fill(section.skyLight, (byte)-1);
                this.highestSectionWithSkylight = level;
            }
        }
        this.setDataByte(section.skyLight, x, y, z, skyLightLevel);
    }

    @Override
    public int getBlockLightLevel(int x, int y, int z) {
        int level = y >> 4;
        if (z < 0 || z >= this.maxHeight || this.sections[level] == null || this.sections[level].blockLight == null) {
            return 0;
        }
        return this.getDataByte(this.sections[level].blockLight, x, y, z);
    }

    @Override
    public void setBlockLightLevel(int x, int y, int z, int blockLightLevel) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (blockLightLevel == 0) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        if (section.blockLight == null) {
            if (blockLightLevel == 0) {
                return;
            }
            section.blockLight = new byte[2048];
        }
        this.setDataByte(section.blockLight, x, y, z, blockLightLevel);
    }

    @Override
    public int getHeight(int x, int z) {
        return 62;
    }

    @Override
    public void setHeight(int x, int z, int height) {
        if (this.readOnly) {
            return;
        }
    }

    @Override
    public boolean is3DBiomesSupported() {
        return true;
    }

    @Override
    public boolean is3DBiomesAvailable() {
        return this.biomes3d != null && this.biomes3d.length > 0;
    }

    @Override
    public int get3DBiome(int x, int y, int z) {
        int index = x + z * 4 + y * 16;
        return index >= 0 && index < this.biomes3d.length ? this.biomes3d[index] : 1;
    }

    @Override
    public void set3DBiome(int x, int y, int z, int biome) {
        if (this.readOnly) {
            return;
        }
        if (this.biomes3d == null) {
            this.biomes3d = new int[16 * (this.maxHeight / 4)];
        }
        this.biomes3d[x + z * 4 + y * 16] = biome;
    }

    @Override
    public void markForUpdateChunk(int x, int y, int z) {
        Material material = this.getMaterial(x, y, z);
        if (!material.isNamedOneOf("minecraft:water", "minecraft:lava") && !material.containsWater()) {
            throw new UnsupportedOperationException("Don't know how to mark " + material + " for update");
        }
        this.addLiquidTick(x, y, z);
    }

    @Override
    public boolean isTerrainPopulated() {
        return true;
    }

    @Override
    public void setTerrainPopulated(boolean terrainPopulated) {
        if (this.readOnly) {
            return;
        }
        if (!terrainPopulated) {
            throw new UnsupportedOperationException("Terrain population not supported for Minecraft 1.15 - 1.17");
        }
        this.status = "full";
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        if (z < 0 || z >= this.maxHeight) {
            return Material.AIR;
        }
        Section section = this.sections[y >> 4];
        if (section == null) {
            return Material.AIR;
        }
        Material material = section.materials.getValue(x, z, y & 0xF);
        return material != null ? material : Material.AIR;
    }

    @Override
    public void setMaterial(int x, int y, int z, Material material) {
        if (this.readOnly) {
            return;
        }
        int level = y >> 4;
        Section section = this.sections[level];
        if (section == null) {
            if (material == Material.AIR) {
                return;
            }
            this.sections[level] = section = new Section((byte)level);
        }
        section.materials.setValue(x, z, y & 0xF, material == Material.AIR ? null : material);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isLightPopulated() {
        return this.lightOn;
    }

    @Override
    public void setLightPopulated(boolean lightOn) {
        this.lightOn = lightOn;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    @Override
    public int getHighestNonAirBlock(int x, int z) {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            PackedArrayCube<Material> materials = this.sections[yy].materials;
            for (int y = 15; y >= 0; --y) {
                if (materials.getValue(x, z, y) == null || materials.getValue(x, z, y) == Material.AIR) continue;
                return yy << 4 | y;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHighestNonAirBlock() {
        for (int yy = this.sections.length - 1; yy >= 0; --yy) {
            if (this.sections[yy] == null) continue;
            PackedArrayCube<Material> materials = this.sections[yy].materials;
            for (int y = 15; y >= 0; --y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (materials.getValue(x, z, y) == null || materials.getValue(x, z, y) == Material.AIR) continue;
                        return yy << 4 | y;
                    }
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getBlockTypeAt(int x, int y, int height) {
        return this.getBlockType(x, height, y);
    }

    @Override
    public int getDataAt(int x, int y, int height) {
        return this.getDataValue(x, height, y);
    }

    @Override
    public Material getMaterialAt(int x, int y, int height) {
        return this.getMaterial(x, height, y);
    }

    @Override
    @Deprecated
    public void setBlockTypeAt(int x, int y, int height, int blockType) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setDataAt(int x, int y, int height, int data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaterialAt(int x, int y, int height, Material material) {
        this.setMaterial(x, height, y, material);
    }

    @Override
    public boolean isChunkPresent(int x, int y) {
        return x == this.xPos && y == this.zPos;
    }

    @Override
    public void addChunk(Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEntity(double x, double y, double height, Entity entity) {
        entity = entity.clone();
        entity.setPos(new double[]{x, height, y});
        this.getEntities().add(entity);
    }

    @Override
    public void addTileEntity(int x, int y, int height, TileEntity tileEntity) {
        tileEntity = (TileEntity)tileEntity.clone();
        tileEntity.setX(x);
        tileEntity.setZ(y);
        tileEntity.setY(height);
        this.getTileEntities().add(tileEntity);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        if (x == this.xPos && z == this.zPos) {
            return this;
        }
        return null;
    }

    @Override
    public Chunk getChunkForEditing(int x, int z) {
        return this.getChunk(x, z);
    }

    @Override
    public void close() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MC115AnvilChunk other = (MC115AnvilChunk)obj;
        if (this.xPos != other.xPos) {
            return false;
        }
        return this.zPos == other.zPos;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.xPos;
        hash = 37 * hash + this.zPos;
        return hash;
    }

    @Override
    public MC115AnvilChunk clone() {
        throw new UnsupportedOperationException("MC113AnvilChunk.clone() not supported");
    }

    private void fixNegativeValues(int[] biomes) {
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] >= 0) continue;
            biomes[i] = biomes[i] & 0xFF;
        }
    }

    private int getDataByte(byte[] array, int x, int y, int z) {
        int blockOffset = MC115AnvilChunk.blockOffset(x, y, z);
        byte dataByte = array[blockOffset / 2];
        if (blockOffset % 2 == 0) {
            return dataByte & 0xF;
        }
        return (dataByte & 0xF0) >> 4;
    }

    private void setDataByte(byte[] array, int x, int y, int z, int dataValue) {
        int blockOffset = MC115AnvilChunk.blockOffset(x, y, z);
        int offset = blockOffset / 2;
        byte dataByte = array[offset];
        if (blockOffset % 2 == 0) {
            dataByte = (byte)(dataByte & 0xF0);
            dataByte = (byte)(dataByte | dataValue & 0xF);
        } else {
            dataByte = (byte)(dataByte & 0xF);
            dataByte = (byte)(dataByte | (dataValue & 0xF) << 4);
        }
        array[offset] = dataByte;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("MC115AnvilChunk is not serializable");
    }

    static int blockOffset(int x, int y, int z) {
        return x | (z | (y & 0xF) << 4) << 4;
    }

    static class ExceptionParsingSectionException
    extends MDCCapturingRuntimeException {
        ExceptionParsingSectionException(Throwable cause) {
            super("Could not parse section", cause);
        }
    }

    static class IncompleteSectionException
    extends MDCCapturingRuntimeException {
        IncompleteSectionException() {
            super("Incomplete section");
        }
    }

    public class Section
    extends AbstractNBTItem
    implements SectionedChunk.Section {
        public final byte level;
        byte[] skyLight;
        byte[] blockLight;
        final PackedArrayCube<Material> materials;

        Section(CompoundTag tag) {
            super(tag);
            try {
                Material[] palette;
                this.level = this.getByte("Y");
                long[] blockStates = this.getLongArray("BlockStates");
                List<CompoundTag> paletteList = this.getList("Palette");
                if (blockStates != null && paletteList != null) {
                    palette = new Material[paletteList.size()];
                    for (int i = 0; i < palette.length; ++i) {
                        palette[i] = this.getMaterial(paletteList, i);
                    }
                } else {
                    throw new IncompleteSectionException();
                }
                this.materials = new PackedArrayCube<Material>(16, blockStates, palette, 4, MC115AnvilChunk.this.inputDataVersion <= 2230, Material.class);
                this.skyLight = this.getByteArray("SkyLight");
                this.blockLight = this.getByteArray("BlockLight");
            }
            catch (IncompleteSectionException e) {
                throw e;
            }
            catch (RuntimeException e) {
                logger.error("{} while creating chunk from NBT: {}", (Object)e.getClass().getSimpleName(), (Object)tag);
                throw new ExceptionParsingSectionException(e);
            }
        }

        Section(byte level) {
            super(new CompoundTag("", new HashMap()));
            this.level = level;
            this.materials = new PackedArrayCube<Material>(16, 4, true, Material.class);
        }

        @Override
        public CompoundTag toNBT() {
            this.setByte("Y", this.level);
            PackedArrayCube.PackedData packedMaterials = this.materials.pack(Material.AIR);
            ArrayList<CompoundTag> paletteList = new ArrayList<CompoundTag>(((Material[])packedMaterials.palette).length);
            for (Material material : (Material[])packedMaterials.palette) {
                CompoundTag paletteEntry = new CompoundTag("", Collections.emptyMap());
                paletteEntry.setTag("Name", (Tag)new StringTag("Name", material.name));
                if (material.getProperties() != null) {
                    CompoundTag propertiesTag = new CompoundTag("Properties", Collections.emptyMap());
                    for (Map.Entry<String, String> property : material.getProperties().entrySet()) {
                        propertiesTag.setTag(property.getKey(), (Tag)new StringTag(property.getKey(), property.getValue()));
                    }
                    paletteEntry.setTag("Properties", (Tag)propertiesTag);
                }
                paletteList.add(paletteEntry);
            }
            this.setList("Palette", CompoundTag.class, paletteList);
            this.setLongArray("BlockStates", packedMaterials.data);
            if (this.skyLight != null) {
                this.setByteArray("SkyLight", this.skyLight);
            }
            if (this.blockLight != null) {
                this.setByteArray("BlockLight", this.blockLight);
            }
            return super.toNBT();
        }

        @Override
        public boolean isEmpty() {
            if (!this.materials.isEmpty()) {
                return false;
            }
            if (this.skyLight != null) {
                for (byte b : this.skyLight) {
                    if (b == 0) continue;
                    return false;
                }
            }
            if (this.blockLight != null) {
                for (byte b : this.blockLight) {
                    if (b == 0) continue;
                    return false;
                }
            }
            return true;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("MC115AnvilChunk.Section is not serializable");
        }

        private Material getMaterial(List<CompoundTag> palette, int index) {
            HashMap<String, String> properties;
            CompoundTag blockSpecTag = palette.get(index);
            String name = ((StringTag)blockSpecTag.getTag("Name")).getValue();
            CompoundTag propertiesTag = (CompoundTag)blockSpecTag.getTag("Properties");
            if (name.equals("minecraft:air") && propertiesTag == null) {
                return null;
            }
            if (propertiesTag != null) {
                properties = new HashMap<String, String>();
                for (Map.Entry entry : propertiesTag.getValue().entrySet()) {
                    properties.put((String)entry.getKey(), ((StringTag)entry.getValue()).getValue());
                }
            } else {
                properties = null;
            }
            return Material.get(name, properties);
        }
    }
}

