/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import org.jnbt.CompoundTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.Platform;

public class Java115Level
extends JavaLevel {
    Java115Level(int mapHeight, Platform platform) {
        super(0, mapHeight, platform);
    }

    Java115Level(CompoundTag tag, int mapHeight) {
        super(tag, 0, mapHeight);
    }

    @Override
    public long getSeed() {
        return this.getLong("RandomSeed");
    }

    @Override
    public void setSeed(long seed) {
        this.setLong("RandomSeed", seed);
    }

    @Override
    public boolean isMapFeatures() {
        return this.getBoolean("MapFeatures");
    }

    @Override
    public void setMapFeatures(boolean mapFeatures) {
        this.setBoolean("MapFeatures", mapFeatures);
    }

    @Override
    public MapGenerator getGenerator(int dim) {
        switch (dim) {
            case 0: {
                String generatorName = this.getGeneratorName();
                if (generatorName == null) {
                    return MapGenerator.UNKNOWN;
                }
                if ("FLAT".equalsIgnoreCase(generatorName)) {
                    Tag generatorOptions = this.getGeneratorOptions();
                    SuperflatPreset preset = generatorOptions instanceof StringTag ? SuperflatPreset.fromMinecraft1_12_2(((StringTag)generatorOptions).getValue()) : SuperflatPreset.fromMinecraft1_15_2((CompoundTag)generatorOptions);
                    return new SuperflatGenerator(preset);
                }
                if ("largeBiomes".equals(generatorName)) {
                    return new SeededGenerator(Generator.LARGE_BIOMES, this.getSeed());
                }
                if ("DEFAULT".equalsIgnoreCase(generatorName)) {
                    return new SeededGenerator(Generator.DEFAULT, this.getSeed());
                }
                if ("BUFFET".equalsIgnoreCase(generatorName)) {
                    return new SeededGenerator(Generator.BUFFET, this.getSeed());
                }
                if ("CUSTOMIZED".equalsIgnoreCase(generatorName)) {
                    return new SeededGenerator(Generator.CUSTOMIZED, this.getSeed());
                }
                if ("amplified".equalsIgnoreCase(generatorName)) {
                    return new SeededGenerator(Generator.AMPLIFIED, this.getSeed());
                }
                return new CustomGenerator(this.getGeneratorName(), null);
            }
            case 1: 
            case 2: {
                return new SeededGenerator(Generator.DEFAULT, this.getSeed());
            }
        }
        return MapGenerator.UNKNOWN;
    }

    @Override
    public void setGenerator(int dim, MapGenerator generator) {
        block0 : switch (dim) {
            case 0: {
                if (generator instanceof SeededGenerator) {
                    this.setSeed(((SeededGenerator)generator).getSeed());
                }
                switch (generator.getType()) {
                    case UNKNOWN: {
                        break block0;
                    }
                    case DEFAULT: 
                    case NETHER: 
                    case END: {
                        if (this.getVersion() == 19132) {
                            this.setString("generatorName", "DEFAULT");
                            break block0;
                        }
                        this.setString("generatorName", "default");
                        this.setInt("generatorVersion", 1);
                        break block0;
                    }
                    case FLAT: {
                        if (this.getVersion() == 19132) {
                            this.setString("generatorName", "FLAT");
                        } else {
                            this.setString("generatorName", "flat");
                        }
                        SuperflatPreset preset = ((SuperflatGenerator)generator).getSettings();
                        if (preset == null) {
                            preset = SuperflatPreset.defaultPreset(this.platform);
                        }
                        if (this.platform == DefaultPlugin.JAVA_MCREGION || this.platform == DefaultPlugin.JAVA_ANVIL) {
                            this.setGeneratorOptions((Tag)new StringTag("generatorOptions", preset.toMinecraft1_12_2()));
                            break block0;
                        }
                        this.setGeneratorOptions((Tag)preset.toMinecraft1_15_2());
                        break block0;
                    }
                    case LARGE_BIOMES: {
                        if (this.getVersion() == 19132) {
                            throw new IllegalArgumentException("Large biomes not supported for Minecraft 1.1 maps");
                        }
                        this.setString("generatorName", "largeBiomes");
                        this.setInt("generatorVersion", 0);
                        break block0;
                    }
                    case CUSTOM: {
                        CustomGenerator customGenerator = (CustomGenerator)generator;
                        this.setString("generatorName", customGenerator.getName());
                        if (customGenerator.getSettings() == null) break block0;
                        this.setGeneratorOptions(customGenerator.getSettings());
                        break block0;
                    }
                    case AMPLIFIED: {
                        if (this.getVersion() == 19132) {
                            throw new IllegalArgumentException("Amplified not supported for Minecraft 1.1 maps");
                        }
                        this.setString("generatorName", "amplified");
                        this.setInt("generatorVersion", 0);
                        break block0;
                    }
                    case BUFFET: 
                    case CUSTOMIZED: {
                        throw new IllegalArgumentException(generator.getType().getDisplayName() + " not supported for Exporting");
                    }
                    default: {
                        throw new IllegalArgumentException("Use setGeneratorName(String) for generator " + generator);
                    }
                }
            }
            case 1: {
                if (generator.getType() == Generator.NETHER) break;
                throw new IllegalArgumentException("Generator type " + generator.getType().getDisplayName() + " not supported for Nether dimension");
            }
            case 2: {
                if (generator.getType() == Generator.END) break;
                throw new IllegalArgumentException("Generator type " + generator.getType().getDisplayName() + " not supported for End dimension");
            }
            default: {
                if (generator.getType() == Generator.DEFAULT) break;
                throw new IllegalArgumentException("Generator type " + generator.getType().getDisplayName() + " not supported for dimension " + dim);
            }
        }
    }

    private Tag getGeneratorOptions() {
        return this.getTag("generatorOptions");
    }

    private void setGeneratorOptions(Tag generatorOptions) {
        this.setTag("generatorOptions", generatorOptions);
    }

    public String getGeneratorName() {
        return this.getString("generatorName");
    }

    public int getGeneratorVersion() {
        return this.getInt("generatorVersion");
    }
}

