/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.minecraft;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jnbt.ByteArrayTag;
import org.jnbt.ByteTag;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.FloatTag;
import org.jnbt.IntArrayTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.LongArrayTag;
import org.jnbt.LongTag;
import org.jnbt.ShortTag;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.NBTItem;

public abstract class AbstractNBTItem
implements NBTItem,
Serializable,
Cloneable {
    private CompoundTag tag;
    private Map<DataType, CompoundTag> tags;
    private static final CompoundTag EMPTY = new CompoundTag("", Collections.emptyMap());
    private static final long serialVersionUID = 1L;

    protected AbstractNBTItem(CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException();
        }
        this.tag = tag;
        this.tags = null;
    }

    protected AbstractNBTItem(Map<DataType, CompoundTag> tags) {
        tags.forEach((key, value) -> {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
        });
        this.tags = new HashMap<DataType, CompoundTag>(tags);
        this.tag = null;
    }

    public CompoundTag toNBT() {
        if (this.tag == null) {
            throw new UnsupportedOperationException("This NBT item has no single tag");
        }
        return this.tag;
    }

    @Override
    public Map<DataType, ? extends Tag> toMultipleNBT() {
        if (this.tags != null) {
            return this.tags;
        }
        return ImmutableMap.of((Object)((Object)DataType.REGION), (Object)this.toNBT());
    }

    protected final Map<String, Tag> getAllTags() {
        return this.tag.getValue();
    }

    protected final boolean containsTag(String name) {
        return this.tag.containsTag(name);
    }

    protected final Tag getTag(String name) {
        return this.tag.getTag(name);
    }

    protected final void setTag(String name, Tag tag) {
        this.tag.setTag(name, tag);
    }

    protected final Map<String, Tag> getMap(String name) {
        CompoundTag compoundTag = (CompoundTag)this.tag.getTag(name);
        return compoundTag != null ? compoundTag.getValue() : null;
    }

    protected final void setMap(String name, Map<String, Tag> value) {
        this.tag.setTag(name, (Tag)(value != null ? new CompoundTag(name, value) : null));
    }

    protected final long getLong(String name) {
        return this.getLong(name, 0L);
    }

    protected final long getLong(String name, long defaultValue) {
        LongTag longTag = (LongTag)this.tag.getTag(name);
        return longTag != null ? longTag.getValue() : defaultValue;
    }

    protected final void setLong(String name, long value) {
        this.tag.setTag(name, (Tag)new LongTag(name, value));
    }

    protected final int getInt(String name) {
        return this.getInt(name, 0);
    }

    protected final int getInt(String name, int defaultValue) {
        IntTag intTag = (IntTag)this.tag.getTag(name);
        return intTag != null ? intTag.getValue() : defaultValue;
    }

    protected final void setInt(String name, int value) {
        this.tag.setTag(name, (Tag)new IntTag(name, value));
    }

    protected final String getString(String name) {
        return this.getString(name, null);
    }

    protected final String getString(String name, String defaultValue) {
        StringTag stringTag = (StringTag)this.tag.getTag(name);
        return stringTag != null ? stringTag.getValue() : defaultValue;
    }

    protected final void setString(String name, String value) {
        if (value != null) {
            this.tag.setTag(name, (Tag)new StringTag(name, value));
        } else {
            this.tag.setTag(name, null);
        }
    }

    protected final short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    protected final short getShort(String name, short defaultValue) {
        ShortTag shortTag = (ShortTag)this.tag.getTag(name);
        return shortTag != null ? shortTag.getValue() : defaultValue;
    }

    protected final void setShort(String name, short value) {
        this.tag.setTag(name, (Tag)new ShortTag(name, value));
    }

    protected final byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    protected final byte getByte(String name, byte defaultValue) {
        ByteTag byteTag = (ByteTag)this.tag.getTag(name);
        return byteTag != null ? byteTag.getValue() : defaultValue;
    }

    protected final void setByte(String name, byte value) {
        this.tag.setTag(name, (Tag)new ByteTag(name, value));
    }

    protected final boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    protected final boolean getBoolean(String name, boolean defaultValue) {
        ByteTag byteTag = (ByteTag)this.tag.getTag(name);
        return byteTag != null ? byteTag.getValue() != 0 : defaultValue;
    }

    protected final void setBoolean(String name, boolean value) {
        this.tag.setTag(name, (Tag)new ByteTag(name, value ? (byte)1 : 0));
    }

    protected final float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    protected final float getFloat(String name, float defaultValue) {
        FloatTag floatTag = (FloatTag)this.tag.getTag(name);
        return floatTag != null ? floatTag.getValue() : defaultValue;
    }

    protected final void setFloat(String name, float value) {
        this.tag.setTag(name, (Tag)new FloatTag(name, value));
    }

    protected final double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    protected final double getDouble(String name, double defaultValue) {
        DoubleTag doubleTag = (DoubleTag)this.tag.getTag(name);
        return doubleTag != null ? doubleTag.getValue() : defaultValue;
    }

    protected final void setDouble(String name, double value) {
        this.tag.setTag(name, (Tag)new DoubleTag(name, value));
    }

    protected final <T extends Tag> List<T> getList(String name) {
        ListTag listTag = (ListTag)this.tag.getTag(name);
        return listTag != null ? listTag.getValue() : null;
    }

    protected final <T extends Tag> void setList(String name, Class<T> type, List<T> list) {
        this.tag.setTag(name, (Tag)(list != null ? new ListTag(name, type, list) : null));
    }

    protected final double[] getDoubleList(String name) {
        List list = this.getList(name);
        if (list != null) {
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((DoubleTag)list.get(i)).getValue();
            }
            return array;
        }
        return null;
    }

    protected final void setDoubleList(String name, double[] values) {
        if (values != null) {
            ArrayList<DoubleTag> list = new ArrayList<DoubleTag>(values.length);
            for (double value : values) {
                list.add(new DoubleTag(null, value));
            }
            this.tag.setTag(name, (Tag)new ListTag(name, DoubleTag.class, list));
        } else {
            this.tag.setTag(name, null);
        }
    }

    protected final float[] getFloatList(String name) {
        List list = this.getList(name);
        if (list != null) {
            float[] array = new float[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((FloatTag)list.get(i)).getValue();
            }
            return array;
        }
        return null;
    }

    protected final void setFloatList(String name, float[] values) {
        if (values != null) {
            ArrayList<FloatTag> list = new ArrayList<FloatTag>(values.length);
            for (float value : values) {
                list.add(new FloatTag(null, value));
            }
            this.tag.setTag(name, (Tag)new ListTag(name, FloatTag.class, list));
        } else {
            this.tag.setTag(name, null);
        }
    }

    protected final byte[] getByteArray(String name) {
        ByteArrayTag byteArrayTag = (ByteArrayTag)this.tag.getTag(name);
        return byteArrayTag != null ? byteArrayTag.getValue() : null;
    }

    protected final void setByteArray(String name, byte[] bytes) {
        this.tag.setTag(name, (Tag)(bytes != null ? new ByteArrayTag(name, bytes) : null));
    }

    protected final int[] getIntArray(String name) {
        IntArrayTag intArrayTag = (IntArrayTag)this.tag.getTag(name);
        return intArrayTag != null ? intArrayTag.getValue() : null;
    }

    protected final void setIntArray(String name, int[] values) {
        this.tag.setTag(name, (Tag)(values != null ? new IntArrayTag(name, values) : null));
    }

    protected final long[] getLongArray(String name) {
        LongArrayTag longArrayTag = (LongArrayTag)this.tag.getTag(name);
        return longArrayTag != null ? longArrayTag.getValue() : null;
    }

    protected final void setLongArray(String name, long[] values) {
        this.tag.setTag(name, (Tag)(values != null ? new LongArrayTag(name, values) : null));
    }

    protected final void removeTag(String name) {
        this.tag.setTag(name, null);
    }

    protected final Map<String, Tag> getAllTags(DataType type) {
        return this.tags.getOrDefault((Object)type, EMPTY).getValue();
    }

    protected final boolean containsTag(DataType type, String name) {
        return this.tags.getOrDefault((Object)type, EMPTY).containsTag(name);
    }

    protected final boolean containsType(DataType type) {
        return this.tags.containsKey((Object)type);
    }

    protected final void forEachTag(TagConsumer consumer) {
        for (Map.Entry<DataType, CompoundTag> tagsForType : this.tags.entrySet()) {
            DataType type = tagsForType.getKey();
            for (Map.Entry entry : tagsForType.getValue().getValue().entrySet()) {
                consumer.accept(type, (String)entry.getKey(), (Tag)entry.getValue());
            }
        }
    }

    protected final Tag getTag(DataType type, String name) {
        return this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
    }

    protected final void setTag(DataType type, String name, Tag tag) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, tag);
    }

    protected final Map<String, Tag> getMap(DataType type, String name) {
        CompoundTag compoundTag = (CompoundTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return compoundTag != null ? compoundTag.getValue() : null;
    }

    protected final void setMap(DataType type, String name, Map<String, Tag> value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)(value != null ? new CompoundTag(name, value) : null));
    }

    protected final long getLong(DataType type, String name) {
        return this.getLong(type, name, 0L);
    }

    protected final long getLong(DataType type, String name, long defaultValue) {
        LongTag longTag = (LongTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return longTag != null ? longTag.getValue() : defaultValue;
    }

    protected final void setLong(DataType type, String name, long value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new LongTag(name, value));
    }

    protected final int getInt(DataType type, String name) {
        return this.getInt(type, name, 0);
    }

    protected final int getInt(DataType type, String name, int defaultValue) {
        IntTag intTag = (IntTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return intTag != null ? intTag.getValue() : defaultValue;
    }

    protected final void setInt(DataType type, String name, int value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new IntTag(name, value));
    }

    protected final String getString(DataType type, String name) {
        return this.getString(type, name, null);
    }

    protected final String getString(DataType type, String name, String defaultValue) {
        StringTag stringTag = (StringTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return stringTag != null ? stringTag.getValue() : defaultValue;
    }

    protected final void setString(DataType type, String name, String value) {
        if (value != null) {
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new StringTag(name, value));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final short getShort(DataType type, String name) {
        return this.getShort(type, name, (short)0);
    }

    protected final short getShort(DataType type, String name, short defaultValue) {
        ShortTag shortTag = (ShortTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return shortTag != null ? shortTag.getValue() : defaultValue;
    }

    protected final void setShort(DataType type, String name, short value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ShortTag(name, value));
    }

    protected final byte getByte(DataType type, String name) {
        return this.getByte(type, name, (byte)0);
    }

    protected final byte getByte(DataType type, String name, byte defaultValue) {
        ByteTag byteTag = (ByteTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return byteTag != null ? byteTag.getValue() : defaultValue;
    }

    protected final void setByte(DataType type, String name, byte value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ByteTag(name, value));
    }

    protected final boolean getBoolean(DataType type, String name) {
        return this.getBoolean(type, name, false);
    }

    protected final boolean getBoolean(DataType type, String name, boolean defaultValue) {
        ByteTag byteTag = (ByteTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return byteTag != null ? byteTag.getValue() != 0 : defaultValue;
    }

    protected final void setBoolean(DataType type, String name, boolean value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ByteTag(name, value ? (byte)1 : 0));
    }

    protected final float getFloat(DataType type, String name) {
        return this.getFloat(type, name, 0.0f);
    }

    protected final float getFloat(DataType type, String name, float defaultValue) {
        FloatTag floatTag = (FloatTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return floatTag != null ? floatTag.getValue() : defaultValue;
    }

    protected final void setFloat(DataType type, String name, float value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new FloatTag(name, value));
    }

    protected final double getDouble(DataType type, String name) {
        return this.getDouble(type, name, 0.0);
    }

    protected final double getDouble(DataType type, String name, double defaultValue) {
        DoubleTag doubleTag = (DoubleTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return doubleTag != null ? doubleTag.getValue() : defaultValue;
    }

    protected final void setDouble(DataType type, String name, double value) {
        this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new DoubleTag(name, value));
    }

    protected final <T extends Tag> List<T> getList(DataType type, String name) {
        ListTag listTag = (ListTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return listTag != null ? listTag.getValue() : null;
    }

    protected final <T extends Tag> void setList(DataType dataType, String name, Class<T> type, List<T> list) {
        if (list != null) {
            this.tags.computeIfAbsent(dataType, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ListTag(name, type, list));
        } else {
            this.tags.getOrDefault((Object)dataType, EMPTY).setTag(name, null);
        }
    }

    protected final double[] getDoubleList(DataType type, String name) {
        List list = this.getList(type, name);
        if (list != null) {
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((DoubleTag)list.get(i)).getValue();
            }
            return array;
        }
        return null;
    }

    protected final void setDoubleList(DataType type, String name, double[] values) {
        if (values != null) {
            ArrayList<DoubleTag> list = new ArrayList<DoubleTag>(values.length);
            for (double value : values) {
                list.add(new DoubleTag(null, value));
            }
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ListTag(name, DoubleTag.class, list));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final float[] getFloatList(DataType type, String name) {
        List list = this.getList(type, name);
        if (list != null) {
            float[] array = new float[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((FloatTag)list.get(i)).getValue();
            }
            return array;
        }
        return null;
    }

    protected final void setFloatList(DataType type, String name, float[] values) {
        if (values != null) {
            ArrayList<FloatTag> list = new ArrayList<FloatTag>(values.length);
            for (float value : values) {
                list.add(new FloatTag(null, value));
            }
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ListTag(name, FloatTag.class, list));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final byte[] getByteArray(DataType type, String name) {
        ByteArrayTag byteArrayTag = (ByteArrayTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return byteArrayTag != null ? byteArrayTag.getValue() : null;
    }

    protected final void setByteArray(DataType type, String name, byte[] bytes) {
        if (bytes != null) {
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new ByteArrayTag(name, bytes));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final int[] getIntArray(DataType type, String name) {
        IntArrayTag intArrayTag = (IntArrayTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return intArrayTag != null ? intArrayTag.getValue() : null;
    }

    protected final void setIntArray(DataType type, String name, int[] values) {
        if (values != null) {
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new IntArrayTag(name, values));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final long[] getLongArray(DataType type, String name) {
        LongArrayTag longArrayTag = (LongArrayTag)this.tags.getOrDefault((Object)type, EMPTY).getTag(name);
        return longArrayTag != null ? longArrayTag.getValue() : null;
    }

    protected final void setLongArray(DataType type, String name, long[] values) {
        if (values != null) {
            this.tags.computeIfAbsent(type, t -> new CompoundTag("", new HashMap())).setTag(name, (Tag)new LongArrayTag(name, values));
        } else {
            this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
        }
    }

    protected final void removeTag(DataType type, String name) {
        this.tags.getOrDefault((Object)type, EMPTY).setTag(name, null);
    }

    public String toString() {
        return this.tag != null ? this.tag.toString() : this.tags.toString();
    }

    public AbstractNBTItem clone() {
        try {
            AbstractNBTItem clone = (AbstractNBTItem)super.clone();
            if (this.tag != null) {
                clone.tag = this.tag.clone();
            } else {
                clone.tags = new HashMap<DataType, CompoundTag>();
                this.tags.forEach((type, tag) -> clone.tags.put((DataType)((Object)type), tag.clone()));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    static interface TagConsumer {
        public void accept(DataType var1, String var2, Tag var3);
    }
}

