/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class LookAndFeelChangeUtil {
    private static WeakHashMap<Object, LookAndFeelChangeHandler<?>> lookAndFeelChangeHandlers = new WeakHashMap();

    private static void invokeLookAndFeelHandler(Object parent, LookAndFeelChangeHandler handler) {
        handler.lookAndFeelChanged(parent);
    }

    public static <T> void onLookAndFeelChange(@NotNull T parent, @NotNull LookAndFeelChangeHandler<T> handler) {
        lookAndFeelChangeHandlers.put(parent, handler);
    }

    static {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    for (Map.Entry entry : lookAndFeelChangeHandlers.entrySet()) {
                        if (entry == null) continue;
                        Object parent = entry.getKey();
                        LookAndFeelChangeHandler handler = (LookAndFeelChangeHandler)entry.getValue();
                        if (handler == null) continue;
                        LookAndFeelChangeUtil.invokeLookAndFeelHandler(parent, handler);
                    }
                }
            }
        });
    }

    public static interface LookAndFeelChangeHandler<T> {
        public void lookAndFeelChanged(T var1);
    }
}

