/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.json.simple.JSONObject;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private DynmapCore core;
    public static final String USERID_GUEST = "_guest_";
    public static final String USERID_ATTRIB = "userid";
    public static final String LOGIN_PAGE = "../login.html";
    public static final String LOGIN_POST = "/up/login";
    private Charset cs_utf8 = Charset.forName("UTF-8");

    public LoginServlet(DynmapCore core) {
        this.core = core;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    private void sendResponse(HttpServletResponse resp, String rslt) throws ServletException, IOException {
        JSONObject json = new JSONObject();
        JSONUtils.s(json, "result", rslt);
        byte[] b = json.toJSONString().getBytes(this.cs_utf8);
        String dateStr = new Date().toString();
        resp.addHeader("Date", dateStr);
        resp.setContentType("text/plain; charset=utf-8");
        resp.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        resp.addHeader("Last-modified", dateStr);
        resp.setContentLength(b.length);
        resp.getOutputStream().write(b);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri;
        HttpSession sess = req.getSession(true);
        String uid = (String)sess.getAttribute(USERID_ATTRIB);
        if (uid == null) {
            uid = USERID_GUEST;
            sess.setAttribute(USERID_ATTRIB, (Object)uid);
        }
        if (sess.isNew()) {
            sess.setMaxInactiveInterval(60);
        }
        if ((uri = req.getRequestURI()).equals(LOGIN_POST)) {
            uid = req.getParameter("j_username");
            String pwd = req.getParameter("j_password");
            if (uid == null || uid.equals("")) {
                uid = USERID_GUEST;
            }
            if (this.core.checkLogin(uid, pwd)) {
                sess.setAttribute(USERID_ATTRIB, (Object)uid);
                this.sendResponse(resp, "success");
            } else {
                this.sendResponse(resp, "loginfailed");
            }
        } else if (uri.equals("/up/register")) {
            uid = req.getParameter("j_username");
            String pwd = req.getParameter("j_password");
            String vpwd = req.getParameter("j_verify_password");
            String passcode = req.getParameter("j_passcode");
            if (pwd == null || vpwd == null || !pwd.equals(vpwd)) {
                resp.sendRedirect("../login.html?error=verifyfailed");
                this.sendResponse(resp, "verifyfailed");
            } else if (this.core.registerLogin(uid, pwd, passcode)) {
                sess.setAttribute(USERID_ATTRIB, (Object)uid);
                this.sendResponse(resp, "success");
            } else {
                this.sendResponse(resp, "registerfailed");
            }
        } else {
            this.sendResponse(resp, "loginfailed");
        }
    }

    public void destroy() {
    }
}

