/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dynmap.modsupport.BigChestTextureFile;
import org.dynmap.modsupport.BiomeTextureFile;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ChestTextureFile;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.CustomTextureFile;
import org.dynmap.modsupport.GridTextureFile;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.ShulkerTextureFile;
import org.dynmap.modsupport.SignTextureFile;
import org.dynmap.modsupport.SkinTextureFile;
import org.dynmap.modsupport.impl.BigChestTextureFileImpl;
import org.dynmap.modsupport.impl.BiomeTextureFileImpl;
import org.dynmap.modsupport.impl.BlockTextureRecordImpl;
import org.dynmap.modsupport.impl.ChestTextureFileImpl;
import org.dynmap.modsupport.impl.CopyBlockTextureRecordImpl;
import org.dynmap.modsupport.impl.CustomTextureFileImpl;
import org.dynmap.modsupport.impl.GridTextureFileImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;
import org.dynmap.modsupport.impl.ShulkerTextureFileImpl;
import org.dynmap.modsupport.impl.SignTextureFileImpl;
import org.dynmap.modsupport.impl.SkinTextureFileImpl;
import org.dynmap.modsupport.impl.TextureFileImpl;

public class ModTextureDefinitionImpl
implements ModTextureDefinition {
    private final String modid;
    private final String modver;
    private ModModelDefinitionImpl modDef = null;
    private String texturePath;
    private LinkedHashMap<String, TextureFileImpl> txtFileByID = new LinkedHashMap();
    private ArrayList<BlockTextureRecordImpl> blkTextureRec = new ArrayList();
    private ArrayList<CopyBlockTextureRecordImpl> blkCopyTextureRec = new ArrayList();
    private boolean published = false;

    public ModTextureDefinitionImpl(String modid, String modver) {
        this.modid = modid;
        this.modver = modver;
        this.texturePath = "assets/" + modid.toLowerCase() + "/textures/blocks/";
    }

    public String getModID() {
        return this.modid;
    }

    public String getModVersion() {
        return this.modver;
    }

    public ModModelDefinition getModelDefinition() {
        if (this.modDef == null) {
            this.modDef = new ModModelDefinitionImpl(this);
        }
        return this.modDef;
    }

    public boolean publishDefinition() {
        this.published = true;
        return true;
    }

    public void setTexturePath(String txtpath) {
        this.texturePath = txtpath;
        if (!this.texturePath.endsWith("/")) {
            this.texturePath = this.texturePath + "/";
        }
        if (this.texturePath.startsWith("/")) {
            this.texturePath = this.texturePath.substring(1);
        }
    }

    public String getTexturePath() {
        return this.texturePath;
    }

    private TextureFileImpl registerTextureFile(TextureFileImpl tfi) {
        TextureFileImpl orig_tfi = this.txtFileByID.get(tfi.getTextureID());
        if (orig_tfi == null) {
            this.txtFileByID.put(tfi.getTextureID(), tfi);
        } else {
            tfi = orig_tfi.equals(tfi) ? orig_tfi : null;
        }
        return tfi;
    }

    private String getDefFilename(String id) {
        return this.texturePath + id + ".png";
    }

    public GridTextureFile registerTextureFile(String id) {
        return (GridTextureFile)this.registerTextureFile(new GridTextureFileImpl(id, this.getDefFilename(id), 1, 1));
    }

    public GridTextureFile registerTextureFile(String id, String filename) {
        return (GridTextureFile)this.registerTextureFile(new GridTextureFileImpl(id, filename, 1, 1));
    }

    public ChestTextureFile registerChestTextureFile(String id, String filename) {
        return (ChestTextureFile)this.registerTextureFile(new ChestTextureFileImpl(id, filename));
    }

    public BigChestTextureFile registerBigChestTextureFile(String id, String filename) {
        return (BigChestTextureFile)this.registerTextureFile(new BigChestTextureFileImpl(id, filename));
    }

    public SignTextureFile registerSignTextureFile(String id, String filename) {
        return (SignTextureFile)this.registerTextureFile(new SignTextureFileImpl(id, filename));
    }

    public SkinTextureFile registerSkinTextureFile(String id, String filename) {
        return (SkinTextureFile)this.registerTextureFile(new SkinTextureFileImpl(id, filename));
    }

    public ShulkerTextureFile registerShulkerTextureFile(String id, String filename) {
        return (ShulkerTextureFile)this.registerTextureFile(new ShulkerTextureFileImpl(id, filename));
    }

    public GridTextureFile registerGridTextureFile(String id, String filename, int xcount, int ycount) {
        return (GridTextureFile)this.registerTextureFile(new GridTextureFileImpl(id, filename, xcount, ycount));
    }

    public CustomTextureFile registerCustomTextureFile(String id, String filename, int xcount, int ycount) {
        return (CustomTextureFile)this.registerTextureFile(new CustomTextureFileImpl(id, filename, xcount, ycount));
    }

    public BiomeTextureFile registerBiomeTextureFile(String id, String filename) {
        return (BiomeTextureFile)this.registerTextureFile(new BiomeTextureFileImpl(id, filename));
    }

    @Deprecated
    public BlockTextureRecord addBlockTextureRecord(int blockID) {
        BlockTextureRecordImpl btr = new BlockTextureRecordImpl(blockID);
        this.blkTextureRec.add(btr);
        return btr;
    }

    public BlockTextureRecord addBlockTextureRecord(String blockname) {
        BlockTextureRecordImpl btr = new BlockTextureRecordImpl(blockname);
        this.blkTextureRec.add(btr);
        return btr;
    }

    @Deprecated
    public CopyBlockTextureRecord addCopyBlockTextureRecord(int blockID, int srcBlockID, int srcMeta) {
        CopyBlockTextureRecordImpl btr = new CopyBlockTextureRecordImpl(blockID, srcBlockID, srcMeta);
        this.blkCopyTextureRec.add(btr);
        return btr;
    }

    @Deprecated
    public CopyBlockTextureRecord addCopyBlockTextureRecord(String blockname, String srcBlockName, int srcMeta) {
        CopyBlockTextureRecordImpl btr = new CopyBlockTextureRecordImpl(blockname, srcBlockName, srcMeta);
        this.blkCopyTextureRec.add(btr);
        return btr;
    }

    public CopyBlockTextureRecord addCopyBlockTextureRecord(String blockname, String srcBlockName, Map<String, String> srcStateMap) {
        CopyBlockTextureRecordImpl btr = new CopyBlockTextureRecordImpl(blockname, srcBlockName, srcStateMap);
        this.blkCopyTextureRec.add(btr);
        return btr;
    }

    public boolean isPublished() {
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File destdir) throws IOException {
        File f = new File(destdir, this.modid + "-texture.txt");
        try (FileWriter fw = null;){
            String line;
            fw = new FileWriter(f);
            String s = "modname:" + this.modid;
            fw.write(s + "\n\n");
            for (String string : this.txtFileByID.keySet()) {
                TextureFileImpl tfi = this.txtFileByID.get(string);
                String line2 = tfi.getLine();
                if (line2 == null) continue;
                fw.write(line2 + "\n");
            }
            for (BlockTextureRecordImpl blockTextureRecordImpl : this.blkTextureRec) {
                line = blockTextureRecordImpl.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
            for (CopyBlockTextureRecordImpl copyBlockTextureRecordImpl : this.blkCopyTextureRec) {
                line = copyBlockTextureRecordImpl.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
        }
    }
}

