/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RPMicroRenderer
extends CustomRenderer {
    private static final String[] tileFields = new String[]{"cvs", "cvm"};
    private static final int NUM_TEXTURES = 70;
    private static final int[][] materialTextureMap = new int[][]{{0}, {1}, {2}, {59, 60, 3, 3, 3, 3}, {4}, {5}, {6}, {7}, {8}, {9}, {2, 2, 10, 10, 10, 10}, {11}, {61, 61, 12, 12, 12, 12}, {61, 61, 13, 13, 13, 13}, {61, 61, 14, 14, 14, 14}, {15}, {62, 62, 16, 16, 16, 16}, {17}, {18}, {19}, {20}, {21}, {63, 63, 22, 22, 22, 22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {60, 60, 31, 31, 31, 31}, {32}, {33}, {34}, {35}, {36}, {37}, {38}, {39}, {40}, {41}, {42}, {43}, {44}, {45}, {46}, {47}, {48}, {49}, {50}, {51}, {52}, {64, 64, 53, 53, 53, 53}, {54}, {55}, {56}, {65}, {66}, {0}, {0}, {0}, {0}, {0}, {60, 60, 57, 57, 57, 57}, {61, 61, 58, 58, 58, 58}, {67}, {68}, {69}};
    private static final double[] thick_0_5 = new double[]{0.125, 0.25, 0.5, 0.125, 0.25, 0.5, 0.375, 0.625, 0.75, 0.875, 0.375, 0.625, 0.75, 0.875};
    private static final double[] thick_6_25 = new double[]{0.125, 0.25, 0.5, 0.375, 0.625, 0.75, 0.875};
    private static final double[] thick_26_28 = new double[]{0.125, 0.25, 0.375};

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        for (int i = 0; i < materialTextureMap.length; ++i) {
            if (materialTextureMap[i].length >= 6) continue;
            int[] sides = new int[6];
            Arrays.fill(sides, materialTextureMap[i][0]);
            RPMicroRenderer.materialTextureMap[i] = sides;
        }
        return true;
    }

    public int getMaximumTextureCount() {
        return 70;
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int covermask = 0;
        byte[] covervals = new byte[58];
        Object v = ctx.getBlockTileEntityField("cvm");
        if (v instanceof Integer) {
            covermask = (Integer)v;
        }
        if ((v = ctx.getBlockTileEntityField("cvs")) instanceof byte[]) {
            covervals = (byte[])v;
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int off = 0;
        for (int i = 0; i < 29; ++i) {
            if ((covermask & 1 << i) == 0) continue;
            this.addPatchesFor(ctx.getPatchFactory(), list, i, covervals[off], covervals[off + 1]);
            off += 2;
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private boolean isHollow(int shape, int thickness) {
        if (shape < 6) {
            switch (thickness) {
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    private double getThickness(int shape, int thickness) {
        if (shape < 6) {
            double[] v = thick_0_5;
            if (thickness < v.length) {
                return v[thickness];
            }
            return 1.0;
        }
        if (shape >= 26 && shape < 29) {
            double[] v = thick_26_28;
            if (thickness < v.length) {
                return v[thickness];
            }
            return v[0];
        }
        double[] v = thick_6_25;
        if (thickness < v.length) {
            return v[thickness];
        }
        return 1.0;
    }

    private void addPatchesFor(RenderPatchFactory rpf, ArrayList<RenderPatch> list, int shape, int material, int thickness) {
        if (material < 0 || material >= materialTextureMap.length) {
            material = 0;
        }
        int[] sides = materialTextureMap[material];
        double thick = this.getThickness(shape, thickness);
        if (this.isHollow(shape, thickness)) {
            switch (shape) {
                case 0: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.75, (double)0.0, (double)thick, (double)0.0, (double)0.25, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.75, (double)1.0, (double)0.0, (double)thick, (double)0.0, (double)0.75, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.25, (double)1.0, (double)0.0, (double)thick, (double)0.75, (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.25, (double)0.0, (double)thick, (double)0.25, (double)1.0, (int[])sides);
                    break;
                }
                case 1: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.75, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)0.25, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.75, (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)0.75, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.25, (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.75, (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.25, (double)(1.0 - thick), (double)1.0, (double)0.25, (double)1.0, (int[])sides);
                    break;
                }
                case 2: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.75, (double)0.0, (double)0.25, (double)0.0, (double)thick, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.75, (double)1.0, (double)0.0, (double)0.75, (double)0.0, (double)thick, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.25, (double)1.0, (double)0.75, (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.25, (double)0.25, (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 3: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.75, (double)0.0, (double)0.25, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.75, (double)1.0, (double)0.0, (double)0.75, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.25, (double)1.0, (double)0.75, (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)0.25, (double)0.25, (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 4: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)0.75, (double)0.0, (double)0.25, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.75, (double)1.0, (double)0.0, (double)0.75, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.25, (double)1.0, (double)0.75, (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)0.25, (double)0.25, (double)1.0, (int[])sides);
                    break;
                }
                case 5: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)0.75, (double)0.0, (double)0.25, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.75, (double)1.0, (double)0.0, (double)0.75, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.25, (double)1.0, (double)0.75, (double)1.0, (int[])sides);
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)0.25, (double)0.25, (double)1.0, (int[])sides);
                }
            }
        } else {
            switch (shape) {
                case 0: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)thick, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 1: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 2: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 3: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 4: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 5: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 6: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)thick, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 7: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 8: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 9: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 10: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 11: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 12: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 13: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 14: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)thick, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 15: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 16: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)thick, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 17: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 18: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 19: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 20: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 21: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 22: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)thick, (int[])sides);
                    break;
                }
                case 23: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (int[])sides);
                    break;
                }
                case 24: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)thick, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 25: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(1.0 - thick), (double)1.0, (double)(1.0 - thick), (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 26: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(0.5 - thick), (double)(0.5 + thick), (double)0.0, (double)1.0, (double)(0.5 - thick), (double)(0.5 + thick), (int[])sides);
                    break;
                }
                case 27: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)(0.5 - thick), (double)(0.5 + thick), (double)(0.5 - thick), (double)(0.5 + thick), (double)0.0, (double)1.0, (int[])sides);
                    break;
                }
                case 28: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)(0.5 - thick), (double)(0.5 + thick), (double)(0.5 - thick), (double)(0.5 + thick), (int[])sides);
                    break;
                }
                default: {
                    CustomRenderer.addBox((RenderPatchFactory)rpf, list, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0, (int[])sides);
                }
            }
        }
    }

    public String[] getTileEntityFieldsNeeded() {
        return tileFields;
    }
}

