/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.hdmap.HDBlockStateTextureMap;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class FenceWallBlockRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private boolean check_yplus;
    private BitSet link_ids = new BitSet();
    private static final int SIDE_XP = 1;
    private static final int SIDE_XN = 2;
    private static final int SIDE_X = 3;
    private static final int SIDE_ZP = 4;
    private static final int SIDE_ZN = 8;
    private static final int SIDE_Z = 12;
    private static final int SIDE_YP = 16;
    private RenderPatch[][] meshes = new RenderPatch[32][];
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};
    private static int[][] sides = new int[][]{{1, 0, 0, 1}, {-1, 0, 0, 2}, {0, 0, 1, 4}, {0, 0, -1, 8}};

    private void addIDs(String bn) {
        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName((String)bn);
        if (bbs.isNotAir()) {
            for (int i = 0; i < bbs.getStateCount(); ++i) {
                DynmapBlockState bs = bbs.getState(i);
                this.link_ids.set(bs.globalStateIndex);
            }
        }
    }

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        String lid;
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.addIDs(blkname);
        String type = custparm.get("type");
        if (type != null && type.equals("wall")) {
            this.buildWallMeshes(rpf);
            this.check_yplus = true;
        } else {
            this.buildFenceMeshes(rpf);
        }
        int i = 0;
        while ((lid = custparm.get("link" + i)) != null) {
            this.addIDs(lid);
            ++i;
        }
        return true;
    }

    public int getMaximumTextureCount() {
        return 3;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        FenceWallBlockRenderer.addBox((RenderPatchFactory)rpf, list, (double)xmin, (double)xmax, (double)ymin, (double)ymax, (double)zmin, (double)zmax, (int[])patchlist);
    }

    private void buildFenceMeshes(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 16; ++dat) {
            this.addBox(rpf, list, 0.375, 0.625, 0.0, 1.0, 0.375, 0.625);
            switch (dat & 3) {
                case 1: {
                    this.addBox(rpf, list, 0.625, 1.0, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.625, 1.0, 0.75, 0.9275, 0.4375, 0.5625);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.375, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.0, 0.375, 0.75, 0.9275, 0.4375, 0.5625);
                    break;
                }
                case 3: {
                    this.addBox(rpf, list, 0.0, 1.0, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.0, 1.0, 0.75, 0.9275, 0.4375, 0.5625);
                }
            }
            switch (dat & 0xC) {
                case 4: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.625, 1.0);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.625, 1.0);
                    break;
                }
                case 8: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.0, 0.375);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.0, 0.375);
                    break;
                }
                case 12: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.0, 1.0);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.0, 1.0);
                }
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    private void buildWallMeshes(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 32; ++dat) {
            boolean need_post = (dat & 0xF) == 0 || (dat & 0x10) == 16;
            switch (dat & 3) {
                case 1: {
                    this.addBox(rpf, list, 0.75, 1.0, 0.0, 0.8125, 0.3125, 0.6875);
                    need_post = true;
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.25, 0.0, 0.8125, 0.3125, 0.6875);
                    need_post = true;
                    break;
                }
                case 3: {
                    this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.8125, 0.3125, 0.6875);
                }
            }
            switch (dat & 0xC) {
                case 4: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.75, 1.0);
                    need_post = true;
                    break;
                }
                case 8: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.0, 0.25);
                    need_post = true;
                    break;
                }
                case 12: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.0, 1.0);
                }
            }
            if (need_post) {
                this.addBox(rpf, list, 0.25, 0.75, 0.0, 1.0, 0.25, 0.75);
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int connect = 0;
        for (int i = 0; i < sides.length; ++i) {
            DynmapBlockState blk = ctx.getBlockTypeAt(sides[i][0], sides[i][1], sides[i][2]);
            if (blk.isAir() || !this.link_ids.get(blk.globalStateIndex) && HDBlockStateTextureMap.getTransparency(blk) != TexturePack.BlockTransparency.OPAQUE) continue;
            connect |= sides[i][3];
        }
        if (this.check_yplus && ctx.getBlockTypeAt(0, 1, 0).isNotAir()) {
            connect |= 0x10;
        }
        return this.meshes[connect];
    }
}

