/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CopyStairBlockRenderer
extends CustomRenderer {
    private static final int TEXTURE_X_PLUS = 0;
    private static final int TEXTURE_Y_PLUS = 1;
    private static final int TEXTURE_Z_PLUS = 2;
    private static final int TEXTURE_X_MINUS = 3;
    private static final int TEXTURE_Y_MINUS = 4;
    private static final int TEXTURE_Z_MINUS = 5;
    private static BitSet stair_ids = new BitSet();
    private RenderPatch[][] stepmeshes = new RenderPatch[8][];
    private RenderPatch[][] step_3_4_meshes = new RenderPatch[8][];
    private RenderPatch[][] step_1_4_meshes = new RenderPatch[8][];
    private static final int[] patchlist = new int[]{1, 4, 2, 5, 0, 3};
    private static final int[] off_x = new int[]{1, -1, 0, 0, 1, -1, 0, 0};
    private static final int[] off_z = new int[]{0, 0, 1, -1, 0, 0, 1, -1};
    private static final int[] match1 = new int[]{2, 3, 0, 1, 6, 7, 4, 5};
    private static final int[] corner1 = new int[]{3, 1, 3, 1, 7, 5, 7, 5};
    private static final int[] icorner1 = new int[]{1, 2, 1, 2, 5, 6, 5, 6};
    private static final int[] match2 = new int[]{3, 2, 1, 0, 7, 6, 5, 4};
    private static final int[] corner2 = new int[]{0, 2, 2, 0, 4, 6, 6, 4};
    private static final int[] icorner2 = new int[]{0, 3, 3, 0, 4, 7, 7, 4};

    private void setID(String bname) {
        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName((String)bname);
        if (bbs.isNotAir()) {
            for (int i = 0; i < bbs.getStateCount(); ++i) {
                stair_ids.set(bbs.getState((int)i).globalStateIndex);
            }
        }
    }

    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.setID(blkname);
        for (int i = 0; i < 8; ++i) {
            this.stepmeshes[i] = this.buildStepMeshes(rpf, i);
            this.step_1_4_meshes[i] = this.buildCornerStepMeshes(rpf, i);
            this.step_3_4_meshes[i] = this.buildIntCornerStepMeshes(rpf, i);
        }
        return true;
    }

    public int getMaximumTextureCount() {
        return 6;
    }

    public String[] getTileEntityFieldsNeeded() {
        return null;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        CopyStairBlockRenderer.addBox((RenderPatchFactory)rpf, list, (double)xmin, (double)xmax, (double)ymin, (double)ymax, (double)zmin, (double)zmax, (int[])patchlist);
    }

    private RenderPatch[] buildStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 0.5);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] buildIntCornerStepMeshes(RenderPatchFactory rpf, int dat) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if ((dat & 4) != 0) {
            this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0);
        } else {
            this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0);
        }
        switch (dat & 3) {
            case 0: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 1: {
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.5, 1.0);
                break;
            }
            case 2: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.0, 0.5);
                break;
            }
            case 3: {
                this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0);
                this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.5, 1.0);
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        return this.getBaseRenderPatchList(ctx);
    }

    private RenderPatch[] getBaseRenderPatchList(MapDataContext ctx) {
        DynmapBlockState side;
        int cornerdat;
        int data = ctx.getBlockType().stateIndex & 7;
        DynmapBlockState corner = ctx.getBlockTypeAt(off_x[data], 0, off_z[data]);
        if (stair_ids.get(corner.globalStateIndex)) {
            cornerdat = corner.stateIndex & 7;
            if (cornerdat == match1[data]) {
                side = ctx.getBlockTypeAt(-off_x[cornerdat], 0, -off_z[cornerdat]);
                if (!stair_ids.get(side.globalStateIndex) || (side.stateIndex & 7) != data) {
                    return this.step_1_4_meshes[corner1[data]];
                }
            } else if (cornerdat == match2[data]) {
                side = ctx.getBlockTypeAt(-off_x[cornerdat], 0, -off_z[cornerdat]);
                if (!stair_ids.get(side.globalStateIndex) || (side.stateIndex & 7) != data) {
                    return this.step_1_4_meshes[corner2[data]];
                }
            }
        }
        corner = ctx.getBlockTypeAt(-off_x[data], 0, -off_z[data]);
        if (stair_ids.get(corner.globalStateIndex)) {
            cornerdat = corner.stateIndex & 7;
            if (cornerdat == match1[data]) {
                side = ctx.getBlockTypeAt(off_x[cornerdat], 0, off_z[cornerdat]);
                if (!stair_ids.get(side.globalStateIndex) || (side.stateIndex & 7) != data) {
                    return this.step_3_4_meshes[icorner1[data]];
                }
            } else if (cornerdat == match2[data]) {
                side = ctx.getBlockTypeAt(off_x[cornerdat], 0, off_z[cornerdat]);
                if (!stair_ids.get(side.globalStateIndex) || (side.stateIndex & 7) != data) {
                    return this.step_3_4_meshes[icorner2[data]];
                }
            }
        }
        return this.stepmeshes[data];
    }
}

