/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.JSONUtils;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.json.simple.JSONObject;

public class DefaultHDLighting
implements HDLighting {
    private String name;
    protected boolean grayscale;
    protected boolean blackandwhite;
    protected int blackthreshold;
    protected final Color graytone;
    protected final Color graytonedark;

    public DefaultHDLighting(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        this.grayscale = configuration.getBoolean("grayscale", false);
        this.graytone = configuration.getColor("graytone", "#FFFFFF");
        this.graytonedark = configuration.getColor("graytonedark", "#000000");
        this.blackandwhite = configuration.getBoolean("blackandwhite", false);
        if (this.blackandwhite) {
            this.grayscale = false;
        }
        this.blackthreshold = configuration.getInteger("blackthreshold", 64);
    }

    protected void checkGrayscale(Color[] outcolor) {
        block4: {
            block3: {
                if (!this.grayscale) break block3;
                for (int i = 0; i < outcolor.length; ++i) {
                    outcolor[i].setGrayscale();
                    outcolor[i].scaleColor(this.graytonedark, this.graytone);
                }
                break block4;
            }
            if (!this.blackandwhite) break block4;
            for (int i = 0; i < outcolor.length; ++i) {
                outcolor[i].setGrayscale();
                if (outcolor[i].getRed() > this.blackthreshold) {
                    outcolor[i].setColor(this.graytone);
                    continue;
                }
                outcolor[i].setColor(this.graytonedark);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void applyLighting(HDPerspectiveState ps, HDShaderState ss, Color incolor, Color[] outcolor) {
        for (int i = 0; i < outcolor.length; ++i) {
            outcolor[i].setColor(incolor);
        }
        this.checkGrayscale(outcolor);
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return false;
    }

    @Override
    public boolean isNightAndDayEnabled() {
        return false;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "lighting", this.name);
        JSONUtils.s(mapObject, "nightandday", this.isNightAndDayEnabled());
    }

    @Override
    public int[] getBrightnessTable(DynmapWorld world) {
        return null;
    }
}

