/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.wintab;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jpen.PKind;
import jpen.PLevel;
import jpen.provider.AbstractPenDevice;
import jpen.provider.wintab.WintabAccess;
import jpen.provider.wintab.WintabProvider;

class WintabDevice
extends AbstractPenDevice {
    private static final Logger L = Logger.getLogger(WintabDevice.class.getName());
    private static final String PRINT_ALTITUDE_AND_AZIMUTH_SYSTEM_PROPERTY = "jpen.provider.wintab.WintabDevice.printAltitudeAndAzimuth";
    private static final boolean PRINT_ALTITUDE_AND_AZIMUTH = Boolean.valueOf(System.getProperty("jpen.provider.wintab.WintabDevice.printAltitudeAndAzimuth"));
    final WintabProvider wintabProvider;
    public final int cursor;
    private int lastButtonsValues;
    private final Point2D.Float componentLocation = new Point2D.Float();
    private final Dimension componentSize = new Dimension();
    private boolean useFractionalMovement = true;
    private final List<PLevel> changedLevels = new ArrayList<PLevel>();
    private static final float PI_2 = (float)Math.PI * 2;
    private static final double PI_over_2 = 1.5707963267948966;
    private static final double PI_over_2_over_900 = 0.0017453292519943296;
    private float correctAzimuthRangeMax = -1.0f;

    WintabDevice(WintabProvider wintabProvider, int cursor) {
        super(wintabProvider);
        L.fine("start");
        this.wintabProvider = wintabProvider;
        this.cursor = cursor;
        this.setKindTypeNumber(this.getDefaultKindTypeNumber());
        this.setEnabled(true);
        L.fine("end");
    }

    public final boolean getUseFractionalMovements() {
        return this.useFractionalMovement;
    }

    public void penManagerSetUseFractionalMovements(boolean useFractionalMovement) {
        this.useFractionalMovement = useFractionalMovement;
    }

    protected String evalPhysicalId() {
        return WintabAccess.getRawCursorType(this.cursor) + "." + WintabAccess.getPhysicalId(this.cursor) + "@" + this.wintabProvider.getConstructor().getName();
    }

    private int getDefaultKindTypeNumber() {
        WintabAccess.CursorType cursorType = WintabAccess.getCursorType(this.cursor);
        switch (cursorType) {
            case PENTIP: {
                return PKind.Type.STYLUS.ordinal();
            }
            case PENERASER: {
                return PKind.Type.ERASER.ordinal();
            }
            case PUCK: 
            case UNDEF: {
                String deviceName = this.getName().toLowerCase();
                if (deviceName.contains("stylus")) {
                    return PKind.Type.STYLUS.ordinal();
                }
                if (deviceName.contains("eraser")) {
                    return PKind.Type.ERASER.ordinal();
                }
                return cursorType.equals((Object)WintabAccess.CursorType.PUCK) ? PKind.Type.CURSOR.ordinal() : PKind.Type.STYLUS.ordinal();
            }
        }
        throw new AssertionError();
    }

    public String getName() {
        return WintabAccess.getCursorName(this.cursor).trim();
    }

    void scheduleEvents() {
        if (!this.getEnabled()) {
            L.fine("disabled");
            return;
        }
        this.scheduleLevelEvent();
    }

    private void scheduleLevelEvent() {
        int i = PLevel.Type.VALUES.size();
        while (--i >= 0) {
            PLevel.Type levelType = PLevel.Type.VALUES.get(i);
            float value = this.getMultRangedValue(levelType);
            this.changedLevels.add(new PLevel(levelType, value));
        }
        this.getPenManager().scheduleLevelEvent(this, this.wintabProvider.wintabAccess.getTime(), this.changedLevels, true);
        this.changedLevels.clear();
    }

    private float getMultRangedValue(PLevel.Type type) {
        if (PLevel.Type.TILT_TYPES.contains((Object)type)) {
            double rangedAltitude;
            double altitude = this.wintabProvider.wintabAccess.getValue(PLevel.Type.TILT_Y);
            if (altitude < 0.0) {
                altitude = -altitude;
            }
            if ((rangedAltitude = altitude / (double)this.wintabProvider.getLevelRange((PLevel.Type)PLevel.Type.TILT_Y).max) == 1.0) {
                if (PRINT_ALTITUDE_AND_AZIMUTH) {
                    System.out.println("rangedAlt: 1");
                }
                return 0.0f;
            }
            double betha = rangedAltitude * 1.5707963267948966;
            double azimuth = this.wintabProvider.wintabAccess.getValue(PLevel.Type.TILT_X);
            double rangedAzimuth = azimuth / (double)this.getCorrectAzimuthRangeMax();
            double theta = rangedAzimuth * 6.2831854820251465 - 1.5707963267948966;
            if (PRINT_ALTITUDE_AND_AZIMUTH) {
                System.out.printf("alt: %4.0f - az: %4.0f | rangedAlt: %1.3f - rangedAz: %1.3f \n", altitude, azimuth, rangedAltitude, rangedAzimuth);
            }
            switch (type) {
                case TILT_X: {
                    return (float)Math.atan(Math.cos(theta) / Math.tan(betha));
                }
                case TILT_Y: {
                    return (float)Math.atan(Math.sin(theta) / Math.tan(betha));
                }
            }
            throw new AssertionError();
        }
        float rangedValue = this.wintabProvider.getLevelRange(type).getRangedValue(this.wintabProvider.wintabAccess.getValue(type));
        if (PLevel.Type.MOVEMENT_TYPES.contains((Object)type)) {
            if (type.equals((Object)PLevel.Type.Y)) {
                rangedValue = 1.0f - rangedValue;
            }
            rangedValue = this.wintabProvider.screenBounds.getLevelRangeOffset(type) + rangedValue * this.wintabProvider.screenBounds.getLevelRangeMult(type);
        }
        if (PLevel.Type.ROTATION.equals((Object)type)) {
            rangedValue *= (float)Math.PI * 2;
        }
        return rangedValue;
    }

    private float getCorrectAzimuthRangeMax() {
        if (this.correctAzimuthRangeMax != -1.0f) {
            return this.correctAzimuthRangeMax;
        }
        this.correctAzimuthRangeMax = this.wintabProvider.getLevelRange((PLevel.Type)PLevel.Type.TILT_X).max;
        while (this.correctAzimuthRangeMax % 360.0f != 0.0f) {
            this.correctAzimuthRangeMax += 1.0f;
        }
        return this.correctAzimuthRangeMax;
    }
}

