/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.system;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PKind;
import jpen.PenProvider;
import jpen.provider.AbstractPenDevice;

final class KeyboardDevice
extends AbstractPenDevice {
    private static final Logger L = Logger.getLogger(KeyboardDevice.class.getName());
    private final AwtListener awtListener = new AwtListener();

    KeyboardDevice(PenProvider penProvider) {
        super(penProvider);
        this.setKindTypeNumber(PKind.Type.IGNORE.ordinal());
        this.setEnabled(true);
    }

    public String getName() {
        return "Keyboard";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(KeyboardDevice.this.awtListener, 24L);
                    return null;
                }
            });
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }
    }

    public boolean getUseFractionalMovements() {
        return false;
    }

    private static boolean getModifierValue(int modifiers, PButton.Type modifier) {
        int modifierMask = KeyboardDevice.getModifierMask(modifier);
        return (modifiers & modifierMask) == modifierMask;
    }

    private static int getModifierMask(PButton.Type modifier) {
        switch (modifier) {
            case CONTROL: {
                return 128;
            }
            case SHIFT: {
                return 64;
            }
            case ALT: {
                return 512;
            }
        }
        return 0;
    }

    void setPaused(boolean paused) {
        if (!paused) {
            this.awtListener.fireModifiers();
        }
    }

    class AwtListener
    implements AWTEventListener {
        private ModifiersInfo lastModifiersInfo;

        AwtListener() {
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev instanceof InputEvent) {
                InputEvent inputEvent = (InputEvent)ev;
                this.lastModifiersInfo = new ModifiersInfo(inputEvent);
                if (inputEvent.getID() == 504) {
                    this.fireModifiers();
                } else if (inputEvent instanceof KeyEvent) {
                    this.fireModifiers();
                }
            }
        }

        private void fireModifiers() {
            if (!KeyboardDevice.this.getEnabled()) {
                return;
            }
            ModifiersInfo modifiersInfo = this.lastModifiersInfo;
            if (modifiersInfo == null) {
                return;
            }
            for (PButton.Type modifierType : PButton.TypeGroup.MODIFIER.getTypes()) {
                boolean value = KeyboardDevice.getModifierValue(modifiersInfo.modifiersEx, modifierType);
                KeyboardDevice.this.getPenManager().scheduleButtonEvent(KeyboardDevice.this, modifiersInfo.when, new PButton(modifierType, (Boolean)value));
            }
        }
    }

    private static class ModifiersInfo {
        final int modifiersEx;
        final long when;

        ModifiersInfo(InputEvent inputEvent) {
            this.modifiersEx = inputEvent.getModifiersEx();
            this.when = inputEvent.getWhen();
        }
    }
}

