/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider;

import java.util.List;
import jpen.PKind;
import jpen.Pen;
import jpen.PenDevice;
import jpen.PenManager;
import jpen.PenProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPenDevice
implements PenDevice {
    private byte id;
    private String physicalId;
    private final PenProvider provider;
    private int kindTypeNumber = PKind.Type.CURSOR.ordinal();
    private boolean enabled;

    protected AbstractPenDevice(PenProvider provider) {
        this.provider = provider;
    }

    @Override
    public byte getId() {
        return this.id;
    }

    @Override
    public void penManagerSetId(byte id) {
        this.id = id;
    }

    @Override
    public PenProvider getProvider() {
        return this.provider;
    }

    @Override
    public int getKindTypeNumber() {
        return this.kindTypeNumber;
    }

    @Override
    public void setKindTypeNumber(int kindTypeNumber) {
        if (kindTypeNumber < 0) {
            throw new IllegalArgumentException("PKind.Type must be >= 0");
        }
        this.kindTypeNumber = kindTypeNumber;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalId() {
        String physicalId = this.physicalId;
        if (physicalId == null) {
            AbstractPenDevice abstractPenDevice = this;
            synchronized (abstractPenDevice) {
                physicalId = this.physicalId;
                if (physicalId == null) {
                    physicalId = this.physicalId = this.evalPhysicalId();
                }
            }
        }
        return physicalId;
    }

    protected String evalPhysicalId() {
        return this.getName().trim() + "@" + this.provider.getConstructor().getName().trim();
    }

    public final PenManager getPenManager() {
        return this.provider.getConstructor().getPenManager();
    }

    public final Pen getPen() {
        return this.getPenManager().pen;
    }

    @Override
    public boolean getUseFractionalMovements() {
        return true;
    }

    @Override
    public void penManagerSetUseFractionalMovements(boolean useFractionalMovement) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[PenDevice: provider=" + this.getProvider() + ", name=" + this.getName() + ", kind=" + (Object)((Object)AbstractPenDevice.getOrNull(PKind.Type.VALUES, this.getKindTypeNumber())) + "(" + this.getKindTypeNumber() + ")]";
    }

    private static final <T> T getOrNull(List<T> l, int index) {
        if (index < 0 || index >= l.size()) {
            return null;
        }
        return l.get(index);
    }
}

