/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal.filter;

import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jpen.internal.filter.RelativeLocationFilter;

final class LogToFileRule
implements RelativeLocationFilter.Rule {
    private static final Logger L = Logger.getLogger(LogToFileRule.class.getName());
    private int logFileStamp = 0;
    private List<Record> records;
    private static final DecimalFormat decimalFormat = new DecimalFormat("###0.0");

    LogToFileRule() {
    }

    public void reset() {
        if (this.records == null) {
            ++this.logFileStamp;
            this.records = new ArrayList<Record>();
        } else {
            this.records.clear();
        }
    }

    public RelativeLocationFilter.State evalFilterNextState(RelativeLocationFilter filter) {
        if (this.records == null) {
            return null;
        }
        if (this.records.size() >= 100) {
            this.writeRecords();
            this.records = null;
            return null;
        }
        this.records.add(new Record(filter));
        return RelativeLocationFilter.State.UNDEFINED;
    }

    private void writeRecords() {
        try {
            StringBuilder filePath = new StringBuilder();
            filePath.append("RelativeLocationFilter-");
            filePath.append(this.logFileStamp);
            filePath.append(".txt");
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filePath.toString())));
            for (int i = 0; i < this.records.size(); ++i) {
                Record record = this.records.get(i);
                writer.write(Integer.valueOf(i + 1).toString());
                writer.write(", reference=");
                this.writePoint(writer, record.samplePoint, record.reference.x, record.reference.y);
                writer.write(", sample=");
                this.writePoint(writer, record.samplePoint, record.samplePoint.levelX == null ? 0.0f : ((Float)record.samplePoint.levelX.value).floatValue(), record.samplePoint.levelY == null ? 0.0f : ((Float)record.samplePoint.levelY.value).floatValue());
                writer.write(", deviation=");
                this.writePoint(writer, record.samplePoint, record.deviation.x, record.deviation.y);
                writer.write("\n");
            }
            ((Writer)writer).close();
            L.info("written: " + filePath);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void writePoint(Writer writer, RelativeLocationFilter.SamplePoint samplePoint, float x, float y) throws IOException {
        writer.write("(");
        if (samplePoint.levelX != null) {
            this.writeValue(writer, x);
        } else {
            writer.write("??");
        }
        writer.write(", ");
        if (samplePoint.levelY != null) {
            this.writeValue(writer, y);
        } else {
            writer.write("??");
        }
        writer.write(")");
    }

    private void writeValue(Writer writer, float value) throws IOException {
        writer.write(decimalFormat.format(value));
    }

    static class Record {
        final RelativeLocationFilter.SamplePoint samplePoint;
        final Point2D.Float reference;
        final Point2D.Float deviation;

        Record(RelativeLocationFilter filter) {
            this.samplePoint = filter.samplePoint.clone();
            this.reference = new Point2D.Float();
            this.reference.setLocation(filter.reference);
            this.deviation = new Point2D.Float();
            this.deviation.setLocation(filter.deviation);
        }
    }
}

